/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoSettings;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeAcademicEntry;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType_Base;
import org.fenixedu.treasury.domain.Product;
import pt.ist.fenixframework.FenixFramework;

public class ERPTuitionInfoType
extends ERPTuitionInfoType_Base {
    public static final Comparator<ERPTuitionInfoType> COMPARE_BY_NAME = new Comparator<ERPTuitionInfoType>(){

        @Override
        public int compare(ERPTuitionInfoType o1, ERPTuitionInfoType o2) {
            int c = o1.getErpTuitionInfoProduct().getName().compareTo(o2.getErpTuitionInfoProduct().getName());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    public ERPTuitionInfoType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setErpTuitionInfoSettings(ERPTuitionInfoSettings.getInstance());
        this.setActive(true);
    }

    private ERPTuitionInfoType(ExecutionYear executionYear, ERPTuitionInfoProduct product, Set<Product> tuitionProducts) {
        this();
        this.setExecutionYear(executionYear);
        this.setErpTuitionInfoProduct(product);
        this.getTuitionProductsSet().addAll(tuitionProducts);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.bennu.required", new String[0]);
        }
        if (this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.executionYear.required", new String[0]);
        }
        if (this.getTuitionProductsSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.tuitionProducts.required", new String[0]);
        }
    }

    public boolean isActive() {
        return this.getActive();
    }

    public Degree getDegree() {
        return null;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return null;
    }

    public void delete() {
        if (!this.getErpTuitionInfosSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.delete.not.possible", new String[0]);
        }
        this.setDomainRoot(null);
        this.setErpTuitionInfoProduct(null);
        this.setErpTuitionInfoSettings(null);
        this.setExecutionYear(null);
        this.getTuitionProductsSet().clear();
        while (!this.getErpTuitionInfoTypeAcademicEntriesSet().isEmpty()) {
            ((ERPTuitionInfoTypeAcademicEntry)((Object)this.getErpTuitionInfoTypeAcademicEntriesSet().iterator().next())).delete();
        }
        this.deleteDomainObject();
    }

    public static Stream<ERPTuitionInfoType> findAll() {
        return ERPTuitionInfoSettings.getInstance().getErpTuitionInfoTypesSet().stream();
    }

    public static Stream<ERPTuitionInfoType> findActive() {
        return ERPTuitionInfoType.findAll().filter(e -> e.isActive());
    }

    public static Stream<? extends ERPTuitionInfoType> findForExecutionYear(ExecutionYear executionYear) {
        return executionYear.getErpTuitionInfoTypesSet().stream();
    }

    public static Stream<ERPTuitionInfoType> findActiveForExecutionYear(ExecutionYear executionYear) {
        return executionYear.getErpTuitionInfoTypesSet().stream().filter(e -> e.isActive());
    }

    public static Stream<ERPTuitionInfoType> findByCode(String code) {
        return ERPTuitionInfoType.findAll().filter(e -> e.getErpTuitionInfoProduct().getCode().equals(code));
    }

    public static Optional<ERPTuitionInfoType> findUniqueByCode(String code) {
        return ERPTuitionInfoType.findAll().filter(e -> e.getErpTuitionInfoProduct().getCode().equals(code)).findFirst();
    }

    public static ERPTuitionInfoType create(ExecutionYear executionYear, ERPTuitionInfoProduct product, Set<Product> tuitionProducts) {
        return new ERPTuitionInfoType(executionYear, product, tuitionProducts);
    }
}

