/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.event;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.treasury.AcademicTreasuryEventPayment;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEventPayment;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IPaymentReferenceCode;
import org.fenixedu.academic.domain.treasury.ITuitionTreasuryEvent;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent$callable$delete;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent$callable$getTreasuryEventDate;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent_Base;
import org.fenixedu.academictreasury.domain.event.TreasuryEventDefaultMethods;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class AcademicTreasuryEvent
extends AcademicTreasuryEvent_Base
implements IAcademicTreasuryEvent,
ITuitionTreasuryEvent,
IImprovementTreasuryEvent,
IAcademicServiceRequestAndAcademicTaxTreasuryEvent {
    public static final Advice advice$getTreasuryEventDate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public AcademicTreasuryEvent() {
    }

    protected AcademicTreasuryEvent(ITreasuryServiceRequest iTreasuryServiceRequest) {
        this();
        this.init(iTreasuryServiceRequest.getPerson(), iTreasuryServiceRequest, ServiceRequestMapEntry.findProduct(iTreasuryServiceRequest));
    }

    protected AcademicTreasuryEvent(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Product product, Registration registration, ExecutionYear executionYear) {
        this();
        this.init(tuitionPaymentPlanGroup, product, registration, executionYear);
        this.checkRules();
    }

    protected AcademicTreasuryEvent(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        this();
        this.init(academicTax, registration, executionYear);
        this.checkRules();
    }

    protected AcademicTreasuryEvent(Product product, IAcademicTreasuryTarget target) {
        this();
        this.init(product, target);
        this.checkRules();
    }

    protected void init(Product product, LocalizedString name) {
        throw new RuntimeException("wrong call");
    }

    protected void init(Person person, ITreasuryServiceRequest iTreasuryServiceRequest, Product product) {
        super.init(product, this.nameForAcademicServiceRequest(product, iTreasuryServiceRequest));
        this.setPerson(person);
        this.setITreasuryServiceRequest(iTreasuryServiceRequest);
        this.setPropertiesJsonMap(org.fenixedu.treasury.util.Constants.propertiesMapToJson(this.fillPropertiesMap()));
        this.setDescription(this.descriptionForAcademicServiceRequest());
        this.checkRules();
    }

    private LocalizedString nameForAcademicServiceRequest(Product product, ITreasuryServiceRequest iTreasuryServiceRequest) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            if (iTreasuryServiceRequest.getExecutionYear() != null) {
                result = result.with(locale, String.format("%s [%s - %s] (%s)", product.getName().getContent(locale), iTreasuryServiceRequest.getRegistration().getDegree().getPresentationNameI18N().getContent(), iTreasuryServiceRequest.getExecutionYear().getQualifiedName(), iTreasuryServiceRequest.getServiceRequestNumberYear()));
                continue;
            }
            result = result.with(locale, String.format("%s [%s] (%s)", product.getName().getContent(locale), iTreasuryServiceRequest.getRegistration().getDegree().getPresentationNameI18N().getContent(), iTreasuryServiceRequest.getServiceRequestNumberYear()));
        }
        return result;
    }

    protected void init(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Product product, Registration registration, ExecutionYear executionYear) {
        super.init(product, this.nameForTuition(product, registration, executionYear));
        this.setPerson(registration.getPerson());
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup);
        this.setRegistration(registration);
        this.setExecutionYear(executionYear);
        this.setPropertiesJsonMap(org.fenixedu.treasury.util.Constants.propertiesMapToJson(this.fillPropertiesMap()));
        this.checkRules();
    }

    private LocalizedString nameForTuition(Product product, Registration registration, ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            String name = String.format("%s [%s - %s]", product.getName().getContent(), registration.getDegree().getPresentationNameI18N().getContent(), executionYear.getQualifiedName());
            result = result.with(locale, name);
        }
        return result;
    }

    protected void init(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        super.init(academicTax.getProduct(), this.nameForAcademicTax(academicTax, registration, executionYear));
        this.setAcademicTax(academicTax);
        this.setPerson(registration.getPerson());
        this.setRegistration(registration);
        this.setExecutionYear(executionYear);
        this.setPropertiesJsonMap(org.fenixedu.treasury.util.Constants.propertiesMapToJson(this.fillPropertiesMap()));
        this.checkRules();
    }

    private LocalizedString nameForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            String name = null;
            name = academicTax.isAppliedOnRegistration() ? String.format("%s [%s - %s]", academicTax.getProduct().getName().getContent(), registration.getDegree().getPresentationNameI18N().getContent(), executionYear.getQualifiedName()) : String.format("%s [%s]", academicTax.getProduct().getName().getContent(), executionYear.getQualifiedName());
            result = result.with(locale, name);
        }
        return result;
    }

    protected void init(Product product, IAcademicTreasuryTarget target) {
        if (target == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.target.required", new String[0]);
        }
        super.init(product, target.getAcademicTreasuryTargetDescription());
        this.setPerson(target.getAcademicTreasuryTargetPerson());
        this.setTreasuryEventTarget((AbstractDomainObject)target);
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getPerson() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.person.required", new String[0]);
        }
        if (!(this.isForAcademicServiceRequest() || this.isTuitionEvent() || this.isForAcademicTax() || this.isForImprovementTax() || this.isForTreasuryEventTarget())) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.not.for.service.request.nor.tuition.nor.academic.tax", new String[0]);
        }
        if (!(this.isForAcademicServiceRequest() ^ this.isForRegistrationTuition() ^ this.isForStandaloneTuition() ^ this.isForExtracurricularTuition() ^ this.isForImprovementTax() ^ this.isForAcademicTax() ^ this.isForTreasuryEventTarget())) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.for.one.type", new String[0]);
        }
        if ((this.isTuitionEvent() || this.isForImprovementTax()) && this.getRegistration() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.registration.required", new String[0]);
        }
        if ((this.isTuitionEvent() || this.isForImprovementTax()) && this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.executionYear.required", new String[0]);
        }
        if (this.isForAcademicServiceRequest() && AcademicTreasuryEvent.find(this.getITreasuryServiceRequest()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.event.for.academicServiceRequest.duplicate", new String[0]);
        }
        if (this.isForAcademicServiceRequest()) {
            this.getITreasuryServiceRequest();
        }
        if (this.isForRegistrationTuition() && AcademicTreasuryEvent.findForRegistrationTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.registration.tuition.duplicate", new String[0]);
        }
        if (this.isForStandaloneTuition() && AcademicTreasuryEvent.findForStandaloneTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.standalone.tuition.duplicate", new String[0]);
        }
        if (this.isForExtracurricularTuition() && AcademicTreasuryEvent.findForExtracurricularTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.extracurricular.tuition.duplicate", new String[0]);
        }
        if (this.isForImprovementTax() && AcademicTreasuryEvent.findForImprovementTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.improvement.tuition.duplicate", new String[0]);
        }
        if (this.isForAcademicTax() && this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.academic.tax.execution.year.required", new String[0]);
        }
        if (this.isForAcademicTax() && this.getRegistration() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.academic.tax.registration.required", new String[0]);
        }
        if (this.isForAcademicTax() && AcademicTreasuryEvent.findForAcademicTax(this.getRegistration(), this.getExecutionYear(), this.getAcademicTax()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.academic.tax.duplicate", new String[0]);
        }
    }

    public boolean isForTreasuryEventTarget() {
        return this.getTreasuryEventTarget() != null;
    }

    public boolean isForAcademicServiceRequest() {
        return this.getITreasuryServiceRequest() != null;
    }

    public boolean isForRegistrationTuition() {
        return this.getTuitionPaymentPlanGroup() != null && this.getTuitionPaymentPlanGroup().isForRegistration();
    }

    public boolean isForStandaloneTuition() {
        return this.getTuitionPaymentPlanGroup() != null && this.getTuitionPaymentPlanGroup().isForStandalone();
    }

    public boolean isLegacy() {
        return false;
    }

    public boolean isForLegacy() {
        return this.isLegacy();
    }

    public boolean isForExtracurricularTuition() {
        return this.getTuitionPaymentPlanGroup() != null && this.getTuitionPaymentPlanGroup().isForExtracurricular();
    }

    public boolean isForImprovementTax() {
        return this.getAcademicTax() != null && this.getAcademicTax() == AcademicTreasurySettings.getInstance().getImprovementAcademicTax();
    }

    public boolean isForAcademicTax() {
        return this.getAcademicTax() != null && !this.isImprovementTax();
    }

    public int getNumberOfUnits() {
        if (this.isForAcademicServiceRequest()) {
            return Constants.getNumberOfUnits(this.getITreasuryServiceRequest());
        }
        if (this.isForAcademicTax()) {
            return 0;
        }
        if (this.isForImprovementTax()) {
            return 0;
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.numberOfUnits.not.applied", new String[0]);
    }

    public int getNumberOfPages() {
        if (this.isForAcademicServiceRequest()) {
            return this.getITreasuryServiceRequest().hasNumberOfPages() ? this.getITreasuryServiceRequest().getNumberOfPages() : 0;
        }
        if (this.isForAcademicTax()) {
            return 0;
        }
        if (this.isForImprovementTax()) {
            return 0;
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.numberOfPages.not.applied", new String[0]);
    }

    public boolean isUrgentRequest() {
        if (this.isForAcademicServiceRequest()) {
            return this.getITreasuryServiceRequest().isUrgent();
        }
        if (this.isForAcademicTax()) {
            return false;
        }
        if (this.isForImprovementTax()) {
            return false;
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.urgentRequest.not.applied", new String[0]);
    }

    public LocalDate getRequestDate() {
        if (this.isForAcademicServiceRequest()) {
            return this.getITreasuryServiceRequest().getRequestDate().toLocalDate();
        }
        if (this.isForAcademicTax() && !this.isForImprovementTax()) {
            LocalDate requestDate = RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear((Registration)this.getRegistration(), (ExecutionYear)this.getExecutionYear()).getEnrolmentDate();
            return requestDate != null ? requestDate : new LocalDate();
        }
        if (this.isForImprovementTax()) {
            LocalDate requestDate = RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear((Registration)this.getRegistration(), (ExecutionYear)this.getExecutionYear()).getEnrolmentDate();
            return requestDate != null ? requestDate : new LocalDate();
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.requestDate.not.applied", new String[0]);
    }

    public Locale getLanguage() {
        if (this.isForAcademicServiceRequest()) {
            return this.getITreasuryServiceRequest().getLanguage();
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.language.not.applied", new String[0]);
    }

    public boolean isChargedWithDebitEntry(TuitionInstallmentTariff tariff) {
        return DebitEntry.findActive((TreasuryEvent)this).filter(d -> d.getProduct().equals((Object)tariff.getProduct())).count() > 0L;
    }

    public boolean isCharged() {
        return TreasuryEventDefaultMethods.isCharged((TreasuryEvent)this);
    }

    public boolean isChargedWithDebitEntry(Enrolment enrolment) {
        if (!this.isForStandaloneTuition() && !this.isForExtracurricularTuition()) {
            throw new RuntimeException("wrong call");
        }
        return this.findActiveEnrolmentDebitEntry(enrolment).isPresent();
    }

    public boolean isChargedWithDebitEntry(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isForImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        return this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent();
    }

    public LocalDate getTreasuryEventDate() {
        return (LocalDate)advice$getTreasuryEventDate.perform((Callable)new AcademicTreasuryEvent$callable$getTreasuryEventDate(this));
    }

    static /* synthetic */ LocalDate advised$getTreasuryEventDate(AcademicTreasuryEvent this_) {
        if (this_.isForAcademicServiceRequest()) {
            return this_.getITreasuryServiceRequest().getRequestDate().toLocalDate();
        }
        if (this_.isForImprovementTax() || this_.isForAcademicTax() || this_.isForRegistrationTuition() || this_.isForExtracurricularTuition() || this_.isForStandaloneTuition()) {
            RegistrationDataByExecutionYear data = RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear((Registration)this_.getRegistration(), (ExecutionYear)this_.getExecutionYear());
            if (data.getEnrolmentDate() != null) {
                return data.getEnrolmentDate();
            }
            return this_.getExecutionYear().getBeginLocalDate();
        }
        if (this_.isForTreasuryEventTarget()) {
            return ((IAcademicTreasuryTarget)this_.getTreasuryEventTarget()).getAcademicTreasuryTargetEventDate();
        }
        throw new RuntimeException("dont know how to handle this!");
    }

    public Optional<? extends DebitEntry> findActiveAcademicServiceRequestDebitEntry() {
        return DebitEntry.findActive((TreasuryEvent)this).findFirst();
    }

    public Optional<? extends DebitEntry> findActiveEnrolmentDebitEntry(Enrolment enrolment) {
        return DebitEntry.findActive((TreasuryEvent)this).filter(d -> d.getCurricularCourse() == enrolment.getCurricularCourse() && d.getExecutionSemester() == enrolment.getExecutionPeriod()).findFirst();
    }

    public Optional<? extends DebitEntry> findActiveEnrolmentEvaluationDebitEntry(EnrolmentEvaluation enrolmentEvaluation) {
        return DebitEntry.findActive((TreasuryEvent)this).filter(d -> d.getCurricularCourse() == enrolmentEvaluation.getEnrolment().getCurricularCourse() && d.getExecutionSemester() == enrolmentEvaluation.getExecutionPeriod() && d.getEvaluationSeason() == enrolmentEvaluation.getEvaluationSeason()).findFirst();
    }

    public void associateEnrolment(DebitEntry debitEntry, Enrolment enrolment) {
        if (!this.isForStandaloneTuition() && !this.isForExtracurricularTuition()) {
            throw new RuntimeException("wrong call");
        }
        if (enrolment == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.enrolment.cannot.be.null", new String[0]);
        }
        if (enrolment.isOptional()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.optional.enrolments.not.supported", new String[0]);
        }
        debitEntry.setCurricularCourse(enrolment.getCurricularCourse());
        debitEntry.setExecutionSemester(enrolment.getExecutionPeriod());
    }

    public void associateEnrolmentEvaluation(DebitEntry debitEntry, EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isForImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        if (enrolmentEvaluation == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.enrolmentEvaluation.cannot.be.null", new String[0]);
        }
        debitEntry.setCurricularCourse(enrolmentEvaluation.getEnrolment().getCurricularCourse());
        debitEntry.setExecutionSemester(enrolmentEvaluation.getEnrolment().getExecutionPeriod());
        if (enrolmentEvaluation.getExecutionPeriod() != null) {
            debitEntry.setExecutionSemester(enrolmentEvaluation.getExecutionPeriod());
        }
        debitEntry.setEvaluationSeason(enrolmentEvaluation.getEvaluationSeason());
    }

    public Set<Product> getPossibleProductsToExempt() {
        if (this.isForRegistrationTuition()) {
            return TuitionPaymentPlan.find(this.getTuitionPaymentPlanGroup(), this.getRegistration().getStudentCurricularPlan(this.getExecutionYear()).getDegreeCurricularPlan(), this.getExecutionYear()).map(t -> t.getTuitionInstallmentTariffsSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream().map(i -> i.getProduct()).collect(Collectors.toSet());
        }
        return Sets.newHashSet((Object[])new Product[]{this.getProduct()});
    }

    private LocalizedString descriptionForAcademicServiceRequest() {
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(this.getITreasuryServiceRequest());
        LocalizedString result = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            String text = this.getProduct().getName().getContent(locale) + ": " + this.getITreasuryServiceRequest().getServiceRequestNumberYear();
            if (!Strings.isNullOrEmpty((String)serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat())) {
                StrSubstitutor str = new StrSubstitutor(this.getITreasuryServiceRequest().getPropertyValuesMap());
                String extString = str.replace(serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat());
                text = text + " " + extString;
            }
            result = result.with(locale, text);
        }
        return result;
    }

    public String getDegreeCode() {
        if (this.degree() == null) {
            return null;
        }
        return this.degree().getCode();
    }

    public String getDegreeName() {
        if (this.degree() == null) {
            return null;
        }
        if (this.getExecutionYear() != null) {
            return this.degree().getPresentationNameI18N(this.getExecutionYear()).getContent();
        }
        return this.degree().getPresentationNameI18N().getContent();
    }

    public String getExecutionYearName() {
        if (this.getExecutionYear() != null) {
            return this.getExecutionYear().getQualifiedName();
        }
        return null;
    }

    private Degree degree() {
        Degree degree = null;
        if (this.isForRegistrationTuition() && this.getRegistration() != null) {
            degree = this.getRegistration().getDegree();
        } else if (!(this.isForStandaloneTuition() || this.isForExtracurricularTuition() || this.isForImprovementTax())) {
            if (this.isForAcademicTax() && this.getRegistration() != null) {
                degree = this.getRegistration().getDegree();
            } else if (this.isForAcademicServiceRequest() && this.getRegistration() != null) {
                degree = this.getRegistration().getDegree();
            }
        }
        return degree;
    }

    private int treasuryEventTypeCode() {
        if (this.isForAcademicServiceRequest()) {
            return 0;
        }
        if (this.isForAcademicTax()) {
            return 1;
        }
        if (this.isForExtracurricularTuition()) {
            return 2;
        }
        if (this.isForImprovementTax()) {
            return 3;
        }
        if (this.isForRegistrationTuition()) {
            return 4;
        }
        if (this.isForStandaloneTuition()) {
            return 5;
        }
        if (this.isForTreasuryEventTarget()) {
            return 6;
        }
        if (this.isLegacy()) {
            return 7;
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unkwnown.type", new String[0]);
    }

    public void mergeDebitEntriesAndExemptions(AcademicTreasuryEvent event) {
        if (this.treasuryEventTypeCode() != event.treasuryEventTypeCode()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.for.different.types", new String[0]);
        }
        if (this.isForAcademicServiceRequest()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
        }
        if (this.isForAcademicTax()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
            if (this.getAcademicTax() != event.getAcademicTax()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.academic.tax", new String[0]);
            }
        } else if (this.isForExtracurricularTuition()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else if (this.isForImprovementTax()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else if (this.isForRegistrationTuition()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else if (this.isForStandaloneTuition()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else {
            if (this.isForTreasuryEventTarget()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
            }
            if (this.isForLegacy()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
            }
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unkwnown.type", new String[0]);
        }
        for (DebitEntry debitEntry : Sets.newHashSet((Iterable)event.getDebitEntriesSet())) {
            debitEntry.setTreasuryEvent((TreasuryEvent)this);
        }
        for (TreasuryExemption exemption : Sets.newHashSet((Iterable)event.getTreasuryExemptionsSet())) {
            exemption.setTreasuryEvent((TreasuryEvent)this);
        }
    }

    public void copyDebitEntryInformation(DebitEntry sourceDebitEntry, DebitEntry copyDebitEntry) {
        copyDebitEntry.setCurricularCourse(sourceDebitEntry.getCurricularCourse());
        copyDebitEntry.setEvaluationSeason(sourceDebitEntry.getEvaluationSeason());
        copyDebitEntry.setExecutionSemester(sourceDebitEntry.getExecutionSemester());
    }

    public boolean isDeletable() {
        return this.getDebitEntriesSet().isEmpty() && this.getTreasuryExemptionsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicTreasuryEvent$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicTreasuryEvent this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.AcademicTreasuryEvent.cannot.delete", new String[0]);
        }
        this_.setPerson(null);
        this_.setITreasuryServiceRequest(null);
        this_.setTuitionPaymentPlanGroup(null);
        this_.setRegistration(null);
        this_.setAcademicTax(null);
        this_.setRegistration(null);
        this_.setExecutionYear(null);
        this_.setAcademicTax(null);
        this_.setTreasuryEventTarget(null);
        super.delete();
    }

    public static Stream<? extends AcademicTreasuryEvent> findAll() {
        return TreasuryEvent.findAll().filter(e -> e instanceof AcademicTreasuryEvent).map(AcademicTreasuryEvent.class::cast);
    }

    public static Stream<? extends AcademicTreasuryEvent> find(Person person) {
        return person.getAcademicTreasuryEventSet().stream();
    }

    public static Stream<? extends AcademicTreasuryEvent> find(Registration registration, ExecutionYear executionYear) {
        return registration.getAcademicTreasuryEventSet().stream().filter(l -> l.getExecutionYear() == executionYear);
    }

    public static Stream<? extends AcademicTreasuryEvent> find(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (iTreasuryServiceRequest == null) {
            throw new RuntimeException("wrong call");
        }
        return AcademicTreasuryEvent.findAll().filter(e -> e.getITreasuryServiceRequest() != null && e.getITreasuryServiceRequest().getExternalId().equals(iTreasuryServiceRequest.getExternalId()));
    }

    public static Optional<? extends AcademicTreasuryEvent> findUnique(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryEvent.find(iTreasuryServiceRequest).findFirst();
    }

    public static AcademicTreasuryEvent createForAcademicServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return new AcademicTreasuryEvent(iTreasuryServiceRequest);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForRegistrationTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForRegistrationTuition());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForRegistrationTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForRegistrationTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForRegistrationTuition(Product product, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), product, registration, executionYear);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForStandaloneTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForStandaloneTuition());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForStandaloneTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForStandaloneTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForStandaloneTuition(Product product, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get(), product, registration, executionYear);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForExtracurricularTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForExtracurricularTuition());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForExtracurricularTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForExtracurricularTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForExtracurricularTuition(Product product, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), product, registration, executionYear);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForImprovementTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForImprovementTax());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForImprovementTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForImprovementTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForImprovementTuition(Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(AcademicTreasurySettings.getInstance().getImprovementAcademicTax(), registration, executionYear);
    }

    public static Stream<? extends AcademicTreasuryEvent> findAllForAcademicTax(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (AcademicTax academicTax : AcademicTax.findAll().collect(Collectors.toSet())) {
            result.addAll(AcademicTreasuryEvent.findForAcademicTax(registration, executionYear, academicTax).collect(Collectors.toSet()));
        }
        return result.stream();
    }

    public static Stream<? extends AcademicTreasuryEvent> findForAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        return registration.getPerson().getAcademicTreasuryEventSet().stream().filter(e -> e.isForAcademicTax() && e.getAcademicTax() == academicTax && e.getExecutionYear() == executionYear && (!e.getAcademicTax().isAppliedOnRegistration() && e.getPerson() == registration.getPerson() || e.getRegistration() == registration));
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        return AcademicTreasuryEvent.findForAcademicTax(registration, executionYear, academicTax).findFirst();
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForTarget(Person person, IAcademicTreasuryTarget target) {
        return AcademicTreasuryEvent.find(person).filter(a -> a.getTreasuryEventTarget() == target).findFirst();
    }

    public static Stream<? extends AcademicTreasuryEvent> findByDescription(Person person, String description, boolean trimmed) {
        return AcademicTreasuryEvent.find(person).filter(t -> !trimmed && t.getDescription().getContent().equals(description) || trimmed && t.getDescription().getContent().trim().equals(description));
    }

    public static AcademicTreasuryEvent createForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(academicTax, registration, executionYear);
    }

    public static AcademicTreasuryEvent createForAcademicTreasuryEventTarget(Product product, IAcademicTreasuryTarget target) {
        return new AcademicTreasuryEvent(product, target);
    }

    private Map<String, String> fillPropertiesMap() {
        HashMap propertiesMap = Maps.newHashMap();
        if (this.isForAcademicServiceRequest()) {
            propertiesMap.put(AcademicTreasuryEventKeys.ACADEMIC_SERVICE_REQUEST_NAME.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getServiceRequestType().getName().getContent());
            propertiesMap.put(AcademicTreasuryEventKeys.ACADEMIC_SERVICE_REQUEST_NUMBER_YEAR.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getServiceRequestNumberYear());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getRegistration().getDegree().getPresentationNameI18N(this.getITreasuryServiceRequest().getExecutionYear()).getContent());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getRegistration().getDegree().getCode());
            if (this.getITreasuryServiceRequest().hasExecutionYear()) {
                propertiesMap.put(AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getExecutionYear().getQualifiedName());
            }
            propertiesMap.put(AcademicTreasuryEventKeys.DETAILED.getDescriptionI18N().getContent(), this.booleanLabel(this.getITreasuryServiceRequest().isDetailed()).getContent());
            propertiesMap.put(AcademicTreasuryEventKeys.URGENT.getDescriptionI18N().getContent(), this.booleanLabel(this.getITreasuryServiceRequest().isUrgent()).getContent());
            if (this.getITreasuryServiceRequest().hasLanguage()) {
                propertiesMap.put(AcademicTreasuryEventKeys.LANGUAGE.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getLanguage().getLanguage());
            }
        } else if (this.isForRegistrationTuition() || this.isForStandaloneTuition() || this.isForExtracurricularTuition()) {
            propertiesMap.put(AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), this.getExecutionYear().getQualifiedName());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), this.getRegistration().getDegree().getPresentationNameI18N(this.getExecutionYear()).getContent());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), this.getRegistration().getDegreeCurricularPlanName());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), this.getRegistration().getDegree().getCode());
        }
        return propertiesMap;
    }

    private LocalizedString booleanLabel(boolean detailed) {
        return BundleUtil.getLocalizedString((String)"resources.AcademicTreasuryResources", (String)(detailed ? "label.true" : "label.false"), (String[])new String[0]);
    }

    public BigDecimal getEnrolledEctsUnits() {
        if (this.getTuitionPaymentPlanGroup().isForRegistration()) {
            Set<Object> normalEnrolments = Sets.newHashSet((Iterable)this.getRegistration().getStudentCurricularPlan(this.getExecutionYear()).getRoot().getEnrolmentsBy(this.getExecutionYear()));
            normalEnrolments.removeAll(this.getRegistration().getStandaloneCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).collect(Collectors.toSet()));
            normalEnrolments.removeAll(this.getRegistration().getExtraCurricularCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).collect(Collectors.toSet()));
            normalEnrolments = normalEnrolments.stream().filter(e -> !e.isAnnulled()).collect(Collectors.toSet());
            return normalEnrolments.stream().map(e -> new BigDecimal(e.getEctsCredits())).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        }
        if (this.getTuitionPaymentPlanGroup().isForStandalone()) {
            return this.getRegistration().getStandaloneCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).map(Enrolment.class::cast).filter(e -> !e.isAnnulled()).map(e -> new BigDecimal(e.getEctsCredits())).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        }
        if (this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            return this.getRegistration().getExtraCurricularCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).map(Enrolment.class::cast).filter(e -> !e.isAnnulled()).map(e -> new BigDecimal(e.getEctsCredits())).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unknown.tuition.group", new String[0]);
    }

    public BigDecimal getEnrolledCoursesCount() {
        if (this.getTuitionPaymentPlanGroup().isForRegistration()) {
            Set<Object> normalEnrolments = Sets.newHashSet((Iterable)this.getRegistration().getStudentCurricularPlan(this.getExecutionYear()).getRoot().getEnrolmentsBy(this.getExecutionYear()));
            normalEnrolments.removeAll(this.getRegistration().getStandaloneCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).collect(Collectors.toSet()));
            normalEnrolments.removeAll(this.getRegistration().getExtraCurricularCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).collect(Collectors.toSet()));
            normalEnrolments = normalEnrolments.stream().filter(e -> !e.isAnnulled()).collect(Collectors.toSet());
            return new BigDecimal(normalEnrolments.size());
        }
        if (this.getTuitionPaymentPlanGroup().isForStandalone()) {
            return new BigDecimal(this.getRegistration().getStandaloneCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).map(Enrolment.class::cast).filter(e -> !e.isAnnulled()).count());
        }
        if (this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            return new BigDecimal(this.getRegistration().getExtraCurricularCurriculumLines().stream().filter(l -> l.isEnrolment() && l.getExecutionYear() == this.getExecutionYear()).map(Enrolment.class::cast).filter(e -> !e.isAnnulled()).count());
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unknown.tuition.group", new String[0]);
    }

    public void updatePricingFields(BigDecimal baseAmount, BigDecimal amountForAdditionalUnits, BigDecimal amountForPages, BigDecimal maximumAmount, BigDecimal amountForLanguageTranslationRate, BigDecimal amountForUrgencyRate) {
        super.setBaseAmount(baseAmount);
        super.setAmountForAdditionalUnits(amountForAdditionalUnits);
        super.setAmountForPages(amountForPages);
        super.setMaximumAmount(maximumAmount);
        super.setAmountForLanguageTranslationRate(amountForLanguageTranslationRate);
        super.setAmountForUrgencyRate(amountForUrgencyRate);
    }

    public String getDebtAccountURL() {
        return TreasuryEventDefaultMethods.getDebtAccountURL((TreasuryEvent)this);
    }

    public boolean isTuitionEvent() {
        return this.isForRegistrationTuition() || this.isForStandaloneTuition() || this.isForExtracurricularTuition();
    }

    public boolean isAcademicServiceRequestEvent() {
        return this.isForAcademicServiceRequest();
    }

    public boolean isAcademicTax() {
        return this.isForAcademicTax();
    }

    public boolean isImprovementTax() {
        return this.isForImprovementTax();
    }

    public boolean isExempted() {
        return TreasuryEventDefaultMethods.isExempted((TreasuryEvent)this);
    }

    public boolean isDueDateExpired(LocalDate when) {
        return TreasuryEventDefaultMethods.isDueDateExpired((TreasuryEvent)this, when);
    }

    public boolean isBlockingAcademicalActs(LocalDate when) {
        return TreasuryEventDefaultMethods.isBlockingAcademicalActs((TreasuryEvent)this, when);
    }

    public LocalDate getDueDate() {
        return DebitEntry.findActive((TreasuryEvent)this).sorted(DebitEntry.COMPARE_BY_DUE_DATE).map(l -> l.getDueDate()).findFirst().orElse(null);
    }

    public String getExemptionReason() {
        return TreasuryEventDefaultMethods.getExemptionReason((TreasuryEvent)this);
    }

    public String getExemptionTypeName() {
        return TreasuryEventDefaultMethods.getExemptionTypeName((TreasuryEvent)this, Constants.DEFAULT_LANGUAGE);
    }

    public String getExemptionTypeName(Locale locale) {
        return TreasuryEventDefaultMethods.getExemptionTypeName((TreasuryEvent)this, locale);
    }

    public List<IAcademicTreasuryEventPayment> getPaymentsList() {
        return TreasuryEventDefaultMethods.getPaymentsList((TreasuryEvent)this);
    }

    public void invokeSettlementCallbacks() {
        if (this.isForTreasuryEventTarget()) {
            ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).handleSettlement((IAcademicTreasuryEvent)this);
        }
    }

    public BigDecimal getBaseAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.baseAmount.unavailable", new String[0]);
        }
        return super.getBaseAmount();
    }

    public BigDecimal getAdditionalUnitsAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.additionalUnitsAmount.unavailable", new String[0]);
        }
        return super.getAmountForAdditionalUnits();
    }

    public BigDecimal getMaximumAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.maximumAmount.unavailable", new String[0]);
        }
        return super.getMaximumAmount();
    }

    public BigDecimal getPagesAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.pagesAmount.unavailable", new String[0]);
        }
        return super.getAmountForPages();
    }

    public BigDecimal getAmountForLanguageTranslationRate() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.amountForLanguageTranslationRate.unavailable", new String[0]);
        }
        return super.getAmountForLanguageTranslationRate();
    }

    public BigDecimal getAmountForUrgencyRate() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.amountForUrgencyRate.unavailable", new String[0]);
        }
        return super.getAmountForUrgencyRate();
    }

    public int getTuitionInstallmentSize() {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        return this.orderedTuitionDebitEntriesList().size();
    }

    public BigDecimal getTuitionInstallmentAmountToPay(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        return this.orderedTuitionDebitEntriesList().get(installmentOrder).getOpenAmount();
    }

    public BigDecimal getTuitionInstallmentRemainingAmountToPay(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        return this.orderedTuitionDebitEntriesList().get(installmentOrder).getOpenAmount();
    }

    public BigDecimal getTuitionInstallmentExemptedAmount(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        DebitEntry debitEntry = this.orderedTuitionDebitEntriesList().get(installmentOrder);
        BigDecimal result = debitEntry.getExemptedAmount();
        result = result.add(debitEntry.getCreditEntriesSet().stream().filter(l -> l.isFromExemption()).map(l -> l.getAmountWithVat()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
        return result;
    }

    public LocalDate getTuitionInstallmentDueDate(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        DebitEntry debitEntry = this.orderedTuitionDebitEntriesList().get(installmentOrder);
        return debitEntry.getDueDate();
    }

    public String getTuitionInstallmentDescription(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        DebitEntry debitEntry = this.orderedTuitionDebitEntriesList().get(installmentOrder);
        return debitEntry.getDescription();
    }

    public boolean isTuitionInstallmentExempted(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        DebitEntry debitEntry = this.orderedTuitionDebitEntriesList().get(installmentOrder);
        return TreasuryExemption.findUnique((TreasuryEvent)this, (Product)debitEntry.getProduct()).isPresent();
    }

    public String getTuitionInstallmentExemptionReason(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        DebitEntry debitEntry = this.orderedTuitionDebitEntriesList().get(installmentOrder);
        if (!TreasuryExemption.findUnique((TreasuryEvent)this, (Product)debitEntry.getProduct()).isPresent()) {
            return null;
        }
        return ((TreasuryExemption)TreasuryExemption.findUnique((TreasuryEvent)this, (Product)debitEntry.getProduct()).get()).getReason();
    }

    public List<IAcademicTreasuryEventPayment> getTuitionInstallmentPaymentsList(int installmentOrder) {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        DebitEntry debitEntry = this.orderedTuitionDebitEntriesList().get(installmentOrder);
        return debitEntry.getSettlementEntriesSet().stream().map(l -> new AcademicTreasuryEventPayment((SettlementEntry)l)).collect(Collectors.toList());
    }

    public boolean isCharged(EnrolmentEvaluation enrolmentEvaluation) {
        return this.isChargedWithDebitEntry(enrolmentEvaluation);
    }

    public boolean isExempted(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent()) {
            return false;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return TreasuryExemption.findUnique((TreasuryEvent)this, (Product)debitEntry.getProduct()).isPresent();
    }

    public boolean isDueDateExpired(EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        if (!this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent()) {
            return false;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return debitEntry.isDueDateExpired(when);
    }

    public boolean isBlockingAcademicalActs(EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        if (!this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent()) {
            return false;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return debitEntry.isInDebt() && debitEntry.isDueDateExpired(when);
    }

    public BigDecimal getAmountToPay(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent()) {
            return BigDecimal.ZERO;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return debitEntry.getAmount();
    }

    public BigDecimal getRemainingAmountToPay(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent()) {
            return BigDecimal.ZERO;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return debitEntry.getOpenAmount();
    }

    public BigDecimal getExemptedAmount(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isExempted(enrolmentEvaluation)) {
            return BigDecimal.ZERO;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return debitEntry.getOpenAmount();
    }

    public LocalDate getDueDate(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isChargedWithDebitEntry(enrolmentEvaluation)) {
            return null;
        }
        DebitEntry debitEntry = this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get();
        return debitEntry.getDueDate();
    }

    public String getExemptionReason(EnrolmentEvaluation enrolmentEvaluation) {
        return this.getExemptionReason();
    }

    public List<IAcademicTreasuryEventPayment> getPaymentsList(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isChargedWithDebitEntry(enrolmentEvaluation)) {
            return Collections.emptyList();
        }
        return this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).get().getSettlementEntriesSet().stream().filter(l -> l.getFinantialDocument().isClosed()).map(l -> new AcademicTreasuryEventPayment((SettlementEntry)l)).collect(Collectors.toList());
    }

    public String formatMoney(BigDecimal moneyValue) {
        return TreasuryEventDefaultMethods.formatMoney((TreasuryEvent)this, moneyValue);
    }

    public boolean isOnlinePaymentsActive() {
        return TreasuryEventDefaultMethods.isOnlinePaymentsActive((TreasuryEvent)this);
    }

    public void annulDebts(String reason) {
        TreasuryEventDefaultMethods.annulDebts((TreasuryEvent)this, reason);
    }

    public List<IPaymentReferenceCode> getPaymentReferenceCodesList() {
        return TreasuryEventDefaultMethods.getPaymentReferenceCodesList((TreasuryEvent)this);
    }

    protected List<DebitEntry> orderedTuitionDebitEntriesList() {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        return DebitEntry.findActive((TreasuryEvent)this).sorted((a, b) -> a.getExternalId().compareTo(b.getExternalId())).collect(Collectors.toList());
    }

    public String getERPIntegrationMetadata() {
        String degreeCode = "";
        String executionYear = "";
        if (this.getDegree() != null) {
            degreeCode = this.getDegree().getCode();
        } else if (this.getPropertiesMap().containsKey((Object)AcademicTreasuryEventKeys.DEGREE_CODE)) {
            degreeCode = (String)this.getPropertiesMap().get((Object)AcademicTreasuryEventKeys.DEGREE_CODE);
        }
        if (this.getExecutionYear() != null) {
            executionYear = this.getExecutionYear().getQualifiedName();
        } else if (this.getPropertiesMap().containsKey((Object)AcademicTreasuryEventKeys.EXECUTION_YEAR)) {
            executionYear = (String)this.getPropertiesMap().get((Object)AcademicTreasuryEventKeys.EXECUTION_YEAR);
        }
        return "{\"" + (Object)((Object)AcademicTreasuryEventKeys.DEGREE_CODE) + "\":\"" + degreeCode + "\",\"" + (Object)((Object)AcademicTreasuryEventKeys.EXECUTION_YEAR) + "\":\"" + executionYear + "\"}";
    }

    @Deprecated
    public void setAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        super.setAcademicServiceRequest(academicServiceRequest);
    }

    public void setITreasuryServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest) {
        super.setAcademicServiceRequest((AcademicServiceRequest)iTreasuryServiceRequest);
    }

    @Deprecated
    public AcademicServiceRequest getAcademicServiceRequest() {
        return super.getAcademicServiceRequest();
    }

    public ITreasuryServiceRequest getITreasuryServiceRequest() {
        return (ITreasuryServiceRequest)super.getAcademicServiceRequest();
    }

    public static enum AcademicTreasuryEventKeys {
        ACADEMIC_SERVICE_REQUEST_NAME("1"),
        ACADEMIC_SERVICE_REQUEST_NUMBER_YEAR("2"),
        EXECUTION_YEAR("3"),
        EXECUTION_SEMESTER("4"),
        EVALUATION_SEASON("5"),
        DETAILED("6"),
        URGENT("7"),
        LANGUAGE("8"),
        BASE_AMOUNT("9"),
        UNITS_FOR_BASE("10"),
        UNIT_AMOUNT("11"),
        ADDITIONAL_UNITS("12"),
        CALCULATED_UNITS_AMOUNT("13"),
        PAGE_AMOUNT("14"),
        NUMBER_OF_PAGES("15"),
        CALCULATED_PAGES_AMOUNT("16"),
        MAXIMUM_AMOUNT("17"),
        AMOUNT_WITHOUT_RATES("18"),
        FOREIGN_LANGUAGE_RATE("19"),
        CALCULATED_FOREIGN_LANGUAGE_RATE("20"),
        URGENT_PERCENTAGE("21"),
        CALCULATED_URGENT_AMOUNT("22"),
        FINAL_AMOUNT("23"),
        TUITION_PAYMENT_PLAN("24"),
        TUITION_PAYMENT_PLAN_CONDITIONS("25"),
        TUITION_CALCULATION_TYPE("26"),
        FIXED_AMOUNT("27"),
        ECTS_CREDITS("28"),
        AMOUNT_PER_ECTS("29"),
        ENROLLED_COURSES("30"),
        AMOUNT_PER_COURSE("31"),
        DUE_DATE("32"),
        DEGREE("33"),
        DEGREE_CODE("34"),
        DEGREE_CURRICULAR_PLAN("35"),
        ENROLMENT("36"),
        FACTOR("37"),
        TOTAL_ECTS_OR_UNITS("38"),
        COURSE_FUNCTION_COST("39"),
        DEFAULT_TUITION_TOTAL_AMOUNT("40"),
        USED_DATE("41"),
        TUITION_PAYOR_DEBT_ACCOUNT("42");

        private String code;

        private AcademicTreasuryEventKeys(String code) {
            this.code = code;
        }

        public LocalizedString getDescriptionI18N() {
            return BundleUtil.getLocalizedString((String)"resources.AcademicTreasuryResources", (String)("label." + AcademicTreasuryEventKeys.class.getSimpleName() + "." + this.name()), (String[])new String[0]);
        }

        public static String valueFor(DebitEntry debitEntry, AcademicTreasuryEventKeys key) {
            if (debitEntry.getPropertiesMap() == null) {
                return null;
            }
            LocalizedString descriptionI18N = key.getDescriptionI18N();
            if (debitEntry.getPropertiesMap().containsKey(descriptionI18N.getContent(Constants.DEFAULT_LANGUAGE))) {
                return (String)debitEntry.getPropertiesMap().get(descriptionI18N.getContent(Constants.DEFAULT_LANGUAGE));
            }
            return null;
        }
    }
}

