/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.emoluments;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax$callable$create;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax$callable$delete;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax$callable$edit;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.Constants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicTax
extends AcademicTax_Base {
    public static final Comparator<AcademicTax> COMPARE_BY_PRODUCT_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected AcademicTax() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AcademicTax(Product product, boolean appliedOnRegistration, boolean appliedOnRegistrationFirstYear, boolean appliedOnRegistrationSubsequentYears, boolean appliedAutomatically) {
        this();
        this.setProduct(product);
        this.setAppliedOnRegistration(appliedOnRegistration);
        this.setAppliedOnRegistrationFirstYear(appliedOnRegistrationFirstYear);
        this.setAppliedOnRegistrationSubsequentYears(appliedOnRegistrationSubsequentYears);
        this.setAppliedAutomatically(appliedAutomatically);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTax.bennu.required", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTax.product.required", new String[0]);
        }
        if (!this.isAppliedOnRegistrationFirstYear() && !this.isAppliedOnRegistrationSubsequentYears()) {
            throw new AcademicTreasuryDomainException("error.AcademicTax.must.be.applied.on.some.registration.enrolment.year", new String[0]);
        }
    }

    public boolean isAppliedOnRegistration() {
        return super.getAppliedOnRegistration();
    }

    public boolean isAppliedOnRegistrationFirstYear() {
        return super.getAppliedOnRegistrationFirstYear();
    }

    public boolean isAppliedOnRegistrationSubsequentYears() {
        return super.getAppliedOnRegistrationSubsequentYears();
    }

    public boolean isAppliedAutomatically() {
        return super.getAppliedAutomatically();
    }

    public boolean isImprovementTax() {
        return this == AcademicTreasurySettings.getInstance().getImprovementAcademicTax();
    }

    public void edit(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object = advice$edit.perform((Callable)new AcademicTax$callable$edit(this, bl, bl2, bl3, bl4));
    }

    static /* synthetic */ void advised$edit(AcademicTax this_, boolean appliedOnRegistration, boolean appliedOnRegistrationFirstYear, boolean appliedOnRegistrationSubsequentYears, boolean appliedAutomatically) {
        this_.setAppliedOnRegistration(appliedOnRegistration);
        this_.setAppliedOnRegistrationFirstYear(appliedOnRegistrationFirstYear);
        this_.setAppliedOnRegistrationSubsequentYears(appliedOnRegistrationSubsequentYears);
        this_.setAppliedAutomatically(appliedAutomatically);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        if (!this.getAcademicTreasuryEventSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.AcademicTax.delete.has.treasury.events", (String[])new String[0]));
        }
        super.checkForDeletionBlockers(blockers);
    }

    private boolean isDeletable() {
        return this.getAcademicTreasuryEventSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicTax$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicTax this_) {
        TreasuryDomainException.throwWhenDeleteBlocked((Collection)this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.AcademicTax.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setProduct(null);
        super.deleteDomainObject();
    }

    public static Stream<AcademicTax> findAll() {
        return FenixFramework.getDomainRoot().getAcademicTaxesSet().stream();
    }

    public static Optional<AcademicTax> findUnique(Product product) {
        return Optional.ofNullable(product.getAcademicTax());
    }

    public static AcademicTax create(Product product, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return (AcademicTax)((Object)advice$create.perform((Callable)new AcademicTax$callable$create(product, bl, bl2, bl3, bl4)));
    }

    static /* synthetic */ AcademicTax advised$create(Product product, boolean appliedOnRegistration, boolean appliedOnRegistrationFirstYear, boolean appliedOnRegistrationSubsequentYears, boolean appliedAutomatically) {
        if (product.getAcademicTax() != null) {
            throw new AcademicTreasuryDomainException("error.AcademicTax.create.academicTax.already.defined.for.product", new String[0]);
        }
        return new AcademicTax(product, appliedOnRegistration, appliedOnRegistrationFirstYear, appliedOnRegistrationSubsequentYears, appliedAutomatically);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_PRODUCT_NAME = new Comparator<AcademicTax>(){

            @Override
            public int compare(AcademicTax o1, AcademicTax o2) {
                int c = o1.getProduct().getName().getContent().compareTo(o2.getProduct().getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

