/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.requests;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile$callable$create;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFileBean;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationType;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MassiveDebtGenerationRequestFile
extends MassiveDebtGenerationRequestFile_Base {
    public static final Comparator<MassiveDebtGenerationRequestFile> COMPARE_BY_CREATION_DATE;
    public static final Advice advice$process;
    public static final Advice advice$create;

    protected MassiveDebtGenerationRequestFile() {
        this.setBennu(Bennu.getInstance());
    }

    protected MassiveDebtGenerationRequestFile(MassiveDebtGenerationRequestFileBean bean, String filename, byte[] content) {
        this();
        MassiveDebtGenerationType type = bean.getMassiveDebtGenerationType();
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = bean.getTuitionPaymentPlanGroup();
        AcademicTax academicTax = bean.getAcademicTax();
        ExecutionYear executionYear = bean.getExecutionYear();
        LocalDate debtDate = bean.getDebtDate();
        String reason = bean.getReason();
        this.init(filename, filename, content);
        this.setMassiveDebtGenerationType(type);
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup);
        this.setAcademicTax(academicTax);
        this.setExecutionYear(executionYear);
        this.setDebtDate(debtDate);
        this.setReason(reason);
        this.setFinantialInstitution(bean.getFinantialInstitution());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getBennu() == null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.bennu.required", new String[0]);
        }
        if (this.getMassiveDebtGenerationType() == null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.massiveDebtGenerationType.required", new String[0]);
        }
        this.getMassiveDebtGenerationType().implementation().checkRules(this);
    }

    public String getDataDescription() {
        return this.getMassiveDebtGenerationType().implementation().dataDescription(this);
    }

    public void process() {
        Object object = advice$process.perform((Callable)new MassiveDebtGenerationRequestFile$callable$process(this));
    }

    static /* synthetic */ void advised$process(MassiveDebtGenerationRequestFile this_) {
        this_.getMassiveDebtGenerationType().implementation().process(this_);
    }

    public boolean isAccessible(User user) {
        return TreasuryAccessControlAPI.isBackOfficeMember((User)user);
    }

    public static Stream<MassiveDebtGenerationRequestFile> findAll() {
        return Bennu.getInstance().getMassiveDebtGenerationRequestFilesSet().stream();
    }

    public static Stream<MassiveDebtGenerationRequestFile> findAllActive() {
        return MassiveDebtGenerationRequestFile.findAll().filter(m -> m.getMassiveDebtGenerationType().isActive());
    }

    public static MassiveDebtGenerationRequestFile create(MassiveDebtGenerationRequestFileBean massiveDebtGenerationRequestFileBean, String string, byte[] byArray) {
        return (MassiveDebtGenerationRequestFile)((Object)advice$create.perform((Callable)new MassiveDebtGenerationRequestFile$callable$create(massiveDebtGenerationRequestFileBean, string, byArray)));
    }

    static /* synthetic */ MassiveDebtGenerationRequestFile advised$create(MassiveDebtGenerationRequestFileBean bean, String filename, byte[] content) {
        return new MassiveDebtGenerationRequestFile(bean, filename, content);
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_CREATION_DATE = new Comparator<MassiveDebtGenerationRequestFile>(){

            @Override
            public int compare(MassiveDebtGenerationRequestFile o1, MassiveDebtGenerationRequestFile o2) {
                int c = o1.getVersioningCreationDate().compareTo((ReadableInstant)o2.getVersioningCreationDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

