/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.academicalAct;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension$callable$create;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension$callable$delete;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension$callable$edit;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicActBlockingSuspension
extends AcademicActBlockingSuspension_Base {
    public static Comparator<AcademicActBlockingSuspension> COMPARE_BY_BEGIN_DATE;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected AcademicActBlockingSuspension() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AcademicActBlockingSuspension(Person person, LocalDate beginDate, LocalDate endDate, String reason) {
        this();
        this.setPerson(person);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setReason(reason);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.bennu.required", new String[0]);
        }
        if (this.getPerson() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.person.required", new String[0]);
        }
        if (this.getBeginDate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.beginDate.required", new String[0]);
        }
        if (this.getEndDate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.endDate.required", new String[0]);
        }
        if (this.getEndDate().isBefore((ReadablePartial)this.getBeginDate())) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.endDate.must.be.after.or.equal.beginDate", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getReason())) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.reason.required", new String[0]);
        }
    }

    public Interval getDateInterval() {
        return new Interval((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay(), (ReadableInstant)this.getEndDate().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1));
    }

    public boolean isBlockingSuspended(LocalDate when) {
        return this.getDateInterval().contains((ReadableInstant)when.toDateTimeAtStartOfDay());
    }

    public void edit(LocalDate localDate, LocalDate localDate2, String string) {
        Object object = advice$edit.perform((Callable)new AcademicActBlockingSuspension$callable$edit(this, localDate, localDate2, string));
    }

    static /* synthetic */ void advised$edit(AcademicActBlockingSuspension this_, LocalDate beginDate, LocalDate endDate, String reason) {
        this_.setBeginDate(beginDate);
        this_.setEndDate(endDate);
        this_.setReason(reason);
        this_.checkRules();
    }

    private boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicActBlockingSuspension$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicActBlockingSuspension this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.AcademicActBlockingSuspension.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setPerson(null);
        super.deleteDomainObject();
    }

    public static Stream<AcademicActBlockingSuspension> findAll() {
        return FenixFramework.getDomainRoot().getAcademicActBlockingSuspensionsSet().stream();
    }

    public static Stream<AcademicActBlockingSuspension> find(Person person) {
        return person.getAcademicActBlockingSuspensionsSet().stream();
    }

    public static Stream<AcademicActBlockingSuspension> find(Person person, LocalDate when) {
        return AcademicActBlockingSuspension.find(person).filter(l -> l.isBlockingSuspended(when));
    }

    public static boolean isBlockingSuspended(Person person, LocalDate when) {
        return AcademicActBlockingSuspension.find(person, when).count() > 0L;
    }

    public static AcademicActBlockingSuspension create(Person person, LocalDate localDate, LocalDate localDate2, String string) {
        return (AcademicActBlockingSuspension)((Object)advice$create.perform((Callable)new AcademicActBlockingSuspension$callable$create(person, localDate, localDate2, string)));
    }

    static /* synthetic */ AcademicActBlockingSuspension advised$create(Person person, LocalDate beginDate, LocalDate endDate, String reason) {
        return new AcademicActBlockingSuspension(person, beginDate, endDate, reason);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_BEGIN_DATE = new Comparator<AcademicActBlockingSuspension>(){

            @Override
            public int compare(AcademicActBlockingSuspension o1, AcademicActBlockingSuspension o2) {
                return o1.getBeginDate().compareTo((ReadablePartial)o2.getBeginDate());
            }
        };
    }
}

