/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageacademicactblockingsuspension;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension"})
public class AcademicActBlockingSuspensionController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension";
    private static final String JSP_PATH = "academicTreasury/manageacademicactblockingsuspension/academicactblockingsuspension";
    private static final String _SEARCH_URI = "/search/";
    public static final String SEARCH_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/search/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/search/view/";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete/";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/search/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/create";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/update/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/";
    }

    private void setAcademicActBlockingSuspension(AcademicActBlockingSuspension academicActBlockingSuspension, Model model) {
        model.addAttribute("academicActBlockingSuspension", (Object)academicActBlockingSuspension);
    }

    @RequestMapping(value={"/search/{debtAccountId}"})
    public String search(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        PersonCustomer customer = (PersonCustomer)debtAccount.getCustomer();
        Person person = customer.isActive() ? customer.getPerson() : customer.getPersonForInactivePersonCustomer();
        model.addAttribute("searchacademicactblockingsuspensionResultsDataSet", AcademicActBlockingSuspension.find((Person)person).sorted(AcademicActBlockingSuspension.COMPARE_BY_BEGIN_DATE).collect(Collectors.toList()));
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/view/{debtAccountId}/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") AcademicActBlockingSuspension academicActBlockingSuspension, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + debtAccount.getExternalId() + "/" + academicActBlockingSuspension.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/delete/{debtAccountId}/{oid}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") AcademicActBlockingSuspension academicActBlockingSuspension, Model model, RedirectAttributes redirectAttributes) {
        try {
            academicActBlockingSuspension.delete();
            return this.redirect(SEARCH_URL + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.search(debtAccount, model);
        }
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate endDate, @RequestParam(value="reason", required=false) String reason, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicActBlockingSuspension.create((Person)((PersonCustomer)debtAccount.getCustomer()).getPerson(), (LocalDate)beginDate, (LocalDate)endDate, (String)reason);
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.AcademicActBlockingSuspension.created.success", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(debtAccount, model);
        }
    }

    @RequestMapping(value={"/read/{debtAccountId}/{oid}"})
    public String read(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") AcademicActBlockingSuspension academicActBlockingSuspension, Model model) {
        this.setAcademicActBlockingSuspension(academicActBlockingSuspension, model);
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("read");
    }

    @RequestMapping(value={"/update/{debtAccountId}/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") AcademicActBlockingSuspension academicActBlockingSuspension, Model model) {
        this.setAcademicActBlockingSuspension(academicActBlockingSuspension, model);
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("update");
    }

    @RequestMapping(value={"/update/{debtAccountId}/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") AcademicActBlockingSuspension academicActBlockingSuspension, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate endDate, @RequestParam(value="reason", required=false) String reason, Model model, RedirectAttributes redirectAttributes) {
        this.setAcademicActBlockingSuspension(academicActBlockingSuspension, model);
        try {
            academicActBlockingSuspension.edit(beginDate, endDate, reason);
            return this.redirect(String.format("/academictreasury/manageacademicactblockingsuspension/academicactblockingsuspension/read/%s/%s", debtAccount.getExternalId(), academicActBlockingSuspension.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.update(debtAccount, academicActBlockingSuspension, model);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/manageacademicactblockingsuspension/academicactblockingsuspension/" + page;
    }
}

