/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.integration.tuitioninfo;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoCreationReportFile;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.exceptions.ERPTuitionInfoPendingException;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.ui.integration.tuitioninfo.ERPTuitionInfoBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@RequestMapping(value={"/academictreasury/erptuitioninfo"})
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.ERPTuitionInfo.title", accessGroup="#managers")
public class ERPTuitionInfoController
extends AcademicTreasuryBaseController {
    private static final int MAX_SEARCH_RESULT_SIZE = 500;
    public static final String CONTROLLER_URL = "/academictreasury/erptuitioninfo";
    private static final String JSP_PATH = "academicTreasury/erptuitioninfo";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/erptuitioninfo/search";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/erptuitioninfo/create";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/erptuitioninfo/createpostback";
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/academictreasury/erptuitioninfo/read";
    private static final String _EXPORT_URI = "/export";
    public static final String EXPORT_URL = "/academictreasury/erptuitioninfo/export";
    private static final String _SEARCH_ERP_TUITION_INFO_CREATION_REPORT_FILE_URI = "/searcherptuitioninfocreationreportfile";
    public static final String SEARCH_ERP_TUITION_INFO_CREATION_REPORT_FILE_URL = "/academictreasury/erptuitioninfo/searcherptuitioninfocreationreportfile";
    private static final String _DOWNLOAD_ERP_TUITION_INFO_CREATION_REPORT_FILE_URI = "/downloaderptuitioninfocreationreportfile";
    public static final String DOWNLOAD_ERP_TUITION_INFO_CREATION_REPORT_FILE_URL = "/academictreasury/erptuitioninfo/downloaderptuitioninfocreationreportfile";

    @RequestMapping
    public String home(Model model) {
        return "redirect:/academictreasury/erptuitioninfo/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@RequestParam(value="fromDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate fromDate, @RequestParam(value="toDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate toDate, @RequestParam(value="executionYearId", required=false) ExecutionYear executionYear, @RequestParam(value="erpTuitionInfoTypeId", required=false) ERPTuitionInfoType erpTuitionInfoType, @RequestParam(value="studentNumber", required=false) String studentNumber, @RequestParam(value="customerName", required=false) String customerName, @RequestParam(value="uiFiscalNumber", required=false) String uiFiscalNumber, @RequestParam(value="erpTuitionDocumentNumber", required=false) String erpTuitionDocumentNumber, @RequestParam(value="pendingToExport", required=false) Boolean pendingToExport, @RequestParam(value="exportationSuccess", required=false) Boolean exportationSuccess, Model model) {
        List<ERPTuitionInfo> result = this.filter(fromDate, toDate, executionYear, erpTuitionInfoType, studentNumber, customerName, uiFiscalNumber, erpTuitionDocumentNumber, pendingToExport, exportationSuccess);
        if (result.size() > 500) {
            model.addAttribute("result_totalCount", (Object)result.size());
            result = result.subList(0, 500);
            model.addAttribute("limit_exceeded", (Object)true);
        }
        List executionYearsList = ExecutionYear.readNotClosedExecutionYears();
        Collections.sort(executionYearsList, ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        model.addAttribute("executionYearsList", (Object)executionYearsList);
        List<Object> erpTuitionInfoTypesList = Lists.newArrayList();
        if (executionYear != null) {
            erpTuitionInfoTypesList = ERPTuitionInfoType.findForExecutionYear((ExecutionYear)executionYear).collect(Collectors.toList());
            Collections.sort(erpTuitionInfoTypesList, ERPTuitionInfoType.COMPARE_BY_NAME);
        }
        model.addAttribute("erpTuitionInfoTypesList", (Object)erpTuitionInfoTypesList);
        model.addAttribute("customersList", PersonCustomer.findAll().sorted(PersonCustomer.COMPARE_BY_NAME_IGNORE_CASE));
        model.addAttribute("result", result);
        model.addAttribute("customerName", (Object)customerName);
        model.addAttribute("studentNumber", (Object)studentNumber);
        model.addAttribute("uiFiscalNumber", (Object)uiFiscalNumber);
        return this.jspPage(_SEARCH_URI);
    }

    private List<ERPTuitionInfo> filter(LocalDate fromDate, LocalDate toDate, ExecutionYear executionYear, ERPTuitionInfoType erpTuitionInfoType, String studentNumber, String customerName, String uiFiscalNumber, String erpTuitionDocumentNumber, Boolean pendingToExport, Boolean exportationSuccess) {
        Stream<ERPTuitionInfo> stream = null;
        if (erpTuitionInfoType != null) {
            stream = erpTuitionInfoType.getErpTuitionInfosSet().stream();
        }
        if (stream == null) {
            stream = ERPTuitionInfo.findAll();
        }
        if (!Strings.isNullOrEmpty((String)erpTuitionDocumentNumber)) {
            return stream.filter(e -> erpTuitionDocumentNumber.equals(e.getUiDocumentNumber())).sorted(ERPTuitionInfo.COMPARE_BY_CREATION_DATE.reversed()).collect(Collectors.toList());
        }
        if (executionYear != null) {
            stream = stream.filter(e -> e.getErpTuitionInfoType().getExecutionYear() == executionYear);
        }
        if (fromDate != null) {
            stream = stream.filter(e -> !e.getCreationDate().isBefore((ReadableInstant)fromDate.toDateTimeAtStartOfDay()));
        }
        if (toDate != null) {
            stream = stream.filter(e -> !e.getCreationDate().isAfter((ReadableInstant)toDate.plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1)));
        }
        if (!Strings.isNullOrEmpty((String)studentNumber)) {
            stream = stream.filter(e -> e.getCustomer().getBusinessIdentification().equals(studentNumber));
        }
        if (!Strings.isNullOrEmpty((String)customerName)) {
            stream = stream.filter(e -> e.getCustomer().matchesMultiFilter(customerName));
        }
        if (!Strings.isNullOrEmpty((String)uiFiscalNumber)) {
            stream = stream.filter(e -> uiFiscalNumber.equals(e.getCustomer().getUiFiscalNumber()));
        }
        if (pendingToExport != null) {
            stream = stream.filter(e -> e.isPendingToExport() == pendingToExport.booleanValue());
        }
        if (exportationSuccess != null) {
            stream = stream.filter(e -> e.isExportationSuccess() == exportationSuccess.booleanValue());
        }
        return stream.sorted(ERPTuitionInfo.COMPARE_BY_CREATION_DATE.reversed()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        return this._create(debtAccount, model, redirectAttributes, new ERPTuitionInfoBean(debtAccount));
    }

    private String _create(DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes, ERPTuitionInfoBean bean) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("customer", (Object)debtAccount.getCustomer());
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        if (((PersonCustomer)debtAccount.getCustomer()).getAssociatedPerson().getStudent() == null) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.ERPTuitionInfo.customer.not.student", (String[])new String[0]), model);
            return this.redirect(String.format("%s/%s", "/treasury/accounting/managecustomer/debtaccount/read/", debtAccount.getExternalId()), model, redirectAttributes);
        }
        return this.jspPage(_CREATE_URI);
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") ERPTuitionInfoBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String createpost(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") ERPTuitionInfoBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (bean.getExecutionYear() == null) {
                throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.executionYear.required", new String[0]);
            }
            PersonCustomer customer = (PersonCustomer)bean.getDebtAccount().getCustomer();
            ERPTuitionInfoType erpTuitionInfoType = bean.getErpTuitionInfoType();
            if (erpTuitionInfoType == null) {
                throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.erpTuitionInfoType.required", new String[0]);
            }
            try {
                ERPTuitionInfo erpTuitionInfo = ERPTuitionInfo.exportTuitionInformation((PersonCustomer)customer, (ERPTuitionInfoType)erpTuitionInfoType);
                if (erpTuitionInfo.isPendingToExport()) {
                    erpTuitionInfo.export();
                }
                return this.redirect("/academictreasury/erptuitioninfo/read/" + erpTuitionInfo.getExternalId(), model, redirectAttributes);
            }
            catch (ERPTuitionInfoPendingException e) {
                ERPTuitionInfo erpTuitionInfo = (ERPTuitionInfo)ERPTuitionInfo.findUniquePendingToExport((Customer)customer, (ERPTuitionInfoType)erpTuitionInfoType).get();
                erpTuitionInfo.export();
                return this.redirect("/academictreasury/erptuitioninfo/read/" + erpTuitionInfo.getExternalId(), model, redirectAttributes);
            }
        }
        catch (AcademicTreasuryDomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._create(debtAccount, model, redirectAttributes, bean);
        }
    }

    @RequestMapping(value={"/read/{erpTuitionInfoId}"}, method={RequestMethod.GET})
    public String read(@PathVariable(value="erpTuitionInfoId") ERPTuitionInfo erpTuitionInfo, Model model) {
        if (erpTuitionInfo.isPendingToExport()) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.ERPTuitionInfo.pending.to.export", (String[])new String[]{erpTuitionInfo.getUiDocumentNumber()}), model);
        }
        model.addAttribute("erpTuitionInfo", (Object)erpTuitionInfo);
        return this.jspPage(_READ_URI);
    }

    @RequestMapping(value={"/export/{erpTuitionInfoId}"}, method={RequestMethod.POST})
    public String export(@PathVariable(value="erpTuitionInfoId") ERPTuitionInfo erpTuitionInfo, Model model, RedirectAttributes redirectAttributes) {
        try {
            erpTuitionInfo.export();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.ERPTuitionInfo.export.success", (String[])new String[0]), model);
        }
        catch (AcademicTreasuryDomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.redirect("/academictreasury/erptuitioninfo/read/" + erpTuitionInfo.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/searcherptuitioninfocreationreportfile"}, method={RequestMethod.GET})
    public String searcherptuitioninfocreationreportfile(Model model) {
        model.addAttribute("result", ERPTuitionInfoCreationReportFile.findAll().collect(Collectors.toSet()));
        return this.jspPage(_SEARCH_ERP_TUITION_INFO_CREATION_REPORT_FILE_URI);
    }

    @RequestMapping(value={"/downloaderptuitioninfocreationreportfile/{fileId}"}, method={RequestMethod.GET})
    public String searcherptuitioninfocreationreportfile(@PathVariable(value="fileId") ERPTuitionInfoCreationReportFile file, Model model, HttpServletResponse response) {
        model.addAttribute("result", ERPTuitionInfoCreationReportFile.findAll().collect(Collectors.toSet()));
        response.setContentLength(file.getContent().length);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-disposition", "attachment; filename=" + file.getFilename());
        try {
            response.getOutputStream().write(file.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private String jspPage(String page) {
        return "academicTreasury/erptuitioninfo/" + page;
    }
}

