/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.customer.forwardpayments;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.ui.customer.CustomerAccountingController;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.ui.document.forwardpayments.ForwardPaymentController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerAccountingController.class)
@RequestMapping(value={"/academictreasury/customer/forwardpayments/forwardpayment"})
public class CustomerAccountingForwardPaymentController
extends ForwardPaymentController {
    public static final String CONTROLLER_URL = "/academictreasury/customer/forwardpayments/forwardpayment";
    private static final String CHOOSE_INVOICE_ENTRIES_URI = "/chooseInvoiceEntries/";
    public static final String CHOOSE_INVOICE_ENTRIES_URL = "/academictreasury/customer/forwardpayments/forwardpayment/chooseInvoiceEntries/";
    private static final String SUMMARY_URI = "/summary/";
    public static final String SUMMARY_URL = "/academictreasury/customer/forwardpayments/forwardpayment/summary/";
    private static final String PROCESS_FORWARD_PAYMENT_URI = "/processforwardpayment";
    public static final String PROCESS_FORWARD_PAYMENT_URL = "/academictreasury/customer/forwardpayments/forwardpayment/processforwardpayment";
    private static final String FORWARD_PAYMENT_SUCCESS_URI = "/forwardpaymentsuccess";
    public static final String FORWARD_PAYMENT_SUCCESS_URL = "/academictreasury/customer/forwardpayments/forwardpayment/forwardpaymentsuccess";
    private static final String FORWARD_PAYMENT_INSUCCESS_URI = "/forwardpaymentinsuccess";
    public static final String FORWARD_PAYMENT_INSUCCESS_URL = "/academictreasury/customer/forwardpayments/forwardpayment/forwardpaymentinsuccess";
    private static final String PRINT_SETTLEMENT_NOTE_URI = "/printsettlementnote";
    public static final String PRINT_SETTLEMENT_NOTE_URL = "/academictreasury/customer/forwardpayments/forwardpayment/printsettlementnote";

    protected String readChooseInvoiceEntriesUrl() {
        return CHOOSE_INVOICE_ENTRIES_URL;
    }

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        Person person = User.findByUsername((String)loggedUsername).getPerson();
        String fiscalCountryCode = PersonCustomer.addressCountryCode((Person)person);
        String fiscalNumber = PersonCustomer.fiscalNumber((Person)person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (PersonCustomer.findUnique((Person)person, (String)fiscalCountryCode, (String)fiscalNumber).get() != debtAccount.getCustomer()) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]), model);
            throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]));
        }
    }

    protected String redirectToDebtAccountUrl(DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(this.readDebtAccountUrl() + this.activeDebtAccount(debtAccount).getExternalId(), model, redirectAttributes);
    }

    private DebtAccount activeDebtAccount(DebtAccount debtAccount) {
        return (DebtAccount)DebtAccount.findUnique((FinantialInstitution)debtAccount.getFinantialInstitution(), (Customer)((PersonCustomer)debtAccount.getCustomer()).getActiveCustomer()).get();
    }

    @RequestMapping(value={"/chooseInvoiceEntries/{debtAccountId}/{digitalPaymentPlatformId}"})
    public String chooseInvoiceEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="digitalPaymentPlatformId") DigitalPaymentPlatform digitalPaymentPlatform, @RequestParam(value="bean", required=false) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        return super.chooseInvoiceEntries(debtAccount, digitalPaymentPlatform, bean, model, redirectAttributes);
    }

    @RequestMapping(value={"/chooseInvoiceEntries/"}, method={RequestMethod.POST})
    public String chooseInvoiceEntries(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        return super.chooseInvoiceEntries(bean, model, redirectAttributes);
    }

    protected String readSummaryUrl() {
        return SUMMARY_URL;
    }

    @RequestMapping(value={"/summary/"}, method={RequestMethod.POST})
    public String summary(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        return super.summary(bean, model, redirectAttributes);
    }

    public String readProcessForwardPaymentUrl() {
        return PROCESS_FORWARD_PAYMENT_URL;
    }

    @RequestMapping(value={"/processforwardpayment/{forwardPayment}"}, method={RequestMethod.GET})
    public String processforwardpayment(@PathVariable(value="forwardPayment") ForwardPaymentRequest forwardPayment, Model model, HttpServletResponse response, HttpSession session) {
        return super.processforwardpayment(forwardPayment, model, response, session);
    }

    protected String readDebtAccountUrl() {
        return "/academictreasury/customer/viewaccount/account/read/";
    }

    protected String forwardPaymentInsuccessUrl(ForwardPaymentRequest forwardPayment) {
        return "/academictreasury/customer/forwardpayments/forwardpayment/forwardpaymentinsuccess/" + forwardPayment.getExternalId();
    }

    protected String forwardPaymentSuccessUrl(ForwardPaymentRequest forwardPayment) {
        return "/academictreasury/customer/forwardpayments/forwardpayment/forwardpaymentsuccess/" + forwardPayment.getExternalId();
    }

    @RequestMapping(value={"/forwardpaymentsuccess/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String forwardpaymentsuccess(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model) {
        return super.forwardpaymentsuccess(forwardPayment, model);
    }

    @RequestMapping(value={"/forwardpaymentinsuccess/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String forwardpaymentinsuccess(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model) {
        return super.forwardpaymentinsuccess(forwardPayment, model);
    }

    public String readPrintSettlementNoteUrl() {
        return PRINT_SETTLEMENT_NOTE_URL;
    }

    @RequestMapping(value={"/printsettlementnote/{settlementNoteId}"}, produces={"application/pdf"})
    @ResponseBody
    public Object printsettlementnote(@PathVariable(value="settlementNoteId") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        return super.printsettlementnote(settlementNote, model, redirectAttributes);
    }
}

