/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.academicdebtgenerationregistration;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/academicdebtgenerationregistration/academicdebtgenerationregistration"})
public class AcademicDebtGenerationRegistrationController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/academicdebtgenerationregistration/academicdebtgenerationregistration";
    private static final String JSP_PATH = "academicTreasury/academicdebtgenerationregistration/academicdebtgenerationregistration";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/academicdebtgenerationregistration/academicdebtgenerationregistration/create";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/academicdebtgenerationregistration/academicdebtgenerationregistration/create/";
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        return this._createFirstPage(debtAccount, model);
    }

    private String _createFirstPage(DebtAccount debtAccount, Model model) {
        model.addAttribute("AcademicDebtGenerationRegistration_registration_options", (Object)((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet());
        model.addAttribute("AcademicDebtGenerationRegistration_executionYear_options", AcademicDebtGenerationRule.findActive().map(r -> r.getExecutionYear()).collect(Collectors.toSet()).stream().sorted(ExecutionYear.COMPARATOR_BY_YEAR).collect(Collectors.toList()));
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="registrationId", required=false) Registration registration, @RequestParam(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicDebtGenerationRule.runAllActiveForRegistrationAndExecutionYear((Registration)registration, (ExecutionYear)executionYear, (boolean)false);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(debtAccount, model);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/academicdebtgenerationregistration/academicdebtgenerationregistration/" + page;
    }
}

