/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.customer;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.fenixframework.FenixFramework;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/accounting/managecustomer/changefiscalnumber"})
public class ChangePersonCustomerFiscalNumberController
extends TreasuryBaseController {
    public static final String CONTROLLER_URI = "/academictreasury/accounting/managecustomer/changefiscalnumber";
    private static final String JSP_PATH = "/treasury/accounting/managecustomer/changefiscalnumber";
    private static final String CHANGE_FISCAL_NUMBER_ACTION_CONFIRM_URI = "/changefiscalnumberactionconfirm";
    public static final String CHANGE_FISCAL_NUMBER_ACTION_CONFIRM_URL = "/academictreasury/accounting/managecustomer/changefiscalnumber/changefiscalnumberactionconfirm";
    private static final String CHANGE_FISCAL_NUMBER_FORM_URI = "/changefiscalnumberform";
    public static final String CHANGE_FISCAL_NUMBER_FORM_URL = "/academictreasury/accounting/managecustomer/changefiscalnumber/changefiscalnumberform";
    private static final String CHANGE_FISCAL_NUMBER_URI = "/change";
    public static final String CHANGE_FISCAL_NUMBER_URL = "/academictreasury/accounting/managecustomer/changefiscalnumber/change";
    private static final String UPDATE_FISCAL_ADDRESS_URI = "/updateFiscalAddress";
    public static final String UPDATE_FISCAL_ADDRESS_URL = "/academictreasury/accounting/managecustomer/changefiscalnumber/updateFiscalAddress";

    protected String getControllerURI() {
        return CONTROLLER_URI;
    }

    @RequestMapping(value={"/changefiscalnumberactionconfirm/{oid}"}, method={RequestMethod.GET})
    public String changefiscalnumberactionconfirm(@PathVariable(value="oid") PersonCustomer customer, Model model) {
        this.assertUserIsBackOfficeMember(model);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("changeFiscalNumberActionFormURI", (Object)this.getControllerURI());
        if (customer.isFiscalValidated() && customer.isFiscalCodeValid()) {
            model.addAttribute("fiscalNumberValid", (Object)true);
        }
        return this.jspPage(CHANGE_FISCAL_NUMBER_ACTION_CONFIRM_URI);
    }

    @RequestMapping(value={"/changefiscalnumberform/{oid}"}, method={RequestMethod.POST})
    public String changefiscalnumberform(@PathVariable(value="oid") PersonCustomer customer, Model model) {
        this.assertUserIsBackOfficeMember(model);
        AdhocCustomerBean bean = new AdhocCustomerBean((Customer)customer);
        return this._changefiscalnumberactionconfirm(customer, model, bean);
    }

    private String _changefiscalnumberactionconfirm(PersonCustomer customer, Model model, AdhocCustomerBean bean) {
        model.addAttribute("person", (Object)customer.getAssociatedPerson());
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("customerBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return "/academicTreasury/customer/changefiscalnumber/changefiscalnumberform";
    }

    @RequestMapping(value={"/change/{oid}"}, method={RequestMethod.POST})
    public String change(@PathVariable(value="oid") PersonCustomer customer, @RequestParam(value="bean") AdhocCustomerBean bean, @RequestParam(value="fiscalAddressId") PhysicalAddress fiscalAddress, Model model) {
        this.assertUserIsBackOfficeMember(model);
        try {
            if (!bean.isChangeFiscalNumberConfirmed()) {
                throw new TreasuryDomainException("message.Customer.changeFiscalNumber.confirmation", new String[0]);
            }
            customer.changeFiscalNumber(bean, fiscalAddress);
            return "redirect:/treasury/accounting/managecustomer/customer/read/" + customer.getExternalId();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._changefiscalnumberactionconfirm(customer, model, bean);
        }
    }

    @RequestMapping(value={"/updateFiscalAddress/{oid}"}, method={RequestMethod.GET})
    public String updatefiscaladdress(@PathVariable(value="oid") PersonCustomer customer, Model model) {
        this.assertUserIsBackOfficeMember(model);
        if (customer.isActive()) {
            throw new RuntimeException("customer is active");
        }
        model.addAttribute("person", (Object)customer.getAssociatedPerson());
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("fiscalAddresses", customer.getAssociatedPerson().getValidAddressesForFiscalData().stream().filter(pa -> TreasuryConstants.isSameCountryCode((String)customer.getAddressCountryCode(), (String)pa.getCountryOfResidence().getCode())).collect(Collectors.toList()));
        return "/academicTreasury/customer/updatefiscaladdress";
    }

    @RequestMapping(value={"/updateFiscalAddress/{oid}"}, method={RequestMethod.POST})
    public String editfiscaladdresspost(@PathVariable(value="oid") PersonCustomer customer, @RequestParam(value="fiscalAddressId") PhysicalAddress fiscalAddress, Model model) {
        this.assertUserIsBackOfficeMember(model);
        if (customer.isActive()) {
            throw new RuntimeException("customer is active");
        }
        try {
            FenixFramework.atomic(() -> customer.saveFiscalAddressFieldsInCustomer(fiscalAddress));
            return "redirect:/treasury/accounting/managecustomer/customer/read/" + customer.getExternalId();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.updatefiscaladdress(customer, model);
        }
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }
}

