/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui;

import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;

public class AcademicTreasuryBaseController
extends TreasuryBaseController {
    protected void assertUserIsManager(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isManager((String)loggedUsername)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.manager", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.manager", (String[])new String[0]));
    }

    protected void assertUserIsBackOfficeMember(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isBackOfficeMember((String)loggedUsername)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]));
    }

    protected void assertUserIsFrontOfficeMember(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isFrontOfficeMember((String)loggedUsername)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }

    protected void assertUserIsBackOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isBackOfficeMember((String)loggedUsername, (FinantialInstitution)finantialInstitution)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]));
    }

    protected void assertUserIsFrontOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isFrontOfficeMember((String)loggedUsername, (FinantialInstitution)finantialInstitution)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }
}

