/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.signals;

import com.google.common.eventbus.Subscribe;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

public class ImprovementEnrolmentHandler {
    @Subscribe
    public void improvementEnrolment(DomainObjectEvent<EnrolmentEvaluation> event) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        EnrolmentEvaluation enrolmentEvaluation = (EnrolmentEvaluation)event.getInstance();
        LocalDate when = enrolmentEvaluation.getWhenDateTime().toLocalDate();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(enrolmentEvaluation.getDegreeCurricularPlan().getDegree(), when);
        AcademicTaxServices.createImprovementTax((FinantialEntity)finantialEntity, (EnrolmentEvaluation)enrolmentEvaluation, (LocalDate)when);
    }
}

