/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managetuitionpaymentplan.extracurricular;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageTuitionPaymentPlanExtracurricular", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/academictreasury/tuitionpaymentplanextracurricular"})
@Deprecated
public class TuitionPaymentPlanControllerExtracurricular
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/tuitionpaymentplanextracurricular";
    private static final String JSP_PATH = "academicTreasury/tuitionpaymentplanextracurricular";
    private static final String _CHOOSEFINANTIALENTITY_URI = "/choosefinantialentity";
    public static final String CHOOSEFINANTIALENTITY_URL = "/academictreasury/tuitionpaymentplanextracurricular/choosefinantialentity";
    private static final String _CHOOSEDEGREECURRICULARPLAN_URI = "/choosedegreecurricularplan";
    public static final String CHOOSEDEGREECURRICULARPLAN_URL = "/academictreasury/tuitionpaymentplanextracurricular/choosedegreecurricularplan";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/academictreasury/tuitionpaymentplanextracurricular/";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/academictreasury/tuitionpaymentplanextracurricular/search/delete";
    private static final String _CREATECHOOSEDEGREECURRICULARPLANS_URI = "/createchoosedegreecurricularplans";
    public static final String CREATECHOOSEDEGREECURRICULARPLANS_URL = "/academictreasury/tuitionpaymentplanextracurricular/createchoosedegreecurricularplans";
    private static final String _CREATECHOOSEDEGREECURRICULARPLANSPOSTBACK_URI = "/createchoosedegreecurricularplanspostback";
    public static final String CREATECHOOSEDEGREECURRICULARPLANSPOSTBACK_URL = "/academictreasury/tuitionpaymentplanextracurricular/createchoosedegreecurricularplanspostback";
    private static final String _CREATEDEFINESTUDENTCONDITIONS_URI = "/createdefinestudentconditions";
    public static final String CREATEDEFINESTUDENTCONDITIONS_URL = "/academictreasury/tuitionpaymentplanextracurricular/createdefinestudentconditions";
    private static final String _CREATEDEFINESTUDENTCONDITIONSPOSTBACK_URI = "/createdefinestudentconditionspostback";
    public static final String CREATEDEFINESTUDENTCONDITIONSPOSTBACK_URL = "/academictreasury/tuitionpaymentplanextracurricular/createdefinestudentconditionspostback";
    private static final String _CREATEPAYMENTPLAN_URI = "/createpaymentplan";
    public static final String CREATEPAYMENTPLAN_URL = "/academictreasury/tuitionpaymentplanextracurricular/createpaymentplan";
    private static final String BACKTODEGREECURRICULARPLAN_TO_CHOOSE_ACTION_URI = "/backtochoosedegreecurricularplans";
    public static final String BACKTODEGREECURRICULARPLAN_TO_CHOOSE_ACTION_URL = "/academictreasury/tuitionpaymentplanextracurricular/backtochoosedegreecurricularplans";
    private static final String _ORDER_UP_ACTION_URI = "/paymentplanorderup";
    public static final String ORDER_UP_ACTION_URL = "/academictreasury/tuitionpaymentplanextracurricular/paymentplanorderup";
    private static final String _ORDER_DOWN_ACTION_URI = "/paymentplanorderdown";
    public static final String ORDER_DOWN_ACTION_URL = "/academictreasury/tuitionpaymentplanextracurricular/paymentplanorderdown";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/tuitionpaymentplanextracurricular/choosefinantialentity";
    }

    @RequestMapping(value={"/choosefinantialentity"})
    public String chooseFinantialEntity(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        model.addAttribute("choosefinantialentityResultsDataSet", FinantialEntity.findWithBackOfficeAccessFor((String)loggedUsername).sorted(FinantialEntity.COMPARE_BY_NAME).collect(Collectors.toList()));
        model.addAttribute("executionYear", (Object)ExecutionYear.readCurrentExecutionYear());
        return this.jspPage("choosefinantialentity");
    }

    @RequestMapping(value={"/choosedegreecurricularplan/{finantialEntityId}/{executionYearId}"})
    public String chooseDegreeCurricularPlan(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model) {
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get();
        Set firstSet = ExecutionDegree.getAllByExecutionYear((ExecutionYear)executionYear).stream().map(e -> e.getDegreeCurricularPlan()).collect(Collectors.toSet());
        Set secondSet = TuitionPaymentPlan.find((TuitionPaymentPlanGroup)tuitionPaymentPlanGroup, (FinantialEntity)finantialEntity, (ExecutionYear)executionYear).map(e -> e.getDegreeCurricularPlan()).collect(Collectors.toSet());
        ArrayList degreeCurricularPlanList = Lists.newArrayList((Iterable)Sets.union(firstSet, secondSet));
        Collections.sort((List)degreeCurricularPlanList, (Comparator)DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        model.addAttribute("choosedegreecurricularplanResultsDataSet", (Object)degreeCurricularPlanList);
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        ArrayList executionYearList = new ArrayList(ExecutionYear.readNotClosedExecutionYears());
        Collections.sort(executionYearList, (Comparator)ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        model.addAttribute("executionYearOptions", executionYearList);
        return this.jspPage("choosedegreecurricularplan");
    }

    @RequestMapping(value={"/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"})
    public String search(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        model.addAttribute("searchtuitionpaymentplanResultsDataSet", TuitionPaymentPlan.findSortedByPaymentPlanOrder((TuitionPaymentPlanGroup)((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get()), (DegreeCurricularPlan)degreeCurricularPlan, (ExecutionYear)executionYear).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/delete/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model, RedirectAttributes redirectAttributes) {
        try {
            tuitionPaymentPlan.delete();
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.deletion.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(String.format("/academictreasury/tuitionpaymentplanextracurricular//%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/createchoosedegreecurricularplans/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.GET})
    public String createchoosedegreecurricularplans(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model) {
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().isPresent()) {
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlanGroup.defaultGroupForExtracurricular.required", (String[])new String[0]), model);
            return this.chooseDegreeCurricularPlan(finantialEntity, executionYear, model);
        }
        TuitionPaymentPlanBean bean = new TuitionPaymentPlanBean(null, (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), finantialEntity, executionYear);
        return this._createchoosedegreecurricularplans(finantialEntity, executionYear, model, bean);
    }

    private String _createchoosedegreecurricularplans(FinantialEntity finantialEntity, ExecutionYear executionYear, Model model, TuitionPaymentPlanBean bean) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage("createchoosedegreecurricularplans");
    }

    @RequestMapping(value={"/createchoosedegreecurricularplanspostback/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createchoosedegreecurricularplanspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createdefinestudentconditions/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST})
    public String createdefinestudentconditions(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        if (bean.getDegreeType() == null || bean.getDegreeCurricularPlans().isEmpty()) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.TuitionPaymentPlan.choose.degree.curricular.plans", (String[])new String[0]), model);
            return this._createchoosedegreecurricularplans(finantialEntity, executionYear, model, bean);
        }
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage("createdefinestudentconditions");
    }

    @RequestMapping(value={"/createdefinestudentconditionspostback/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createdefinestudentconditionspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createpaymentplan/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST})
    public String createinsertinstallments(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) TuitionPaymentPlanBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (bean.isCustomized() && Strings.isNullOrEmpty((String)bean.getName())) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.TuitionPaymentPlan.custom.payment.plan.name.required", (String[])new String[0]), model);
                return this.createdefinestudentconditions(finantialEntity, executionYear, bean, model);
            }
            List errorMessages = bean.addInstallment();
            if (!errorMessages.isEmpty()) {
                for (String error : errorMessages) {
                    this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)error, (String[])new String[0]), model);
                }
                return this.createdefinestudentconditions(finantialEntity, executionYear, bean, model);
            }
            TuitionPaymentPlan.create((TuitionPaymentPlanBean)bean);
            return this.redirect(String.format("%s/%s/%s", CHOOSEDEGREECURRICULARPLAN_URL, finantialEntity.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            bean.getTuitionCalculationTypeDataSource().clear();
            return this.createdefinestudentconditions(finantialEntity, executionYear, bean, model);
        }
    }

    @RequestMapping(value={"/backtochoosedegreecurricularplans/{finantialEntityId}/{executionYearId}"})
    public String processBackToChooseDegreeCurricularPlansAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage("createchoosedegreecurricularplans");
    }

    @RequestMapping(value={"/paymentplanorderup/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.GET})
    public String processOrderUpAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.order.up.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(String.format("/academictreasury/tuitionpaymentplanextracurricular//%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/paymentplanorderdown/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.GET})
    public String processOrderDownAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.order.down.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(String.format("/academictreasury/tuitionpaymentplanextracurricular//%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    private String jspPage(String page) {
        return "academicTreasury/tuitionpaymentplanextracurricular/" + page;
    }
}

