/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageservicerequestmapentry;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Product;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageServiceRequestMapEntry", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/manageservicerequestmapentry/servicerequestmapentry"})
public class ServiceRequestMapEntryController
extends AcademicTreasuryBaseController {
    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/manageservicerequestmapentry/servicerequestmapentry/";
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        model.addAttribute("searchservicerequestmapentryResultsDataSet", ServiceRequestMapEntry.findAll().collect(Collectors.toList()));
        return "academicTreasury/manageservicerequestmapentry/servicerequestmapentry/search";
    }

    @RequestMapping(value={"/search/delete/{serviceRequestMapEntryId}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="serviceRequestMapEntryId") ServiceRequestMapEntry serviceRequestMapEntry, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("serviceRequestMapEntry", (Object)serviceRequestMapEntry);
        try {
            serviceRequestMapEntry.delete();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.ServiceRequestMapEntry.delete.success", (String[])new String[0]), model);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.redirect("/academictreasury/manageservicerequestmapentry/servicerequestmapentry/", model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("ServiceRequestMapEntry_serviceRequestType_options", ServiceRequestType.findAll().collect(Collectors.toList()));
        model.addAttribute("ServiceRequestMapEntry_product_options", Product.findAllActive().collect(Collectors.toList()));
        model.addAttribute("ServiceRequestMapEntry_situationType_options", (Object)AcademicServiceRequestSituationType.values());
        return "academicTreasury/manageservicerequestmapentry/servicerequestmapentry/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="servicerequesttype", required=false) ServiceRequestType serviceRequestType, @RequestParam(value="product", required=false) Product product, @RequestParam(value="createEventOnSituation", required=true) AcademicServiceRequestSituationType createEventOnSituationType, @RequestParam(value="generatePaymentCode", required=true) boolean generatePaymentCode, @RequestParam(value="debitEntryDescriptionExtensionFormat", required=false) String debitEntryDescriptionExtensionFormat, Model model, RedirectAttributes redirectAttributes) {
        try {
            ServiceRequestMapEntry.create((Product)product, (ServiceRequestType)serviceRequestType, (AcademicServiceRequestSituationType)createEventOnSituationType, (boolean)generatePaymentCode, (String)debitEntryDescriptionExtensionFormat);
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.ServiceRequestMapEntry.create.success", (String[])new String[0]), model);
            return this.redirect("/academictreasury/manageservicerequestmapentry/servicerequestmapentry/", model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(model);
        }
    }
}

