/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.document.forwardpayments.implementations.onlinepaymentsgateway.sibs;

import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.AdhocCustomer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsBillingAddressBean;
import org.fenixedu.treasury.domain.sibspaymentsgateway.SibsPaymentsGatewayLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.ui.TreasuryController;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=TreasuryController.class, title="label.title.returnSibsOnlinePaymentsGatewayForwardPayment", accessGroup="logged")
@RequestMapping(value={"/treasury/document/forwardpayments/sibsonlinepaymentsgateway"})
public class SibsOnlinePaymentsGatewayForwardPaymentController
extends AcademicTreasuryBaseController
implements IForwardPaymentController {
    private static final String DEFAULT_ZIP_CODE = "0000-000";
    private static final String DEFAULT_ADDRESS = "Desconhecido";
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway";
    private static final String JSP_PATH = "/academicTreasury/document/forwardpayments/forwardpayment/implementations/sibsonlinepaymentsgateway";
    private static final String PROCESS_FORWARD_PAYMENT_URI = "/processforwardpayment";
    private static final Logger logger = LoggerFactory.getLogger(SibsOnlinePaymentsGatewayForwardPaymentController.class);
    private static final String _SELECT_PHYSICAL_ADDRESS_URI = "/selectphysicaladdress";
    public static final String SELECT_PHYSICAL_ADDRESS_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway/selectphysicaladdress";
    private static final String _CONTINUE_PROCESS_FORWARD_PAYMENT_URI = "/continueProcessForwardPayment";
    public static final String CONTINUE_PROCESS_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway/continueProcessForwardPayment";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway/returnforwardpayment";
    private static final long SLEEP_TIME_TO_PROCESS_WEBHOOK = 5000L;

    public String processforwardpayment(ForwardPaymentRequest forwardPayment, Object model, HttpServletResponse response, HttpSession session) {
        DebtAccount debtAccount = forwardPayment.getDebtAccount();
        String debtAccountUrl = (String)session.getAttribute("debtAccountUrl");
        if (debtAccount.getCustomer().isAdhocCustomer()) {
            this.continueProcessForwardPayment(forwardPayment, (Model)model, response, session);
        }
        Person person = ((PersonCustomer)debtAccount.getCustomer()).getAssociatedPerson();
        SibsPaymentsGateway gateway = (SibsPaymentsGateway)forwardPayment.getDigitalPaymentPlatform();
        ((Model)model).addAttribute("debtAccountUrl", (Object)debtAccountUrl);
        ((Model)model).addAttribute("forwardPayment", (Object)forwardPayment);
        ((Model)model).addAttribute("forwardPaymentConfiguration", (Object)gateway);
        ((Model)model).addAttribute("debtAccount", (Object)debtAccount);
        ((Model)model).addAttribute("logosPage", (Object)gateway.getLogosJspPage());
        ((Model)model).addAttribute("physicalAddresses", person.getValidAddressesForFiscalData().stream().collect(Collectors.toList()));
        return this.jspPage(_SELECT_PHYSICAL_ADDRESS_URI);
    }

    @RequestMapping(value={"/selectphysicaladdress/{forwardPaymentId}"}, method={RequestMethod.POST})
    public String selectphysicaladdress(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, @RequestParam(value="physicalAddressId") PhysicalAddress physicalAddress, Model model, HttpServletResponse response, HttpSession session, RedirectAttributes redirectAttributes) {
        if (physicalAddress == null) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.SibsOnlinePaymentsGatewayForwardPaymentController.select.address", (String[])new String[0]), model);
            return this.processforwardpayment(forwardPayment, model, response, session);
        }
        return this.continueProcessForwardPayment(forwardPayment, physicalAddress, model, response, session);
    }

    @RequestMapping(value={"/continueProcessForwardPayment/{forwardPaymentId}"})
    public String continueProcessForwardPayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model, HttpServletResponse response, HttpSession session) {
        return this.continueProcessForwardPayment(forwardPayment, null, model, response, session);
    }

    @RequestMapping(value={"/continueProcessForwardPayment/{forwardPaymentId}/{physicalAddressId}"})
    public String continueProcessForwardPayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, @PathVariable(value="physicalAddressId") PhysicalAddress physicalAddress, Model model, HttpServletResponse response, HttpSession session) {
        this.checkPermissions(forwardPayment, physicalAddress);
        try {
            ForwardPaymentStatusBean bean;
            if (!forwardPayment.isInCreatedState()) {
                AcademicTreasuryDomainException e = new AcademicTreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardPaymentController.invalid.state.restart.process.again.01", new String[0]);
                FenixFramework.atomic(() -> forwardPayment.reject("continueProcessForwardPayment", "", e.getLocalizedMessage(), "", "").logException((Exception)((Object)e)));
                throw e;
            }
            if (!StringUtils.isEmpty((String)forwardPayment.getMerchantTransactionId())) {
                AcademicTreasuryDomainException e = new AcademicTreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardPaymentController.invalid.state.restart.process.again.02", new String[0]);
                FenixFramework.atomic(() -> forwardPayment.reject("continueProcessForwardPayment", "", e.getLocalizedMessage(), "", "").logException((Exception)((Object)e)));
                throw e;
            }
            String debtAccountUrl = (String)session.getAttribute("debtAccountUrl");
            if (forwardPayment.isInRejectedState()) {
                throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
            }
            if (forwardPayment.isInPaidState()) {
                throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
            }
            SibsPaymentsGateway impl = (SibsPaymentsGateway)forwardPayment.getDigitalPaymentPlatform();
            SibsBillingAddressBean billingAddressBean = new SibsBillingAddressBean();
            if (forwardPayment.getDebtAccount().getCustomer().isAdhocCustomer()) {
                billingAddressBean.setAddressCountryCode(forwardPayment.getDebtAccount().getCustomer().getAddressCountryCode());
                billingAddressBean.setCity(this.billingCity((AdhocCustomer)forwardPayment.getDebtAccount().getCustomer()));
                billingAddressBean.setAddress(forwardPayment.getDebtAccount().getCustomer().getAddress());
                billingAddressBean.setZipCode(forwardPayment.getDebtAccount().getCustomer().getZipCode());
            } else if (physicalAddress != null) {
                billingAddressBean.setAddressCountryCode(PersonCustomer.addressCountryCode((PhysicalAddress)physicalAddress));
                billingAddressBean.setCity(this.billingCity(physicalAddress));
                billingAddressBean.setAddress(PersonCustomer.address((PhysicalAddress)physicalAddress));
                billingAddressBean.setZipCode(PersonCustomer.zipCode((PhysicalAddress)physicalAddress));
            } else {
                throw new AcademicTreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardPaymentController.missing.physical.address", new String[0]);
            }
            if (StringUtils.isEmpty((String)billingAddressBean.getZipCode())) {
                billingAddressBean.setZipCode(DEFAULT_ZIP_CODE);
            }
            if (StringUtils.isEmpty((String)billingAddressBean.getAddress())) {
                billingAddressBean.setAddress(DEFAULT_ADDRESS);
            }
            if (StringUtils.isEmpty((String)billingAddressBean.getCity())) {
                billingAddressBean.setCity(DEFAULT_ADDRESS);
            }
            if (!(bean = impl.prepareCheckout(forwardPayment, billingAddressBean)).isInvocationSuccess()) {
                return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
            }
            model.addAttribute("debtAccountUrl", (Object)debtAccountUrl);
            model.addAttribute("paymentScriptUrl", (Object)impl.getPaymentURL(forwardPayment));
            model.addAttribute("forwardPaymentConfiguration", (Object)forwardPayment.getDigitalPaymentPlatform());
            model.addAttribute("debtAccount", (Object)forwardPayment.getDebtAccount());
            model.addAttribute("checkoutId", (Object)forwardPayment.getCheckoutId());
            model.addAttribute("shopperResultUrl", (Object)impl.getReturnURL(forwardPayment));
            model.addAttribute("paymentBrands", (Object)bean.getSibsOnlinePaymentBrands());
            model.addAttribute("logosPage", (Object)impl.getLogosJspPage());
            return this.jspPage(PROCESS_FORWARD_PAYMENT_URI);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
    }

    private void checkPermissions(ForwardPaymentRequest forwardPayment, PhysicalAddress physicalAddress) {
        PersonCustomer personCustomer;
        if (forwardPayment.getDebtAccount().getCustomer().isPersonCustomer() && (personCustomer = (PersonCustomer)forwardPayment.getDebtAccount().getCustomer()).getAssociatedPerson() != physicalAddress.getParty()) {
            throw new SecurityException("not authorized");
        }
    }

    private String billingCity(AdhocCustomer customer) {
        if (!StringUtils.isEmpty((String)customer.getDistrictSubdivision())) {
            return customer.getDistrictSubdivision();
        }
        return customer.getRegion();
    }

    private String billingCity(PhysicalAddress physicalAddress) {
        if (!StringUtils.isEmpty((String)PersonCustomer.districtSubdivision((PhysicalAddress)physicalAddress))) {
            return PersonCustomer.districtSubdivision((PhysicalAddress)physicalAddress);
        }
        return PersonCustomer.region((PhysicalAddress)physicalAddress);
    }

    @RequestMapping(value={"/returnforwardpayment/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String returnforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, @RequestParam(value="id") String sibsCheckoutId, Model model, HttpServletResponse response, HttpSession session) {
        try {
            Thread.sleep(5000L);
            session.setAttribute("debtAccountUrl", null);
            SibsPaymentsGateway impl = (SibsPaymentsGateway)forwardPayment.getDigitalPaymentPlatform();
            DateTime requestSendDate = new DateTime();
            ForwardPaymentStatusBean bean = impl.paymentStatusByCheckoutId(forwardPayment);
            DateTime requestReceiveDate = new DateTime();
            FenixFramework.atomic(() -> {
                if (StringUtils.isEmpty((String)forwardPayment.getTransactionId())) {
                    forwardPayment.setTransactionId(bean.getTransactionId());
                }
            });
            if (bean.isInPayedState()) {
                FenixFramework.atomic(() -> {
                    if (forwardPayment.isInPaidState()) {
                        return;
                    }
                    SibsPaymentsGatewayLog log = (SibsPaymentsGatewayLog)forwardPayment.advanceToPaidState(bean.getStatusCode(), bean.getStatusMessage(), bean.getPayedAmount(), bean.getTransactionDate(), bean.getTransactionId(), null, bean.getRequestBody(), bean.getResponseBody(), "");
                    log.setRequestSendDate(requestSendDate);
                    log.setRequestReceiveDate(requestReceiveDate);
                    log.setSibsGatewayTransactionId(bean.getTransactionId());
                });
                return String.format("redirect:%s", forwardPayment.getForwardPaymentSuccessUrl());
            }
            FenixFramework.atomic(() -> {
                if (forwardPayment.isInRejectedState()) {
                    return;
                }
                SibsPaymentsGatewayLog log = (SibsPaymentsGatewayLog)forwardPayment.reject("returnforwardpayment", bean.getStatusCode(), bean.getStatusMessage(), bean.getRequestBody(), bean.getResponseBody());
                log.setRequestSendDate(requestSendDate);
                log.setRequestReceiveDate(requestReceiveDate);
                log.setSibsGatewayTransactionId(bean.getTransactionId());
            });
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }

    public static IForwardPaymentController getForwardPaymentController(ForwardPaymentRequest forwardPayment) {
        return new SibsOnlinePaymentsGatewayForwardPaymentController();
    }
}

