/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.accesscontrol.spi;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControlConfiguration;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;
import org.joda.time.LocalDate;

public class AcademicTreasuryAccessControlExtension
implements ITreasuryAccessControlExtension<Object> {
    public boolean isFrontOfficeMember(String username) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return FinantialInstitution.findAll().map(l -> this.isFrontOfficeMember(username, (FinantialInstitution)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isFrontOfficeMember(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isFrontOfficeMember(String username, FinantialEntity finantialEntity) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public boolean isFrontOfficeMemberWithinContext(String username, Object context) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (context instanceof Degree) {
            Degree degree = (Degree)context;
            FinantialEntity finantialEntity = services.finantialEntityOfDegree(degree, new LocalDate());
            return this.isFrontOfficeMember(username, finantialEntity);
        }
        return false;
    }

    public boolean isBackOfficeMember(String username) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return FinantialInstitution.findAll().map(l -> this.isBackOfficeMember(username, (FinantialInstitution)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isBackOfficeMember(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS_ADV, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public boolean isBackOfficeMemberWithinContext(String username, Object context) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (context instanceof Degree) {
            Degree degree = (Degree)context;
            FinantialEntity finantialEntity = services.finantialEntityOfDegree(degree, new LocalDate());
            if (finantialEntity == null) {
                return false;
            }
            return this.isBackOfficeMember(username, finantialEntity);
        }
        return false;
    }

    public boolean isContextObjectApplied(Object context) {
        return context instanceof Degree;
    }

    public boolean isManager(String username) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return false;
    }

    public boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isAllowToModifySettlements(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isAllowToModifySettlements(String username, FinantialEntity finantialEntity) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.PAYMENTS_MODIFY_SETTLEMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isAllowToModifyInvoices(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isAllowToModifyInvoices(String username, FinantialEntity finantialEntity) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.PAYMENTS_MODIFY_INVOICES, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return false;
    }

    public boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return false;
        }
        return false;
    }

    public Set<String> getFrontOfficeMemberUsernames() {
        HashSet result = Sets.newHashSet();
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return result;
        }
        FinantialEntity.findAll().forEach(entity -> result.addAll(AcademicAccessRule.getMembers((AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Collections.emptySet(), Collections.singleton(entity.getAdministrativeOffice())).filter(u -> !Strings.isNullOrEmpty((String)u.getUsername())).map(u -> u.getUsername()).collect(Collectors.toSet())));
        return result;
    }

    public Set<String> getBackOfficeMemberUsernames() {
        HashSet result = Sets.newHashSet();
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return result;
        }
        FinantialEntity.findAll().forEach(entity -> result.addAll(AcademicAccessRule.getMembers((AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS_ADV, Collections.emptySet(), Collections.singleton(entity.getAdministrativeOffice())).filter(u -> !Strings.isNullOrEmpty((String)u.getUsername())).map(u -> u.getUsername()).collect(Collectors.toSet())));
        return result;
    }

    public Set<String> getTreasuryManagerMemberUsernames() {
        if (!TreasuryAccessControlConfiguration.isAccessControlByAcademicAuthorizations()) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet();
    }
}

