/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managetuitionpaymentplan;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportFile;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.web.servlet.view.RedirectView;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.importTreasury", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/importtreasury"})
public class ImportTreasuryController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/importtreasury";
    private static final String JSP_PATH = "academicTreasury/importtreasury";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/importtreasury/search";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/importtreasury/create";
    private static final String _VIEW_URI = "/view";
    public static final String VIEW_URL = "/academictreasury/importtreasury/view";
    private static final String _PROCESS_URI = "/process";
    public static final String PROCESS_URL = "/academictreasury/importtreasury/process";
    private static final String _DOWNLOAD_URI = "/download";
    public static final String DOWNLOAD_URL = "/academictreasury/importtreasury/download";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/importtreasury/search";
    }

    @RequestMapping(value={"/search"})
    public String search(Model model) {
        model.addAttribute("requestFiles", TreasuryImportFile.findAll().collect(Collectors.toList()));
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("treasuryImportTypes", TreasuryImportType.findAll().sorted(TreasuryImportType.COMPARE_BY_NAME).collect(Collectors.toList()));
        return this.jspPage(_CREATE_URI);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String createpost(@RequestParam(value="treasuryImportTypeId") TreasuryImportType type, @RequestParam(value="requestFile", required=true) MultipartFile requestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (type == null) {
                throw new AcademicTreasuryDomainException("error.TreasuryImportFile.type.required", new String[0]);
            }
            byte[] content = requestFile.getBytes();
            type.implementation().readExcel(content);
            TreasuryImportFile treasuryImportFile = TreasuryImportFile.create((TreasuryImportType)type, (String)requestFile.getOriginalFilename(), (byte[])content);
            return this.redirect("/academictreasury/importtreasury/view/" + treasuryImportFile.getExternalId(), model, redirectAttributes);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    @RequestMapping(value={"/view/{treasuryImportFileId}"})
    public View view(@PathVariable(value="treasuryImportFileId") TreasuryImportFile treasuryImportFile, Model model) {
        model.addAttribute("treasuryImportFile", (Object)treasuryImportFile);
        model.addAttribute("objects", treasuryImportFile.getTreasuryImportType().implementation().readExcel(treasuryImportFile.getContent()));
        return new JstlView(treasuryImportFile.getTreasuryImportType().implementation().viewUrl()){

            protected void exposeHelpers(HttpServletRequest request) throws Exception {
                this.setServletContext(request.getServletContext());
                super.exposeHelpers(request);
            }
        };
    }

    @RequestMapping(value={"/process/{treasuryImportFileId}"}, method={RequestMethod.POST})
    public View process(@PathVariable(value="treasuryImportFileId") TreasuryImportFile treasuryImportFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            treasuryImportFile.getTreasuryImportType().implementation().process(treasuryImportFile);
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.ImportTreasury.process.success", (String[])new String[0]), model);
            if (Strings.isNullOrEmpty((String)this.request.getContextPath())) {
                return new RedirectView("/academictreasury/importtreasury/view/" + treasuryImportFile.getExternalId());
            }
            return new RedirectView(this.request.getContextPath() + "/academictreasury/importtreasury/view/" + treasuryImportFile.getExternalId());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.view(treasuryImportFile, model);
        }
    }

    @RequestMapping(value={"/download/{treasuryImportFileId}"})
    @ResponseBody
    public byte[] download(@PathVariable(value="treasuryImportFileId") TreasuryImportFile treasuryImportFile, HttpServletRequest request, HttpServletResponse response, Model model) {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-disposition", "attachment; filename=" + treasuryImportFile.getFilename());
        return treasuryImportFile.getContent();
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }
}

