/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managetuitionpaymentplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.managetuitionpaymentplan.FinantialEntityController;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Component(value="org.fenixedu.academicTreasury.ui.manageTuitionPaymentPlan")
@BennuSpringController(value=FinantialEntityController.class)
@RequestMapping(value={"/academictreasury/managetuitionpaymentplan/degreecurricularplan"})
public class DegreeCurricularPlanController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/managetuitionpaymentplan/degreecurricularplan";
    public static final String JSP_PATH = "academicTreasury/managetuitionpaymentplan/degreecurricularplan";
    private static final String _CHOOSEDEGREECURRICULARPLAN_URI = "/choosedegreecurricularplan";
    public static final String CHOOSEDEGREECURRICULARPLAN_URL = "/academictreasury/managetuitionpaymentplan/degreecurricularplan/choosedegreecurricularplan";
    private static final String _CHOOSEDEGREECURRICULARPLAN_TO_CHOOSE_ACTION_URI = "/chooseDegreeCurricularPlan/choose/";
    public static final String CHOOSEDEGREECURRICULARPLAN_TO_CHOOSE_ACTION_URL = "/academictreasury/managetuitionpaymentplan/degreecurricularplan/chooseDegreeCurricularPlan/choose/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/managetuitionpaymentplan/degreecurricularplan/";
    }

    @RequestMapping(value={"/choosedegreecurricularplan/{finantialEntityId}/{executionYearId}"})
    public String chooseDegreeCurricularPlan(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model) {
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get();
        Set firstSet = ExecutionDegree.getAllByExecutionYear((ExecutionYear)executionYear).stream().map(e -> e.getDegreeCurricularPlan()).collect(Collectors.toSet());
        Set secondSet = TuitionPaymentPlan.find((TuitionPaymentPlanGroup)tuitionPaymentPlanGroup, (FinantialEntity)finantialEntity, (ExecutionYear)executionYear).map(e -> e.getDegreeCurricularPlan()).collect(Collectors.toSet());
        ArrayList degreeCurricularPlanList = Lists.newArrayList((Iterable)Sets.union(firstSet, secondSet));
        Collections.sort((List)degreeCurricularPlanList, (Comparator)DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        model.addAttribute("choosedegreecurricularplanResultsDataSet", (Object)degreeCurricularPlanList);
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        ArrayList executionYearList = new ArrayList(ExecutionYear.readNotClosedExecutionYears());
        Collections.sort(executionYearList, (Comparator)ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        model.addAttribute("executionYearOptions", executionYearList);
        return this.jspPage("choosedegreecurricularplan");
    }

    @RequestMapping(value={"/chooseDegreeCurricularPlan/choose//{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"})
    public String processChooseDegreeCurricularPlanToChooseAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(String.format("/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    private String jspPage(String page) {
        return "academicTreasury/managetuitionpaymentplan/degreecurricularplan/" + page;
    }
}

