/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managefinantialentityadministrativeoffice;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.ui.managefinantialentityadministrativeoffice.FinantialEntityController$callable$associateFinantialEntityWithAdministrativeOffice;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Component(value="org.fenixedu.academictreasury.ui.managefinantialentityadministrativeoffice")
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageFinantialEntityAdministrativeOffice", accessGroup="treasuryManagers")
@RequestMapping(value={"/academicTreasury/managefinantialentityadministrativeoffice/finantialentity"})
public class FinantialEntityController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academicTreasury/managefinantialentityadministrativeoffice/finantialentity";
    public static final String JSP_PATH = "academicTreasury/managefinantialentityadministrativeoffice/finantialentity";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/academicTreasury/managefinantialentityadministrativeoffice/finantialentity/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/academicTreasury/managefinantialentityadministrativeoffice/finantialentity/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/academicTreasury/managefinantialentityadministrativeoffice/finantialentity/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/academicTreasury/managefinantialentityadministrativeoffice/finantialentity/update/";
    public static final Advice advice$associateFinantialEntityWithAdministrativeOffice = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/academicTreasury/managefinantialentityadministrativeoffice/finantialentity/";
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        model.addAttribute("searchfinantialentityResultsDataSet", FinantialEntity.findAll().sorted(FinantialEntity.COMPARE_BY_NAME).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/view/{oid}"}, method={RequestMethod.GET})
    public String processSearchToViewAction(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + finantialEntity.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"}, method={RequestMethod.GET})
    public String read(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        return this.jspPage("read");
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("FinantialEntity_administrativeOffice_options", (Object)Bennu.getInstance().getAdministrativeOfficesSet());
        return this.jspPage("update");
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") FinantialEntity finantialEntity, @RequestParam(value="administrativeoffice", required=false) AdministrativeOffice administrativeOffice, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.associateFinantialEntityWithAdministrativeOffice(finantialEntity, administrativeOffice);
            return this.redirect(READ_URL + finantialEntity.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.update(finantialEntity, model);
        }
    }

    private void associateFinantialEntityWithAdministrativeOffice(FinantialEntity finantialEntity, AdministrativeOffice administrativeOffice) {
        Object object = advice$associateFinantialEntityWithAdministrativeOffice.perform((Callable)new FinantialEntityController$callable$associateFinantialEntityWithAdministrativeOffice(this, finantialEntity, administrativeOffice));
    }

    static /* synthetic */ void advised$associateFinantialEntityWithAdministrativeOffice(FinantialEntityController this_, FinantialEntity finantialEntity, AdministrativeOffice administrativeOffice) {
        finantialEntity.setAdministrativeOffice(administrativeOffice);
    }

    private String jspPage(String page) {
        return "academicTreasury/managefinantialentityadministrativeoffice/finantialentity/" + page;
    }
}

