/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managedebtreportrequests;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultErrorsFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultFile;
import org.fenixedu.academictreasury.dto.reports.DebtReportRequestBean;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageDebtReportRequests", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/academictreasury/managedebtreportrequests/debtreportrequest"})
public class DebtReportRequestController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/managedebtreportrequests/debtreportrequest";
    private static final String JSP_PATH = "/academicTreasury/managedebtreportrequests/debtreportrequest";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/academictreasury/managedebtreportrequests/debtreportrequest/";
    private static final String _SEARCH_TO_CANCELREQUEST_ACTION_URI = "/search/cancelRequest/";
    public static final String SEARCH_TO_CANCELREQUEST_ACTION_URL = "/academictreasury/managedebtreportrequests/debtreportrequest/search/cancelRequest/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/managedebtreportrequests/debtreportrequest/create";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/managedebtreportrequests/debtreportrequest/createpostback";
    private static final String _DOWNLOAD_URI = "/download";
    public static final String DOWNLOAD_URL = "/academictreasury/managedebtreportrequests/debtreportrequest/download";
    private static final String _DOWNLOAD_ERRORS_URI = "/downloadErrors";
    public static final String DOWNLOAD_ERRORS_URL = "/academictreasury/managedebtreportrequests/debtreportrequest/downloadErrors";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/managedebtreportrequests/debtreportrequest/";
    }

    private void setDebtReportRequestBean(DebtReportRequestBean bean, Model model) {
        model.addAttribute("debtReportRequestBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("debtReportRequestBean", (Object)bean);
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        List<DebtReportRequest> searchdebtreportrequestResultsDataSet = this.filterSearchDebtReportRequest();
        model.addAttribute("searchdebtreportrequestResultsDataSet", searchdebtreportrequestResultsDataSet);
        return this.jspPage("search");
    }

    private Stream<DebtReportRequest> getSearchUniverseSearchDebtReportRequestDataSet() {
        return DebtReportRequest.findAll();
    }

    private List<DebtReportRequest> filterSearchDebtReportRequest() {
        return this.getSearchUniverseSearchDebtReportRequestDataSet().collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/cancelRequest/{oid}"})
    public String processSearchToCancelRequestAction(@PathVariable(value="oid") DebtReportRequest debtReportRequest, Model model, RedirectAttributes redirectAttributes) {
        debtReportRequest.cancelRequest();
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        DebtReportRequestBean bean = new DebtReportRequestBean();
        this.setDebtReportRequestBean(bean, model);
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@RequestParam(value="bean", required=false) DebtReportRequestBean bean, Model model) {
        this.setDebtReportRequestBean(bean, model);
        return this.getBeanJson((ITreasuryBean)bean);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) DebtReportRequestBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            DebtReportRequest debtReportRequest = DebtReportRequest.create((DebtReportRequestBean)bean);
            model.addAttribute("debtReportRequest", (Object)debtReportRequest);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    @RequestMapping(value={"/download/{debtReportRequestResultFileId}"}, method={RequestMethod.GET})
    public String download(@PathVariable(value="debtReportRequestResultFileId") DebtReportRequestResultFile resultFile, Model model, HttpServletResponse response) {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-disposition", "attachment; filename=" + resultFile.getFilename());
        response.setContentLength((int)resultFile.getSize());
        try {
            response.getOutputStream().write(resultFile.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @RequestMapping(value={"/downloadErrors/{debtReportRequestResultErrorsFileId}"}, method={RequestMethod.GET})
    public String downloadErrors(@PathVariable(value="debtReportRequestResultErrorsFileId") DebtReportRequestResultErrorsFile resultFile, Model model, HttpServletResponse response) {
        response.setContentType("text/plain");
        response.setHeader("Content-disposition", "attachment; filename=" + resultFile.getFilename());
        try {
            response.getOutputStream().write(resultFile.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private String jspPage(String page) {
        return "/academicTreasury/managedebtreportrequests/debtreportrequest/" + page;
    }
}

