/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.createdebts.massive.tuitions;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFileBean;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.web.servlet.view.RedirectView;

@BennuSpringController(value=CustomerController.class)
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.massivetuitiondebtcreation", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/massivedebtgenerationrequestfile"})
public class MassiveDebtGenerationRequestFileController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/massivedebtgenerationrequestfile";
    private static final String JSP_PATH = "academicTreasury/massivedebtgenerationrequestfile";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/massivedebtgenerationrequestfile/search";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/massivedebtgenerationrequestfile/create";
    private static final String _BACKTOCREATE_URI = "/backtocreate";
    public static final String BACKTOCREATE_URL = "/academictreasury/massivedebtgenerationrequestfile/backtocreate";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/massivedebtgenerationrequestfile/createpostback";
    private static final String _CONFIRMDEBTCREATION_URI = "/confirmdebtcreation";
    public static final String CONFIRMDEBTCREATION_URL = "/academictreasury/massivedebtgenerationrequestfile/confirmdebtcreation";
    private static final String _PROCESSREQUEST_URI = "/processrequest";
    public static final String PROCESSREQUEST_URL = "/academictreasury/massivedebtgenerationrequestfile/processrequest";
    private static final String _DOWNLOAD_URI = "/download";
    public static final String DOWNLOAD_URL = "/academictreasury/massivedebtgenerationrequestfile/download";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/massivedebtgenerationrequestfile/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("requestFiles", MassiveDebtGenerationRequestFile.findAllActive().sorted(MassiveDebtGenerationRequestFile.COMPARE_BY_CREATION_DATE).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        MassiveDebtGenerationRequestFileBean bean = new MassiveDebtGenerationRequestFileBean();
        return this._createFirstPage(bean, model);
    }

    @RequestMapping(value={"/backtocreate"}, method={RequestMethod.POST})
    public String backTocreate(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) MassiveDebtGenerationRequestFileBean bean, Model model) {
        return this._createFirstPage(bean, model);
    }

    public String _createFirstPage(MassiveDebtGenerationRequestFileBean bean, Model model) {
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@RequestParam(value="bean", required=false) MassiveDebtGenerationRequestFileBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) MassiveDebtGenerationRequestFileBean bean, @RequestParam(value="requestFile", required=true) MultipartFile requestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            byte[] content = requestFile.getBytes();
            if (bean.getMassiveDebtGenerationType() == null) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.massiveDebtGenerationType.required", new String[0]);
            }
            bean.getMassiveDebtGenerationType().implementation().readExcel(content, bean);
            MassiveDebtGenerationRequestFile file = MassiveDebtGenerationRequestFile.create(bean, requestFile.getOriginalFilename(), content);
            return this.redirect("/academictreasury/massivedebtgenerationrequestfile/confirmdebtcreation/" + file.getExternalId(), model, redirectAttributes);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(bean, model);
        }
    }

    @RequestMapping(value={"/confirmdebtcreation/{fileId}"}, method={RequestMethod.GET})
    public View confirmdebtcreation(@PathVariable(value="fileId") MassiveDebtGenerationRequestFile massiveDebtGenerationRequestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            model.addAttribute("massiveDebtGenerationRequestFile", (Object)massiveDebtGenerationRequestFile);
            model.addAttribute("rows", massiveDebtGenerationRequestFile.getMassiveDebtGenerationType().implementation().readExcel(massiveDebtGenerationRequestFile.getContent(), new MassiveDebtGenerationRequestFileBean(massiveDebtGenerationRequestFile)));
            model.addAttribute("requestFile", (Object)massiveDebtGenerationRequestFile);
            model.addAttribute("processable", (Object)true);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
        }
        return new JstlView(massiveDebtGenerationRequestFile.getMassiveDebtGenerationType().implementation().viewUrl()){

            protected void exposeHelpers(HttpServletRequest request) throws Exception {
                this.setServletContext(request.getServletContext());
                super.exposeHelpers(request);
            }
        };
    }

    @RequestMapping(value={"/processrequest/{fileId}"}, method={RequestMethod.POST})
    public View processrequest(@PathVariable(value="fileId") MassiveDebtGenerationRequestFile massiveDebtGenerationRequestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            massiveDebtGenerationRequestFile.process();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.MassiveDebtGenerationRequestFile.success", (String[])new String[0]), model);
            this.redirect(SEARCH_URL, model, redirectAttributes);
            if (Strings.isNullOrEmpty((String)this.request.getContextPath())) {
                return new RedirectView(SEARCH_URL);
            }
            return new RedirectView(this.request.getContextPath() + SEARCH_URL);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.confirmdebtcreation(massiveDebtGenerationRequestFile, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/download/{fileId}"}, method={RequestMethod.GET})
    public void download(@PathVariable(value="fileId") MassiveDebtGenerationRequestFile massiveDebtGenerationRequestFile, HttpServletRequest request, HttpServletResponse response, Model model) {
        response.setContentLength(massiveDebtGenerationRequestFile.getContent().length);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-disposition", "attachment; filename=" + massiveDebtGenerationRequestFile.getFilename());
        try {
            response.getOutputStream().write(massiveDebtGenerationRequestFile.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/massivedebtgenerationrequestfile/" + page;
    }
}

