/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.dto.reports.DebtReportEntryBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class SettlementReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.responsible", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteDocumentDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.paymentDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteAnnuled", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.documentExportationPending", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementEntryOrder", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.amount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.productCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementEntryDescription", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryIdentification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryAmountToPay", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.personalEmail", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.closeDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.degreeType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.degreeCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.degreeName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.executionYear", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.documentObservations", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.termsAndConditions", new String[0])};
    private SettlementEntry settlementEntry;
    private SettlementNote settlementNote;
    private boolean completed;
    private String identification;
    private DateTime creationDate;
    private String responsible;
    private String invoiceEntryIdentification;
    private String invoiceEntryType;
    private BigDecimal invoiceEntryAmountToPay;
    private String invoiceDocumentNumber;
    private String settlementNoteNumber;
    private DateTime settlementNoteDocumentDate;
    private DateTime paymentDate;
    private Boolean settlementNoteAnnuled;
    private Boolean documentExportationPending;
    private Integer settlementEntryOrder;
    private BigDecimal amount;
    private String productCode;
    private String settlementEntryDescription;
    private String customerId;
    private String debtAccountId;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String institutionalOrDefaultEmail;
    private String emailForSendingEmails;
    private String personalEmail;
    private String address;
    private Integer studentNumber;
    private Integer registrationNumber;
    private String degreeType;
    private String degreeCode;
    private String degreeName;
    private String executionYear;
    private String executionSemester;
    private DateTime closeDate;
    private Boolean exportedInLegacyERP;
    private LocalDate erpCertificationDate;
    private String erpCertificateDocumentReference;
    private String erpCustomerId;
    private String erpPayorCustomerId;
    private String decimalSeparator;
    private String documentObservations;
    private String documentTermsAndConditions;

    public SettlementReportEntryBean(SettlementEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.decimalSeparator = request != null ? request.getDecimalSeparator() : ".";
        this.settlementEntry = entry;
        this.settlementNote = (SettlementNote)entry.getFinantialDocument();
        try {
            Currency currency = this.settlementNote.getDebtAccount().getFinantialInstitution().getCurrency();
            this.identification = entry.getExternalId();
            this.creationDate = treasuryServices.versioningCreationDate((Object)entry);
            this.responsible = treasuryServices.versioningCreatorUsername((Object)entry);
            this.invoiceEntryIdentification = entry.getInvoiceEntry().getExternalId();
            this.settlementNoteNumber = this.settlementNote.getUiDocumentNumber();
            this.settlementNoteDocumentDate = this.settlementNote.getDocumentDate();
            this.paymentDate = this.settlementNote.getPaymentDate();
            this.settlementNoteAnnuled = this.settlementNote.isAnnulled();
            this.documentExportationPending = this.settlementNote.isDocumentToExport();
            this.invoiceEntryType = this.entryType(entry.getInvoiceEntry());
            this.invoiceEntryAmountToPay = Currency.getValueWithScale((BigDecimal)entry.getInvoiceEntry().getAmountWithVat());
            this.invoiceDocumentNumber = entry.getInvoiceEntry().getFinantialDocument().getUiDocumentNumber();
            this.settlementEntryOrder = entry.getEntryOrder();
            this.settlementNote.getDebtAccount().getFinantialInstitution().getCurrency();
            this.amount = Currency.getValueWithScale((BigDecimal)entry.getTotalAmount());
            this.productCode = entry.getInvoiceEntry().getProduct().getCode();
            this.settlementEntryDescription = entry.getDescription();
            this.documentObservations = this.settlementNote.getDocumentObservations();
            this.documentTermsAndConditions = this.settlementNote.getDocumentTermsAndConditions();
            this.fillStudentInformation(entry);
            this.fillAcademicInformation(entry.getInvoiceEntry());
            this.fillERPInformation(entry);
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillERPInformation(SettlementEntry entry) {
        this.closeDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getCloseDate() : null;
        this.exportedInLegacyERP = entry.getFinantialDocument() != null ? entry.getFinantialDocument().isExportedInLegacyERP() : false;
        this.erpCertificationDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificationDate() : null;
        this.erpCertificateDocumentReference = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificateDocumentReference() : null;
        this.erpCustomerId = entry.getFinantialDocument().getDebtAccount().getCustomer().getErpCustomerId();
        if (entry.getInvoiceEntry().getFinantialDocument() != null && ((Invoice)entry.getInvoiceEntry().getFinantialDocument()).getPayorDebtAccount() != null) {
            this.erpPayorCustomerId = ((Invoice)entry.getInvoiceEntry().getFinantialDocument()).getPayorDebtAccount().getCustomer().getErpCustomerId();
        }
    }

    private void fillAcademicInformation(InvoiceEntry invoiceEntry) {
        DebitEntry debitEntry;
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        DebitEntry debitEntry2 = debitEntry = invoiceEntry.isDebitNoteEntry() ? (DebitEntry)invoiceEntry : ((CreditEntry)invoiceEntry).getDebitEntry();
        if (debitEntry != null) {
            if (debitEntry.getTreasuryEvent() != null && debitEntry.getTreasuryEvent() instanceof AcademicTreasuryEvent) {
                AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)debitEntry.getTreasuryEvent();
                if (academicTreasuryEvent.isForRegistrationTuition()) {
                    this.registrationNumber = academicTreasuryEvent.getRegistration().getNumber();
                    this.degreeType = academicTreasuryServices.localizedNameOfDegreeType(academicTreasuryEvent.getRegistration().getDegree().getDegreeType());
                    this.degreeCode = academicTreasuryEvent.getRegistration().getDegree().getCode();
                    this.degreeName = academicTreasuryEvent.getRegistration().getDegree().getPresentationName();
                    this.executionYear = academicTreasuryEvent.getExecutionYear().getQualifiedName();
                } else if (academicTreasuryEvent.isForStandaloneTuition() || academicTreasuryEvent.isForExtracurricularTuition()) {
                    if (debitEntry.getCurricularCourse() != null) {
                        this.degreeType = academicTreasuryServices.localizedNameOfDegreeType(debitEntry.getCurricularCourse().getDegree().getDegreeType());
                        this.degreeCode = debitEntry.getCurricularCourse().getDegree().getCode();
                        this.degreeName = debitEntry.getCurricularCourse().getDegree().getPresentationName();
                    }
                    if (debitEntry.getExecutionSemester() != null) {
                        this.executionYear = this.academicTreasuryServices().executionYearOfExecutionSemester(debitEntry.getExecutionSemester()).getQualifiedName();
                        this.executionSemester = debitEntry.getExecutionSemester().getQualifiedName();
                    }
                } else if (academicTreasuryEvent.isForImprovementTax()) {
                    if (debitEntry.getCurricularCourse() != null) {
                        this.degreeType = academicTreasuryServices.localizedNameOfDegreeType(debitEntry.getCurricularCourse().getDegree().getDegreeType());
                        this.degreeCode = debitEntry.getCurricularCourse().getDegree().getCode();
                        this.degreeName = debitEntry.getCurricularCourse().getDegree().getPresentationName();
                    }
                    if (debitEntry.getExecutionSemester() != null) {
                        this.executionYear = this.academicTreasuryServices().executionYearOfExecutionSemester(debitEntry.getExecutionSemester()).getQualifiedName();
                        this.executionSemester = debitEntry.getExecutionSemester().getQualifiedName();
                    }
                } else if (academicTreasuryEvent.isForAcademicTax()) {
                    this.registrationNumber = academicTreasuryEvent.getRegistration().getNumber();
                    this.degreeType = academicTreasuryServices.localizedNameOfDegreeType(academicTreasuryEvent.getRegistration().getDegree().getDegreeType());
                    this.degreeCode = academicTreasuryEvent.getRegistration().getDegree().getCode();
                    this.degreeName = academicTreasuryEvent.getRegistration().getDegree().getPresentationName();
                    this.executionYear = academicTreasuryEvent.getExecutionYear().getQualifiedName();
                } else if (academicTreasuryEvent.isForAcademicServiceRequest()) {
                    ITreasuryServiceRequest iTreasuryServiceRequest = academicTreasuryEvent.getITreasuryServiceRequest();
                    this.registrationNumber = iTreasuryServiceRequest.getRegistration().getNumber();
                    this.degreeType = academicTreasuryServices.localizedNameOfDegreeType(iTreasuryServiceRequest.getRegistration().getDegree().getDegreeType());
                    this.degreeCode = iTreasuryServiceRequest.getRegistration().getDegree().getCode();
                    this.degreeName = iTreasuryServiceRequest.getRegistration().getDegree().getPresentationName();
                    if (iTreasuryServiceRequest.hasExecutionYear()) {
                        this.executionYear = iTreasuryServiceRequest.getExecutionYear().getQualifiedName();
                    }
                } else if (academicTreasuryEvent.isForTreasuryEventTarget()) {
                    IAcademicTreasuryTarget treasuryEventTarget = (IAcademicTreasuryTarget)academicTreasuryEvent.getTreasuryEventTarget();
                    if (treasuryEventTarget.getAcademicTreasuryTargetRegistration() != null) {
                        this.registrationNumber = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getNumber();
                        this.degreeType = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getDegree().getDegreeType().getName().getContent();
                        this.degreeCode = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getDegree().getCode();
                        this.degreeName = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getDegree().getPresentationName();
                    }
                    if (treasuryEventTarget.getAcademicTreasuryTargetExecutionYear() != null) {
                        this.executionYear = treasuryEventTarget.getAcademicTreasuryTargetExecutionYear().getQualifiedName();
                    }
                    if (treasuryEventTarget.getAcademicTreasuryTargetExecutionSemester() != null) {
                        this.executionSemester = treasuryEventTarget.getAcademicTreasuryTargetExecutionSemester().getQualifiedName();
                    }
                }
            } else if (debitEntry.getTreasuryEvent() != null) {
                TreasuryEvent treasuryEvent = debitEntry.getTreasuryEvent();
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeCode())) {
                    this.degreeCode = treasuryEvent.getDegreeCode();
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeName())) {
                    this.degreeName = treasuryEvent.getDegreeName();
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getExecutionYearName())) {
                    this.executionYear = treasuryEvent.getExecutionYearName();
                }
            }
            if (Strings.isNullOrEmpty((String)this.degreeCode)) {
                this.degreeCode = debitEntry.getDegreeCode();
            }
            if (Strings.isNullOrEmpty((String)this.executionYear)) {
                this.executionYear = debitEntry.getExecutionYearName();
            }
        }
    }

    private IAcademicTreasuryPlatformDependentServices academicTreasuryServices() {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation();
    }

    private void fillStudentInformation(SettlementEntry entry) {
        Customer customer = entry.getFinantialDocument().getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getFinantialDocument().getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType().getLocalizedName();
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null) {
            Person person = ((PersonCustomer)customer).getAssociatedPerson();
            this.institutionalOrDefaultEmail = person.getInstitutionalOrDefaultEmailAddressValue();
            this.emailForSendingEmails = person.getEmailForSendingEmails();
            this.personalEmail = DebtReportEntryBean.personalEmail(person) != null ? DebtReportEntryBean.personalEmail(person).getValue() : "";
        }
        this.address = customer.getAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getAssociatedPerson().getStudent().getNumber();
        }
    }

    private String entryType(InvoiceEntry entry) {
        if (entry.isDebitNoteEntry()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.debitNoteEntry", new String[0]);
        }
        if (entry.isCreditNoteEntry()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.creditNoteEntry", new String[0]);
        }
        return null;
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            String value;
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.responsible));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteDocumentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.paymentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteAnnuled));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentExportationPending));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementEntryOrder));
            String string = value = this.amount != null ? this.amount.toString() : "";
            if (",".equals(this.decimalSeparator)) {
                value = value.replace(".", ",");
            }
            row.createCell(i++).setCellValue(this.valueOrEmpty(value));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.productCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementEntryDescription));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceEntryIdentification));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceEntryType));
            String string2 = value = this.invoiceEntryAmountToPay != null ? this.invoiceEntryAmountToPay.toString() : "";
            if (",".equals(this.decimalSeparator)) {
                value = value.replace(".", ",");
            }
            row.createCell(i++).setCellValue(this.valueOrEmpty(value));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceDocumentNumber));
            row.createCell(i++).setCellValue(this.customerId);
            row.createCell(i++).setCellValue(this.debtAccountId);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.institutionalOrDefaultEmail));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.personalEmail));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.closeDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeName));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.executionYear));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentObservations));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentTermsAndConditions));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.settlementEntry, e);
        }
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return AcademicTreasuryConstants.academicTreasuryBundle(value != false ? "label.yes" : "label.no", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }

    public SettlementEntry getSettlementEntry() {
        return this.settlementEntry;
    }

    public void setSettlementEntry(SettlementEntry settlementEntry) {
        this.settlementEntry = settlementEntry;
    }

    public SettlementNote getSettlementNote() {
        return this.settlementNote;
    }

    public void setSettlementNote(SettlementNote settlementNote) {
        this.settlementNote = settlementNote;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getInvoiceEntryIdentification() {
        return this.invoiceEntryIdentification;
    }

    public void setInvoiceEntryIdentification(String invoiceEntryIdentification) {
        this.invoiceEntryIdentification = invoiceEntryIdentification;
    }

    public String getInvoiceEntryType() {
        return this.invoiceEntryType;
    }

    public void setInvoiceEntryType(String invoiceEntryType) {
        this.invoiceEntryType = invoiceEntryType;
    }

    public BigDecimal getInvoiceEntryAmountToPay() {
        return this.invoiceEntryAmountToPay;
    }

    public void setInvoiceEntryAmountToPay(BigDecimal invoiceEntryAmountToPay) {
        this.invoiceEntryAmountToPay = invoiceEntryAmountToPay;
    }

    public String getInvoiceDocumentNumber() {
        return this.invoiceDocumentNumber;
    }

    public void setInvoiceDocumentNumber(String invoiceDocumentNumber) {
        this.invoiceDocumentNumber = invoiceDocumentNumber;
    }

    public String getSettlementNoteNumber() {
        return this.settlementNoteNumber;
    }

    public void setSettlementNoteNumber(String settlementNoteNumber) {
        this.settlementNoteNumber = settlementNoteNumber;
    }

    public DateTime getSettlementNoteDocumentDate() {
        return this.settlementNoteDocumentDate;
    }

    public void setSettlementNoteDocumentDate(DateTime settlementNoteDocumentDate) {
        this.settlementNoteDocumentDate = settlementNoteDocumentDate;
    }

    public DateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(DateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public boolean getSettlementNoteAnnuled() {
        return this.settlementNoteAnnuled;
    }

    public void setSettlementNoteAnnuled(Boolean settlementNoteAnnuled) {
        this.settlementNoteAnnuled = settlementNoteAnnuled;
    }

    public boolean getDocumentExportationPending() {
        return this.documentExportationPending;
    }

    public void setDocumentExportationPending(Boolean documentExportationPending) {
        this.documentExportationPending = documentExportationPending;
    }

    public Integer getSettlementEntryOrder() {
        return this.settlementEntryOrder;
    }

    public void setSettlementEntryOrder(Integer settlementEntryOrder) {
        this.settlementEntryOrder = settlementEntryOrder;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getSettlementEntryDescription() {
        return this.settlementEntryDescription;
    }

    public void setSettlementEntryDescription(String settlementEntryDescription) {
        this.settlementEntryDescription = settlementEntryDescription;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getDebtAccountId() {
        return this.debtAccountId;
    }

    public void setDebtAccountId(String debtAccountId) {
        this.debtAccountId = debtAccountId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getInstitutionalOrDefaultEmail() {
        return this.institutionalOrDefaultEmail;
    }

    public void setInstitutionalOrDefaultEmailEmail(String institutionalOrDefaultEmail) {
        this.institutionalOrDefaultEmail = institutionalOrDefaultEmail;
    }

    public String getEmailForSendingEmails() {
        return this.emailForSendingEmails;
    }

    public void setEmailForSendingEmails(String emailForSendingEmails) {
        this.emailForSendingEmails = emailForSendingEmails;
    }

    public String getPersonalEmail() {
        return this.personalEmail;
    }

    public void setPersonalEmail(String personalEmail) {
        this.personalEmail = personalEmail;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public Integer getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(Integer registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public String getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(String degreeType) {
        this.degreeType = degreeType;
    }

    public String getDegreeCode() {
        return this.degreeCode;
    }

    public void setDegreeCode(String degreeCode) {
        this.degreeCode = degreeCode;
    }

    public String getDegreeName() {
        return this.degreeName;
    }

    public void setDegreeName(String degreeName) {
        this.degreeName = degreeName;
    }

    public String getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(String executionYear) {
        this.executionYear = executionYear;
    }

    public String getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(String executionSemester) {
        this.executionSemester = executionSemester;
    }

    public DateTime getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(DateTime closeDate) {
        this.closeDate = closeDate;
    }

    public Boolean getExportedInLegacyERP() {
        return this.exportedInLegacyERP;
    }

    public void setExportedInLegacyERP(Boolean exportedInLegacyERP) {
        this.exportedInLegacyERP = exportedInLegacyERP;
    }

    public LocalDate getErpCertificationDate() {
        return this.erpCertificationDate;
    }

    public void setErpCertificationDate(LocalDate erpCertificationDate) {
        this.erpCertificationDate = erpCertificationDate;
    }

    public String getErpCertificateDocumentReference() {
        return this.erpCertificateDocumentReference;
    }

    public void setErpCertificateDocumentReference(String erpCertificateDocumentReference) {
        this.erpCertificateDocumentReference = erpCertificateDocumentReference;
    }

    public String getErpCustomerId() {
        return this.erpCustomerId;
    }

    public void setErpCustomerId(String erpCustomerId) {
        this.erpCustomerId = erpCustomerId;
    }

    public String getErpPayorCustomerId() {
        return this.erpPayorCustomerId;
    }

    public void setErpPayorCustomerId(String erpPayorCustomerId) {
        this.erpPayorCustomerId = erpPayorCustomerId;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public String getDocumentObservations() {
        return this.documentObservations;
    }

    public void setDocumentObservations(String documentObservations) {
        this.documentObservations = documentObservations;
    }

    public String getDocumentTermsAndConditions() {
        return this.documentTermsAndConditions;
    }

    public void setDocumentTermsAndConditions(String documentTermsAndConditions) {
        this.documentTermsAndConditions = documentTermsAndConditions;
    }
}

