/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationRegimeTypeConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class RegistrationRegimeTypeConditionRule
extends RegistrationRegimeTypeConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof RegistrationRegimeTypeConditionRule)) {
            return false;
        }
        RegistrationRegimeTypeConditionRule rule = (RegistrationRegimeTypeConditionRule)((Object)tuitionConditionRule);
        return this.getRegistrationRegimeTypes().containsAll(rule.getRegistrationRegimeTypes());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        RegistrationRegimeType registrationRegimeType = academicTreasuryServices.registrationRegimeType(registration, executionYear);
        return this.getRegistrationRegimeTypes().contains(registrationRegimeType);
    }

    public Set<RegistrationRegimeType> getRegistrationRegimeTypes() {
        RegimeHashSet result = new RegimeHashSet(this);
        this.getRegimeTypesConverted().forEach(r -> result.add(r));
        return result;
    }

    private Set<RegistrationRegimeType> getRegimeTypesConverted() {
        String[] types;
        HashSet<RegistrationRegimeType> result = new HashSet<RegistrationRegimeType>();
        if (this.getRegistrationRegimeTypesSerialized() == null) {
            return result;
        }
        for (String type : types = this.getRegistrationRegimeTypesSerialized().split(",")) {
            try {
                result.add(RegistrationRegimeType.valueOf((String)type));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return result;
    }

    public void addRegistrationRegimeTypes(RegistrationRegimeType type) {
        Set<RegistrationRegimeType> registrationRegimeTypes = this.getRegimeTypesConverted();
        registrationRegimeTypes.add(type);
        this.setRegistrationRegimeTypesSerialized(registrationRegimeTypes.stream().map(t -> t.name()).collect(Collectors.joining(",")));
    }

    public void removeRegistrationRegimeTypes(RegistrationRegimeType type) {
        Set<RegistrationRegimeType> registrationRegimeTypes = this.getRegimeTypesConverted();
        registrationRegimeTypes.remove(type);
        this.setRegistrationRegimeTypesSerialized(registrationRegimeTypes.stream().map(t -> t.name()).collect(Collectors.joining(",")));
    }

    public boolean checkRules() {
        if (this.getRegistrationRegimeTypesSerialized() == null || this.getRegistrationRegimeTypesSerialized().isEmpty()) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationRegimeTypeConditionRule.RegistrationRegimeTypes.cannotBeEmpty", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        return this.getRegistrationRegimeTypes().stream().map(c -> c.getLocalizedName()).collect(Collectors.joining(", "));
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.setTuitionPaymentPlan(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        RegistrationRegimeTypeConditionRule result = new RegistrationRegimeTypeConditionRule();
        this.getRegistrationRegimeTypes().forEach(c -> result.addRegistrationRegimeTypes((RegistrationRegimeType)c));
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        for (String s : split = string.split("\\|")) {
            RegistrationRegimeType value = Arrays.asList(RegistrationRegimeType.values()).stream().filter(r -> r.getLocalizedName().equals(s)).findFirst().orElse(null);
            if (value == null) {
                throw new AcademicTreasuryDomainException("error.RegistrationRegimeTypeConditionRule.registrationRegime.invalid", s);
            }
            this.addRegistrationRegimeTypes(value);
        }
    }

    private static class RegimeHashSet
    extends HashSet<RegistrationRegimeType> {
        private RegistrationRegimeTypeConditionRule rule;

        public RegimeHashSet(RegistrationRegimeTypeConditionRule registrationRegimeTypeConditionRule) {
            this.rule = registrationRegimeTypeConditionRule;
        }

        @Override
        public boolean addAll(Collection<? extends RegistrationRegimeType> c) {
            for (RegistrationRegimeType registrationRegimeType : c) {
                this.rule.addRegistrationRegimeTypes(registrationRegimeType);
            }
            return super.addAll(c);
        }
    }
}

