/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.IngressionTypeConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class IngressionTypeConditionRule
extends IngressionTypeConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof IngressionTypeConditionRule)) {
            return false;
        }
        IngressionTypeConditionRule rule = (IngressionTypeConditionRule)((Object)tuitionConditionRule);
        return this.getIngressionSet().containsAll(rule.getIngressionSet());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        IngressionType ingression = academicTreasuryServices.ingression(registration);
        return this.getIngressionSet().contains(ingression);
    }

    public boolean checkRules() {
        if (this.getIngressionSet() == null || this.getIngressionSet().isEmpty()) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.IngressionTypeConditionRule.ingressionSet.cannotBeEmpty", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        return this.getIngressionSet().stream().sorted((o1, o2) -> o1.getCode().compareTo(o2.getCode())).map(c -> c.getLocalizedName()).collect(Collectors.joining(", "));
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.getIngressionSet().clear();
        this.setTuitionPaymentPlan(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        IngressionTypeConditionRule result = new IngressionTypeConditionRule();
        this.getIngressionSet().forEach(c -> result.addIngression((IngressionType)c));
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        for (String s : split = string.split("\\|")) {
            IngressionType value = IngressionType.findAllByPredicate(i -> i.getLocalizedName().equals(s)).findFirst().orElse(null);
            if (value == null) {
                throw new AcademicTreasuryDomainException("error.IngressionTypeConditionRule.ingressionType.invalid", s);
            }
            this.addIngression(value);
        }
    }
}

