/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebitEntryBean;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;

public class DiscountTuitionInstallmentsHelper {
    private DebtAccount debtAccount;
    private AcademicTreasuryEvent tuitionAcademicTreasuryEvent;
    private Set<Product> restrictCreationToInstallments;
    private LocalDate when;
    private Registration registration;
    private TuitionPaymentPlan tuitionPaymentPlan;
    private LocalDate debtDate;
    private BigDecimal enrolledEctsUnits;
    private BigDecimal enrolledCoursesCount;
    private Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap;
    private Person person;
    private ExecutionYear executionYear;
    private TreeMap<TreasuryEvent, BigDecimal> discountMap;

    public DiscountTuitionInstallmentsHelper(DebtAccount debtAccount, AcademicTreasuryEvent tuitionAcademicTreasuryEvent, Set<Product> restrictCreationToInstallments, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        this.debtAccount = debtAccount;
        this.tuitionAcademicTreasuryEvent = tuitionAcademicTreasuryEvent;
        this.restrictCreationToInstallments = restrictCreationToInstallments;
        this.when = when;
        this.calculatorsMap = calculatorsMap;
        this.person = tuitionAcademicTreasuryEvent.getPerson();
        this.executionYear = tuitionAcademicTreasuryEvent.getExecutionYear();
        this.discountMap = this.buildDiscountMap();
    }

    public DiscountTuitionInstallmentsHelper(Registration registration, TuitionPaymentPlan tuitionPaymentPlan, LocalDate debtDate, BigDecimal enrolledEctsUnits, BigDecimal enrolledCoursesCount, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        this.registration = registration;
        this.tuitionPaymentPlan = tuitionPaymentPlan;
        this.debtDate = debtDate;
        this.enrolledEctsUnits = enrolledEctsUnits;
        this.enrolledCoursesCount = enrolledCoursesCount;
        this.calculatorsMap = calculatorsMap;
        this.person = registration.getPerson();
        this.executionYear = tuitionPaymentPlan.getExecutionYear();
        this.discountMap = this.buildDiscountMap();
    }

    public boolean createInstallmentAndDiscountInstallment(TuitionInstallmentTariff tariff) {
        boolean allowToCreateTheInstallment;
        BigDecimal tuitionInstallmentAmountToPay = tariff.amountToPay(this.tuitionAcademicTreasuryEvent, this.calculatorsMap);
        BigDecimal amountToSubtractFromAmountToPay = BigDecimal.ZERO;
        HashMap<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = new HashMap<TreasuryExemptionType, BigDecimal>();
        BigDecimal availableAmountToPay = tuitionInstallmentAmountToPay;
        for (TreasuryEvent treasuryEvent : this.discountMap.navigableKeySet()) {
            if (!TreasuryConstants.isPositive((BigDecimal)this.discountMap.get(treasuryEvent))) continue;
            BigDecimal availableAmountToDiscount = this.discountMap.get(treasuryEvent);
            BigDecimal amountToDiscount = availableAmountToDiscount.min(availableAmountToPay);
            availableAmountToPay = availableAmountToPay.subtract(amountToDiscount);
            this.discountMap.put(treasuryEvent, availableAmountToDiscount.subtract(amountToDiscount));
            if (treasuryEvent.isEventDiscountInTuitionFeeWithTreasuryExemption()) {
                TreasuryExemptionType treasuryExemption = treasuryEvent.getTreasuryExemptionToApplyInEventDiscountInTuitionFee();
                if (!exemptionsToApplyMap.containsKey(treasuryExemption)) {
                    exemptionsToApplyMap.put(treasuryExemption, BigDecimal.ZERO);
                }
                exemptionsToApplyMap.put(treasuryExemption, ((BigDecimal)exemptionsToApplyMap.get(treasuryExemption)).add(amountToDiscount));
            } else {
                amountToSubtractFromAmountToPay = amountToSubtractFromAmountToPay.add(amountToDiscount);
            }
            if (TreasuryConstants.isPositive((BigDecimal)availableAmountToPay)) continue;
            break;
        }
        if (!TreasuryConstants.isPositive((BigDecimal)tuitionInstallmentAmountToPay.subtract(amountToSubtractFromAmountToPay))) {
            return false;
        }
        boolean bl = allowToCreateTheInstallment = this.restrictCreationToInstallments == null || this.restrictCreationToInstallments.contains(tariff.getProduct());
        if (allowToCreateTheInstallment && !this.tuitionAcademicTreasuryEvent.isChargedWithDebitEntry(tariff)) {
            DebitEntry installmentDebitEntry = tariff.createDebitEntryForRegistration(this.debtAccount, this.tuitionAcademicTreasuryEvent, this.when, this.calculatorsMap, amountToSubtractFromAmountToPay);
            for (Map.Entry entry : exemptionsToApplyMap.entrySet()) {
                TreasuryExemptionType treasuryExemptionType = (TreasuryExemptionType)entry.getKey();
                BigDecimal amountToExempt = (BigDecimal)entry.getValue();
                String reason = treasuryExemptionType.getName().getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
                TreasuryExemption.create((TreasuryExemptionType)treasuryExemptionType, (TreasuryEvent)this.tuitionAcademicTreasuryEvent, (String)reason, (BigDecimal)amountToExempt, (DebitEntry)installmentDebitEntry);
            }
            return true;
        }
        return false;
    }

    public TuitionDebitEntryBean buildInstallmentDebitEntryBeanWithDiscount(TuitionInstallmentTariff tuitionInstallmentTariff) {
        BigDecimal finalAmountToPay;
        int installmentOrder = tuitionInstallmentTariff.getInstallmentOrder();
        LocalizedString installmentName = this.tuitionPaymentPlan.installmentName(this.registration, tuitionInstallmentTariff);
        LocalDate dueDate = tuitionInstallmentTariff.dueDate(this.debtDate);
        Vat vat = tuitionInstallmentTariff.vat(this.debtDate);
        BigDecimal tuitionInstallmentAmountToPay = tuitionInstallmentTariff.amountToPay(this.registration, this.enrolledEctsUnits, this.enrolledCoursesCount, this.calculatorsMap);
        Currency currency = tuitionInstallmentTariff.getFinantialEntity().getFinantialInstitution().getCurrency();
        BigDecimal amountToSubtractFromAmountToPay = BigDecimal.ZERO;
        HashMap<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = new HashMap<TreasuryExemptionType, BigDecimal>();
        BigDecimal availableAmountToPay = tuitionInstallmentAmountToPay;
        for (TreasuryEvent treasuryEvent : this.discountMap.navigableKeySet()) {
            if (!TreasuryConstants.isPositive((BigDecimal)this.discountMap.get(treasuryEvent))) continue;
            BigDecimal availableAmountToDiscount = this.discountMap.get(treasuryEvent);
            BigDecimal amountToDiscount = availableAmountToDiscount.min(availableAmountToPay);
            availableAmountToPay = availableAmountToPay.subtract(amountToDiscount);
            this.discountMap.put(treasuryEvent, availableAmountToDiscount.subtract(amountToDiscount));
            if (treasuryEvent.isEventDiscountInTuitionFeeWithTreasuryExemption()) {
                TreasuryExemptionType treasuryExemption = treasuryEvent.getTreasuryExemptionToApplyInEventDiscountInTuitionFee();
                if (!exemptionsToApplyMap.containsKey(treasuryExemption)) {
                    exemptionsToApplyMap.put(treasuryExemption, BigDecimal.ZERO);
                }
                exemptionsToApplyMap.put(treasuryExemption, ((BigDecimal)exemptionsToApplyMap.get(treasuryExemption)).add(amountToDiscount));
            } else {
                amountToSubtractFromAmountToPay = amountToSubtractFromAmountToPay.add(amountToDiscount);
            }
            if (TreasuryConstants.isPositive((BigDecimal)availableAmountToPay)) continue;
            break;
        }
        if (!TreasuryConstants.isPositive((BigDecimal)(finalAmountToPay = tuitionInstallmentAmountToPay.subtract(amountToSubtractFromAmountToPay)))) {
            return null;
        }
        BigDecimal totalAmountToExempt = exemptionsToApplyMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        finalAmountToPay = finalAmountToPay.subtract(totalAmountToExempt);
        if (TreasuryConstants.isPositive((BigDecimal)totalAmountToExempt)) {
            return new TuitionDebitEntryBean(installmentOrder, installmentName, dueDate, vat.getTaxRate(), finalAmountToPay, totalAmountToExempt, currency);
        }
        return new TuitionDebitEntryBean(installmentOrder, installmentName, dueDate, vat.getTaxRate(), finalAmountToPay, currency);
    }

    private TreeMap<TreasuryEvent, BigDecimal> buildDiscountMap() {
        Comparator TREASURY_EVENT_COMPARATOR = (o1, o2) -> {
            if (!o1.isEventDiscountInTuitionFeeWithTreasuryExemption() && o2.isEventDiscountInTuitionFeeWithTreasuryExemption()) {
                return -1;
            }
            if (o1.isEventDiscountInTuitionFeeWithTreasuryExemption() && !o2.isEventDiscountInTuitionFeeWithTreasuryExemption()) {
                return 1;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
        TreeMap<TreasuryEvent, BigDecimal> result = new TreeMap<TreasuryEvent, BigDecimal>(TREASURY_EVENT_COMPARATOR);
        DiscountTuitionInstallmentsHelper.getOtherEventsToDiscountInTuitionFee(this.person, this.executionYear).forEach(ev -> result.put((TreasuryEvent)ev, ev.getAmountToPay()));
        return result;
    }

    private static List<TreasuryEvent> getOtherEventsToDiscountInTuitionFee(Person person, ExecutionYear executionYear) {
        return TreasuryBridgeAPIFactory.implementation().getAllAcademicTreasuryEventsList(person).stream().map(TreasuryEvent.class::cast).filter(t -> t.isEventDiscountInTuitionFee()).filter(t -> executionYear.getQualifiedName().equals(t.getExecutionYearName())).collect(Collectors.toList());
    }
}

