/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reservationtax;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTax;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxTariff_Base;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class ReservationTaxTariff
extends ReservationTaxTariff_Base {
    public ReservationTaxTariff() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ReservationTaxTariff(ReservationTax reservationTax, ExecutionInterval executionInterval, BigDecimal baseAmount, DueDateCalculationType dueDateCalculationType, int numberOfDaysAfterCreationForDueDate, LocalDate fixedDueDate, boolean applyInterests, InterestType interestType, BigDecimal interestFixedAmount) {
        this();
        super.setReservationTax(reservationTax);
        super.setExecutionInterval(executionInterval);
        super.setBaseAmount(baseAmount);
        super.setDueDateCalculationType(dueDateCalculationType);
        super.setNumberOfDaysAfterCreationForDueDate(numberOfDaysAfterCreationForDueDate);
        super.setFixedDueDate(fixedDueDate);
        super.setApplyInterests(Boolean.valueOf(applyInterests));
        super.setInterestType(interestType);
        super.setInterestFixedAmount(interestFixedAmount);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(BigDecimal baseAmount, DueDateCalculationType dueDateCalculationType, int numberOfDaysAfterCreationForDueDate, LocalDate fixedDueDate, boolean applyInterests, InterestType interestType, BigDecimal interestFixedAmount) {
        super.setBaseAmount(baseAmount);
        super.setDueDateCalculationType(dueDateCalculationType);
        super.setNumberOfDaysAfterCreationForDueDate(numberOfDaysAfterCreationForDueDate);
        super.setFixedDueDate(fixedDueDate);
        super.setApplyInterests(Boolean.valueOf(applyInterests));
        super.setInterestType(interestType);
        super.setInterestFixedAmount(interestFixedAmount);
        this.checkRules();
    }

    public void addDegrees(Set<Degree> degrees) {
        super.getDegreesSet().addAll(degrees);
    }

    public void removeDegrees(Set<Degree> degrees) {
        super.getDegreesSet().removeAll(degrees);
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setReservationTax(null);
        super.setExecutionInterval(null);
        this.getDegreesSet().clear();
        super.deleteDomainObject();
    }

    public LocalDate calculateDueDate(LocalDate requestDate) {
        return Tariff.calculateDueDate((LocalDate)requestDate, (DueDateCalculationType)this.getDueDateCalculationType(), (int)this.getNumberOfDaysAfterCreationForDueDate(), (LocalDate)this.getFixedDueDate());
    }

    public static ReservationTaxTariff create(ReservationTax reservationTax, ExecutionInterval executionInterval, BigDecimal baseAmount, DueDateCalculationType dueDateCalculationType, int numberOfDaysAfterCreationForDueDate, LocalDate fixedDueDate, boolean applyInterests, InterestType interestType, BigDecimal interestFixedAmount) {
        return new ReservationTaxTariff(reservationTax, executionInterval, baseAmount, dueDateCalculationType, numberOfDaysAfterCreationForDueDate, fixedDueDate, applyInterests, interestType, interestFixedAmount);
    }

    public static Stream<ReservationTaxTariff> findAll() {
        return FenixFramework.getDomainRoot().getReservationTaxTariffsSet().stream();
    }

    public static Stream<ReservationTaxTariff> find(ReservationTax reservationTax) {
        return reservationTax.getReservationTaxTariffsSet().stream();
    }

    public static Stream<ReservationTaxTariff> find(ReservationTax reservationTax, Degree degree, ExecutionInterval executionInterval) {
        return ReservationTaxTariff.find(reservationTax).filter(t -> t.getDegreesSet().contains(degree) && t.getExecutionInterval() == executionInterval);
    }

    public static Optional<ReservationTaxTariff> findUniqueTariff(ReservationTax reservationTax, Degree degree, ExecutionInterval executionInterval) {
        return ReservationTaxTariff.find(reservationTax, degree, executionInterval).findFirst();
    }
}

