/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reservationtax;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academictreasury.domain.academictreasurytarget.AcademicTreasuryTargetCreateDebtBuilder;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTax;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxEventTarget_Base;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxTariff;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class ReservationTaxEventTarget
extends ReservationTaxEventTarget_Base
implements IAcademicTreasuryTarget {
    private static final Map<String, BiConsumer<ReservationTaxEventTarget, IAcademicTreasuryEvent>> HANDLE_TOTAL_PAYMENT = Collections.synchronizedMap(new LinkedHashMap());

    public static void registerHandleTotalPaymentHandler(String key, BiConsumer<ReservationTaxEventTarget, IAcademicTreasuryEvent> consumer) {
        HANDLE_TOTAL_PAYMENT.put(key, consumer);
    }

    public ReservationTaxEventTarget() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ReservationTaxEventTarget(ReservationTax reservationTax, Person person, DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval, boolean discountInTuitionFee, LocalDate taxReservationDate, LocalizedString taxReservationDescription) {
        this();
        super.setReservationTax(reservationTax);
        super.setPerson(person);
        super.setDegreeCurricularPlan(degreeCurricularPlan);
        super.setExecutionInterval(executionInterval);
        super.setTaxReservationDate(taxReservationDate);
        super.setTaxReservationDescription(taxReservationDescription);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.domainRoot.required", new String[0]);
        }
        if (this.getReservationTax() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.reservationTax.required", new String[0]);
        }
        if (this.getPerson() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.person.required", new String[0]);
        }
        if (this.getDegreeCurricularPlan() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.degreeCurricularPlan.required", new String[0]);
        }
        if (this.getExecutionInterval() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.executionInterval.required", new String[0]);
        }
        if (this.getTaxReservationDate() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.taxReservationDate.required", new String[0]);
        }
        if (this.getTaxReservationDescription() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.taxReservationDescription.required", new String[0]);
        }
    }

    public void annulDebts(String reason) {
        ITreasuryBridgeAPI api = TreasuryBridgeAPIFactory.implementation();
        IAcademicTreasuryEvent academicTreasuryEvent = api.getAcademicTreasuryEventForTarget((IAcademicTreasuryTarget)this);
        if (academicTreasuryEvent != null) {
            academicTreasuryEvent.annulDebts(reason);
        }
    }

    public static ReservationTaxEventTarget createReservationTaxDebt(ReservationTax reservationTax, Person person, DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval, LocalDate taxReservationDate) {
        return ReservationTaxEventTarget.createReservationTaxDebt(reservationTax, person, degreeCurricularPlan, executionInterval, taxReservationDate, null);
    }

    public static ReservationTaxEventTarget createReservationTaxDebt(ReservationTax reservationTax, Person person, DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval, LocalDate taxReservationDate, LocalizedString additionalDescription) {
        AcademicTreasuryEvent treasuryEvent;
        Optional<ReservationTaxEventTarget> target;
        LocalizedString emolumentDescription = reservationTax.buildEmolumentDescription(degreeCurricularPlan, executionInterval);
        if (additionalDescription != null) {
            for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
                emolumentDescription = emolumentDescription.with(locale, emolumentDescription.getContent(locale) + additionalDescription.getContent(locale));
            }
        }
        if (!(target = ReservationTaxEventTarget.findUnique(person, reservationTax, degreeCurricularPlan, executionInterval)).isPresent()) {
            target = Optional.of(new ReservationTaxEventTarget(reservationTax, person, degreeCurricularPlan, executionInterval, Boolean.TRUE.equals(reservationTax.getDiscountInTuitionFee()), taxReservationDate, emolumentDescription));
        }
        if ((treasuryEvent = (AcademicTreasuryEvent)target.get().getReservationTaxAcademicTreasuryEvent()) != null && treasuryEvent.isCharged()) {
            return target.get();
        }
        Optional<ReservationTaxTariff> tariff = ReservationTaxTariff.findUniqueTariff(reservationTax, degreeCurricularPlan.getDegree(), executionInterval);
        if (!tariff.isPresent()) {
            throw new AcademicTreasuryDomainException("error.ReservationTaxEventTarget.createReservationTaxDebt.tariff.not.found", new String[]{reservationTax.getName().getContent(), degreeCurricularPlan.getDegree().getPresentationName(), executionInterval.getQualifiedName()});
        }
        BigDecimal amount = tariff.get().getBaseAmount();
        LocalDate dueDate = tariff.get().calculateDueDate(taxReservationDate);
        FinantialEntity finantialEntity = reservationTax.getFinantialEntity();
        Product product = reservationTax.getProduct();
        AcademicTreasuryTargetCreateDebtBuilder.DebtBuilderWithAmountAndDueDate debtBuilder = AcademicTreasuryTargetCreateDebtBuilder.createBuilder().explicitAmountAndDueDate(finantialEntity, product, target.get(), taxReservationDate).setAmount(amount).setDueDate(dueDate).setCreatePaymentCode(Boolean.TRUE.equals(reservationTax.getCreatePaymentReferenceCode())).setInterestType(tariff.get().getInterestType()).setInterestFixedAmount(tariff.get().getInterestFixedAmount()).setPaymentCodePool((ISibsPaymentCodePoolService)finantialEntity.getFinantialInstitution().getDefaultDigitalPaymentPlatform());
        debtBuilder.createDebt();
        return target.get();
    }

    public Degree getAcademicTreasuryTargetDegree() {
        return this.getDegreeCurricularPlan().getDegree();
    }

    public LocalizedString getAcademicTreasuryTargetDescription() {
        return super.getTaxReservationDescription();
    }

    public LocalDate getAcademicTreasuryTargetEventDate() {
        return super.getTaxReservationDate();
    }

    public ExecutionInterval getAcademicTreasuryTargetExecutionSemester() {
        return null;
    }

    public ExecutionYear getAcademicTreasuryTargetExecutionYear() {
        if (this.getExecutionInterval() instanceof ExecutionYear) {
            return (ExecutionYear)this.getExecutionInterval();
        }
        return super.getExecutionInterval().getExecutionYear();
    }

    public Person getAcademicTreasuryTargetPerson() {
        return super.getPerson();
    }

    public Map<String, String> getAcademicTreasuryTargetPropertiesMap() {
        return new HashMap<String, String>();
    }

    public Registration getAcademicTreasuryTargetRegistration() {
        return null;
    }

    public void handleTotalPayment(IAcademicTreasuryEvent event) {
        HANDLE_TOTAL_PAYMENT.forEach((key, consumer) -> consumer.accept(this, event));
    }

    public boolean isEventDiscountInTuitionFee() {
        return Boolean.TRUE.equals(this.getReservationTax().getDiscountInTuitionFee());
    }

    public boolean isEventDiscountInTuitionFeeWithTreasuryExemption() {
        return this.getReservationTax().getTreasuryExemptionType() != null;
    }

    public IAcademicTreasuryEvent getReservationTaxAcademicTreasuryEvent() {
        ITreasuryBridgeAPI api = TreasuryBridgeAPIFactory.implementation();
        return api.getAcademicTreasuryEventForTarget((IAcademicTreasuryTarget)this);
    }

    public BigDecimal getAmountToPay() {
        IAcademicTreasuryEvent academicTreasuryEvent = this.getReservationTaxAcademicTreasuryEvent();
        if (academicTreasuryEvent != null) {
            return academicTreasuryEvent.getAmountToPay();
        }
        return BigDecimal.ZERO;
    }

    public static Stream<ReservationTaxEventTarget> findAll() {
        return FenixFramework.getDomainRoot().getReservationTaxEventTargetsSet().stream();
    }

    public static Stream<ReservationTaxEventTarget> find(Person person, ReservationTax reservationTax, DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval) {
        return ReservationTaxEventTarget.findAll().filter(t -> t.getPerson() == person).filter(r -> r.getReservationTax() == reservationTax).filter(r -> r.getDegreeCurricularPlan() == degreeCurricularPlan).filter(r -> r.getExecutionInterval() == executionInterval);
    }

    private static Optional<ReservationTaxEventTarget> findUnique(Person person, ReservationTax reservationTax, DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval) {
        return ReservationTaxEventTarget.find(person, reservationTax, degreeCurricularPlan, executionInterval).findFirst();
    }
}

