/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reservationtax;

import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTax_Base;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.fenixframework.FenixFramework;

public class ReservationTax
extends ReservationTax_Base {
    public ReservationTax() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ReservationTax(String code, LocalizedString name, FinantialEntity finantialEntity, Product product, boolean discountInTuitionFee, boolean active, boolean createPaymentReferenceCode, LocalizedString taxReservationDescription, TreasuryExemptionType treasuryExemptionType) {
        this();
        super.setCode(code);
        super.setName(name);
        super.setFinantialEntity(finantialEntity);
        super.setProduct(product);
        super.setDiscountInTuitionFee(Boolean.valueOf(discountInTuitionFee));
        super.setActive(Boolean.valueOf(active));
        super.setCreatePaymentReferenceCode(Boolean.valueOf(createPaymentReferenceCode));
        super.setTaxReservationDescription(taxReservationDescription);
        super.setTreasuryExemptionType(treasuryExemptionType);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.domainRoot.required", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.finantialEntity.required", new String[0]);
        }
        if (this.getCode() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.code.required", new String[0]);
        }
        if (this.getName() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.name.required", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.product.required", new String[0]);
        }
        if (this.getDiscountInTuitionFee() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.discountInTuitionFee.required", new String[0]);
        }
        if (this.getActive() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.active.required", new String[0]);
        }
        if (this.getCreatePaymentReferenceCode() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.active.required", new String[0]);
        }
        if (this.getTaxReservationDescription() == null) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.taxReservationDescription.required", new String[0]);
        }
    }

    public void edit(String code, LocalizedString name, FinantialEntity finantialEntity, Product product, boolean discountInTuitionFee, boolean active, boolean createPaymentReferenceCode, LocalizedString taxReservationDescription, TreasuryExemptionType treasuryExemptionType) {
        super.setCode(code);
        super.setName(name);
        if (this.getReservationTaxEventTargetsSet().isEmpty()) {
            super.setFinantialEntity(finantialEntity);
            super.setProduct(product);
            super.setDiscountInTuitionFee(Boolean.valueOf(discountInTuitionFee));
            super.setTreasuryExemptionType(treasuryExemptionType);
        }
        super.setActive(Boolean.valueOf(active));
        super.setCreatePaymentReferenceCode(Boolean.valueOf(createPaymentReferenceCode));
        super.setTaxReservationDescription(taxReservationDescription);
        this.checkRules();
    }

    public LocalizedString buildEmolumentDescription(DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("executionInterval", executionInterval.getQualifiedName());
            valueMap.put("productName", this.getProduct().getName().getContent(locale));
            valueMap.put("degreeCurricularPlanName", degreeCurricularPlan.getPresentationName(executionInterval.getExecutionYear(), locale));
            valueMap.put("degreeName", degreeCurricularPlan.getDegree().getPresentationName(executionInterval.getExecutionYear(), locale));
            result = result.with(locale, StrSubstitutor.replace((Object)this.getTaxReservationDescription().getContent(locale), valueMap));
        }
        return result;
    }

    public void delete() {
        if (!this.getReservationTaxEventTargetsSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.delete.not.possible.due.to.existing.eventTargets", new String[0]);
        }
        if (!this.getReservationTaxTariffsSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ReservationTax.delete.not.possible.due.to.existing.tariffs", new String[0]);
        }
        super.setDomainRoot(null);
        super.setFinantialEntity(null);
        super.setProduct(null);
        super.setTreasuryExemptionType(null);
        super.deleteDomainObject();
    }

    public static Stream<ReservationTax> findAll() {
        return FenixFramework.getDomainRoot().getReservationTaxesSet().stream();
    }

    public static ReservationTax create(String code, LocalizedString name, FinantialEntity finantialEntity, Product product, boolean discountInTuitionFee, boolean active, boolean createPaymentReferenceCode, LocalizedString taxReservationDescription, TreasuryExemptionType treasuryExemptionType) {
        return new ReservationTax(code, name, finantialEntity, product, discountInTuitionFee, active, createPaymentReferenceCode, taxReservationDescription, treasuryExemptionType);
    }

    public static Stream<ReservationTax> findActiveByProduct(Product product) {
        return product.getReservationTaxesSet().stream().filter(r -> Boolean.TRUE.equals(r.getActive()));
    }

    public static Optional<ReservationTax> findUniqueActiveByProduct(Product product) {
        return ReservationTax.findActiveByProduct(product).findFirst();
    }
}

