/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.event;

import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.event.LegacyAcademicTreasuryEvent_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.treasury.domain.Product;
import org.joda.time.LocalDate;

public class LegacyAcademicTreasuryEvent
extends LegacyAcademicTreasuryEvent_Base {
    protected LegacyAcademicTreasuryEvent(Person person, Product product, Degree degree, ExecutionYear executionYear) {
        this.setPerson(person);
        this.setProduct(product);
        this.setExecutionYear(executionYear);
        this.setDegree(degree);
        this.checkRules();
    }

    public static LegacyAcademicTreasuryEvent create(Person person, Product product, Degree degree, ExecutionYear executionYear) {
        return new LegacyAcademicTreasuryEvent(person, product, degree, executionYear);
    }

    protected void checkRules() {
        if (this.getPerson() == null) {
            throw new AcademicTreasuryDomainException("error.LegacyAcademicTreasuryEvent.person.required", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new AcademicTreasuryDomainException("error.LegacyAcademicTreasuryEvent.product.required", new String[0]);
        }
    }

    public boolean isAcademicServiceRequestEvent() {
        return false;
    }

    public boolean isAcademicTax() {
        return false;
    }

    public boolean isForAcademicServiceRequest() {
        return false;
    }

    public boolean isForExtracurricularTuition() {
        return false;
    }

    public boolean isForAcademicTax() {
        return false;
    }

    public boolean isForImprovementTax() {
        return false;
    }

    public boolean isForRegistrationTuition() {
        return false;
    }

    public boolean isForStandaloneTuition() {
        return false;
    }

    public boolean isImprovementTax() {
        return false;
    }

    public boolean isLegacy() {
        return true;
    }

    public boolean isUrgentRequest() {
        return false;
    }

    public boolean isTuitionEvent() {
        return false;
    }

    public LocalDate getTreasuryEventDate() {
        return this.getDueDate();
    }
}

