/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CloseDebtsStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CloseDebtsStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CloseDebtsStrategy$callable$processDebtsForRegistration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CloseDebtsStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static Logger logger;
    public static final Advice advice$process;
    public static final Advice advice$process$1;
    public static final Advice advice$processDebtsForRegistration;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return true;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return false;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return false;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        return (List)advice$process.perform((Callable)new CloseDebtsStrategy$callable$process(this, academicDebtGenerationRule));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(CloseDebtsStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        ArrayList resultList = Lists.newArrayList();
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : degreeCurricularPlan.getRegistrations()) {
                if (!rule.isRuleToApply(registration)) continue;
                AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
                resultList.add(result);
                try {
                    this_.processDebtsForRegistration(rule, registration);
                    result.markProcessingEndDateTime();
                }
                catch (AcademicTreasuryDomainException e) {
                    result.markException(e);
                    logger.debug(e.getMessage());
                }
                catch (Exception e) {
                    result.markException(e);
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        return (List)advice$process$1.perform((Callable)new CloseDebtsStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(CloseDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        if (!rule.isRuleToApply(registration)) {
            return Lists.newArrayList();
        }
        AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
        try {
            if (!rule.isRuleToApply(registration)) {
                return Lists.newArrayList();
            }
            if (registration.getStudentCurricularPlan(rule.getExecutionYear()) == null) {
                return Lists.newArrayList();
            }
            if (!rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) {
                return Lists.newArrayList();
            }
            this_.processDebtsForRegistration(rule, registration);
            result.markProcessingEndDateTime();
        }
        catch (AcademicTreasuryDomainException e) {
            result.markException(e);
            logger.debug(e.getMessage());
        }
        catch (Exception e) {
            result.markException(e);
            e.printStackTrace();
        }
        return Lists.newArrayList((Object[])new AcademicDebtGenerationProcessingResult[]{result});
    }

    private void processDebtsForRegistration(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$processDebtsForRegistration.perform((Callable)new CloseDebtsStrategy$callable$processDebtsForRegistration(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$processDebtsForRegistration(CloseDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        HashSet debitEntriesSetForAlignment = Sets.newHashSet();
        for (AcademicDebtGenerationRuleEntry entry : rule.getAcademicDebtGenerationRuleEntriesSet()) {
            Product product = entry.getProduct();
            Set<DebitEntry> grabbedDebitEntries = null;
            if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == product.getProductGroup()) {
                grabbedDebitEntries = this_.grabDebitEntryForTuitions(rule, registration, entry);
            } else if (AcademicTax.findUnique(product).isPresent()) {
                grabbedDebitEntries = this_.grabDebitEntryForAcademicTax(rule, registration, entry);
            } else if (product == TreasurySettings.getInstance().getInterestProduct()) {
                grabbedDebitEntries = this_.grabInterestDebitEntries(rule, registration);
            }
            if (grabbedDebitEntries == null) continue;
            debitEntriesSetForAlignment.addAll(grabbedDebitEntries);
        }
        if (this_.isToAlignAcademicTaxesDueDate() && rule.getAcademicTaxDueDateAlignmentType() != null) {
            rule.getAcademicTaxDueDateAlignmentType().applyDueDate(rule, debitEntriesSetForAlignment);
        }
        for (DebitEntry grabbedDebitEntry : debitEntriesSetForAlignment) {
            DebitNote debitNote;
            LocalDate dueDate;
            if (grabbedDebitEntry.getFinantialDocument() == null || !grabbedDebitEntry.getFinantialDocument().isPreparing() || (dueDate = grabbedDebitEntry.getDueDate()).minusDays(rule.getDays()).isAfter((ReadablePartial)new LocalDate()) || !AcademicTreasuryConstants.isPositive((debitNote = (DebitNote)grabbedDebitEntry.getFinantialDocument()).getTotalAmount())) continue;
            debitNote.closeDocument();
        }
    }

    private Set<DebitEntry> grabInterestDebitEntries(AcademicDebtGenerationRule rule, Registration registration) {
        HashSet<DebitEntry> result = new HashSet<DebitEntry>();
        Person person = registration.getStudent().getPerson();
        PersonCustomer.find(person).forEach(pc -> pc.getDebtAccountsSet().forEach(da -> DebitEntry.find((DebtAccount)da).filter(de -> de.getProduct() == TreasurySettings.getInstance().getInterestProduct()).filter(de -> de.getFinantialDocument() == null || de.getFinantialDocument().isPreparing()).filter(de -> de.isInDebt()).filter(de -> de.getDebitEntry() != null).filter(de -> de.getDebitEntry().getTreasuryEvent() != null).filter(de -> de.getDebitEntry().getTreasuryEvent() instanceof AcademicTreasuryEvent).filter(de -> ((AcademicTreasuryEvent)de.getDebitEntry().getTreasuryEvent()).getExecutionYear() == rule.getExecutionYear()).collect(Collectors.toCollection(() -> result))));
        for (DebitEntry debitEntry : result) {
            if (debitEntry.getFinantialDocument() != null) continue;
            DebtAccount debtAccount = debitEntry.getDebtAccount();
            DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
            debitEntry.setFinantialDocument((FinantialDocument)debitNote);
        }
        return result;
    }

    private Set<DebitEntry> grabDebitEntryForTuitions(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        PersonCustomer customer = implementation.personCustomer(registration.getPerson());
        if (customer == null) {
            return Sets.newHashSet();
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (t == null || !t.isChargedWithDebitEntry(product)) {
            return Sets.newHashSet();
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t, product).collect(Collectors.toSet());
    }

    private Set<DebitEntry> grabDebitEntryForAcademicTax(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        AcademicTax academicTax;
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        PersonCustomer customer = implementation.personCustomer(registration.getPerson());
        if (customer == null) {
            return Sets.newHashSet();
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax = AcademicTax.findUnique(product).get());
        if (t != null && t.isChargedWithDebitEntry()) {
            return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    private LocalDate maxDebitEntryDueDate(DebitNote debitNote) {
        LocalDate maxDate = debitNote.getDebitEntries().max(DebitEntry.COMPARE_BY_DUE_DATE).map(DebitEntry_Base::getDueDate).orElse(new LocalDate());
        return maxDate.isAfter((ReadablePartial)new LocalDate()) ? maxDate : new LocalDate();
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$processDebtsForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(CloseDebtsStrategy.class);
    }
}

