/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$RuleCallable$callable$executeRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$activate;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$copy;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$create;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$delete;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$edit;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$editDegreeCurricularPlans;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$inactivate;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$orderDown;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$orderUp;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule$callable$toggleBackgroundExecution;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleRestriction;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleType;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.DebtGenerationRuleRestriction;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.dto.debtGeneration.AcademicDebtGenerationRuleBean;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicDebtGenerationRule
extends AcademicDebtGenerationRule_Base {
    public static final Comparator<AcademicDebtGenerationRule> COMPARE_BY_ORDER_NUMBER;
    public static Comparator<AcademicDebtGenerationRule> COMPARATOR_BY_EXECUTION_YEAR;
    private static Logger logger;
    private static final List<String> MESSAGES_TO_IGNORE;
    public static final Advice advice$delete;
    public static final Advice advice$activate;
    public static final Advice advice$inactivate;
    public static final Advice advice$toggleBackgroundExecution;
    public static final Advice advice$orderUp;
    public static final Advice advice$orderDown;
    public static final Advice advice$editDegreeCurricularPlans;
    public static final Advice advice$edit;
    public static final Advice advice$create;
    public static final Advice advice$copy;

    public AcademicDebtGenerationRule() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AcademicDebtGenerationRule(AcademicDebtGenerationRuleBean bean) {
        this();
        this.setActive(true);
        this.setBackgroundExecution(true);
        this.setAcademicDebtGenerationRuleType(bean.getType());
        this.setExecutionYear(bean.getExecutionYear());
        this.setAggregateOnDebitNote(bean.isAggregateOnDebitNote());
        this.setAggregateAllOrNothing(bean.isAggregateAllOrNothing());
        this.setEventDebitEntriesMustEqualRuleProducts(bean.isEventDebitEntriesMustEqualRuleProducts());
        this.setCloseDebitNote(false);
        this.setAlignAllAcademicTaxesDebitToMaxDueDate(false);
        this.setCreatePaymentReferenceCode(bean.isToCreatePaymentReferenceCodes());
        if (bean.isToAlignAcademicTaxesDueDate()) {
            this.setAcademicTaxDueDateAlignmentType(bean.getAcademicTaxDueDateAlignmentType());
        }
        for (AcademicDebtGenerationRuleBean.ProductEntry productEntry : bean.getEntries()) {
            AcademicDebtGenerationRuleEntry.create(this, productEntry.getProduct(), productEntry.isCreateDebt(), productEntry.isToCreateAfterLastRegistrationStateDate(), productEntry.isForceCreation(), productEntry.isForceCreation() && productEntry.isLimitToRegisteredOnExecutionYear());
        }
        this.getDegreeCurricularPlansSet().addAll(bean.getDegreeCurricularPlans());
        this.setOrderNumber(-1);
        Optional<AcademicDebtGenerationRule> max = AcademicDebtGenerationRule.find(this.getAcademicDebtGenerationRuleType(), this.getExecutionYear()).max(COMPARE_BY_ORDER_NUMBER);
        this.setOrderNumber(max.isPresent() ? max.get().getOrderNumber() + 1 : 1);
        this.setDays(bean.getNumberOfDaysToDueDate());
        if (bean.isAppliedMinimumAmountForPaymentCode()) {
            this.setMinimumAmountForPaymentCode(bean.getMinimumAmountForPaymentCode());
        } else {
            this.setMinimumAmountForPaymentCode(null);
        }
        this.checkRules();
    }

    public AcademicDebtGenerationRule(AcademicDebtGenerationRule ruleToCopy, ExecutionYear executionYear) {
        this();
        this.setActive(ruleToCopy.isActive());
        this.setBackgroundExecution(ruleToCopy.isBackgroundExecution());
        this.setAcademicDebtGenerationRuleType(ruleToCopy.getAcademicDebtGenerationRuleType());
        this.setExecutionYear(executionYear);
        this.setAggregateOnDebitNote(ruleToCopy.isAggregateOnDebitNote());
        this.setAggregateAllOrNothing(ruleToCopy.isAggregateAllOrNothing());
        this.setEventDebitEntriesMustEqualRuleProducts(ruleToCopy.isEventDebitEntriesMustEqualRuleProducts());
        this.setCloseDebitNote(ruleToCopy.isCloseDebitNote());
        this.setAlignAllAcademicTaxesDebitToMaxDueDate(ruleToCopy.isAlignAllAcademicTaxesDebitToMaxDueDate());
        this.setCreatePaymentReferenceCode(ruleToCopy.isCreatePaymentReferenceCode());
        this.setAcademicTaxDueDateAlignmentType(ruleToCopy.getAcademicTaxDueDateAlignmentType());
        for (AcademicDebtGenerationRuleEntry entry : ruleToCopy.getAcademicDebtGenerationRuleEntriesSet()) {
            AcademicDebtGenerationRuleEntry.create(this, entry.getProduct(), entry.isCreateDebt(), entry.isToCreateAfterLastRegistrationStateDate(), entry.isForceCreation(), entry.isLimitToRegisteredOnExecutionYear());
        }
        ruleToCopy.getAcademicDebtGenerationRuleRestrictionsSet().stream().forEach(r -> r.makeCopy(this));
        this.getDegreeCurricularPlansSet().addAll(ruleToCopy.getDegreeCurricularPlansSet());
        this.setOrderNumber(-1);
        Optional<AcademicDebtGenerationRule> max = AcademicDebtGenerationRule.find(this.getAcademicDebtGenerationRuleType(), this.getExecutionYear()).max(COMPARE_BY_ORDER_NUMBER);
        this.setOrderNumber(max.isPresent() ? max.get().getOrderNumber() + 1 : 1);
        this.setDays(ruleToCopy.getDays());
        this.setDebtGenerationRuleRestriction(ruleToCopy.getDebtGenerationRuleRestriction());
        if (ruleToCopy.isAppliedMinimumAmountForPaymentCode()) {
            this.setMinimumAmountForPaymentCode(ruleToCopy.getMinimumAmountForPaymentCode());
        } else {
            this.setMinimumAmountForPaymentCode(null);
        }
        this.setCopyFromAcademicDebtGenerationRule(ruleToCopy);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.bennu.required", new String[0]);
        }
        if (this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.executionYear.required", new String[0]);
        }
        if (this.isCloseDebitNote() && !this.isAggregateOnDebitNote()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.closeDebitNote.requires.aggregateOnDebitNote", new String[0]);
        }
        if (this.isAggregateAllOrNothing() && !this.isAggregateOnDebitNote()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.aggregateAllOrNothing.requires.aggregateOnDebitNote", new String[0]);
        }
        if (this.getAcademicDebtGenerationRuleType().strategyImplementation().isEntriesRequired() && this.getAcademicDebtGenerationRuleEntriesSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.entries.required", new String[0]);
        }
        if (this.getDegreeCurricularPlansSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.degreeCurricularPlans.required", new String[0]);
        }
        if (this.getMinimumAmountForPaymentCode() != null && !TreasuryConstants.isPositive((BigDecimal)this.getMinimumAmountForPaymentCode())) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.minimumAmountForPaymentCode.invalid", this.getMinimumAmountForPaymentCode().toString());
        }
        if (this.getMinimumAmountForPaymentCode() != null && this.getMinimumAmountForPaymentCode().scale() > 2) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.minimumAmountForPaymentCode.invalid", this.getMinimumAmountForPaymentCode().toString());
        }
    }

    public List<AcademicDebtGenerationRuleEntry> getOrderedAcademicDebtGenerationRuleEntries() {
        return this.getAcademicDebtGenerationRuleEntriesSet().stream().sorted((e1, e2) -> Integer.compare(e1.getProduct().getTuitionInstallmentOrder(), e2.getProduct().getTuitionInstallmentOrder())).collect(Collectors.toList());
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isBackgroundExecution() {
        return this.getBackgroundExecution();
    }

    public boolean isAggregateOnDebitNote() {
        return super.getAggregateOnDebitNote();
    }

    public boolean isAggregateAllOrNothing() {
        return super.getAggregateAllOrNothing();
    }

    public boolean isEventDebitEntriesMustEqualRuleProducts() {
        return super.getEventDebitEntriesMustEqualRuleProducts();
    }

    public boolean isCloseDebitNote() {
        return super.getCloseDebitNote();
    }

    public boolean isAlignAllAcademicTaxesDebitToMaxDueDate() {
        return super.getAlignAllAcademicTaxesDebitToMaxDueDate();
    }

    public boolean isCreatePaymentReferenceCode() {
        return super.getCreatePaymentReferenceCode();
    }

    public boolean isAppliedMinimumAmountForPaymentCode() {
        return this.getMinimumAmountForPaymentCode() != null;
    }

    public Set<AcademicDebtGenerationRuleEntry> getTuitionProductGroupProductEntries() {
        return this.getAcademicDebtGenerationRuleEntriesSet().stream().filter(e -> e.getProduct().getProductGroup() == AcademicTreasurySettings.getInstance().getTuitionProductGroup()).collect(Collectors.toSet());
    }

    public boolean isWithAtLeastOneForceCreationEntry() {
        return this.getAcademicDebtGenerationRuleEntriesSet().stream().anyMatch(e -> e.isForceCreation());
    }

    private boolean isDeletable() {
        return true;
    }

    @Deprecated
    public DebtGenerationRuleRestriction getDebtGenerationRuleRestriction() {
        return super.getDebtGenerationRuleRestriction();
    }

    @Deprecated
    public void setDebtGenerationRuleRestriction(DebtGenerationRuleRestriction debtGenerationRuleRestriction) {
        super.setDebtGenerationRuleRestriction(debtGenerationRuleRestriction);
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicDebtGenerationRule$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicDebtGenerationRule this_) {
        TreasuryDomainException.throwWhenDeleteBlocked((Collection)this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setAcademicDebtGenerationRuleType(null);
        this_.getDegreeCurricularPlansSet().clear();
        this_.setExecutionYear(null);
        while (this_.getAcademicDebtGenerationRuleEntriesSet().size() > 0) {
            ((AcademicDebtGenerationRuleEntry)((Object)this_.getAcademicDebtGenerationRuleEntriesSet().iterator().next())).delete();
        }
        this_.setDebtGenerationRuleRestriction(null);
        while (!this_.getAcademicDebtGenerationRuleRestrictionsSet().isEmpty()) {
            ((AcademicDebtGenerationRuleRestriction)this_.getAcademicDebtGenerationRuleRestrictionsSet().iterator().next()).delete();
        }
        this_.setCopyFromAcademicDebtGenerationRule(null);
        while (!this_.getAcademicDebtGenerationRuleCopiesSet().isEmpty()) {
            ((AcademicDebtGenerationRule)((Object)this_.getAcademicDebtGenerationRuleCopiesSet().iterator().next())).setCopyFromAcademicDebtGenerationRule(null);
        }
        super.deleteDomainObject();
    }

    public void activate() {
        Object object = advice$activate.perform((Callable)new AcademicDebtGenerationRule$callable$activate(this));
    }

    static /* synthetic */ void advised$activate(AcademicDebtGenerationRule this_) {
        this_.setActive(true);
        this_.checkRules();
    }

    public void inactivate() {
        Object object = advice$inactivate.perform((Callable)new AcademicDebtGenerationRule$callable$inactivate(this));
    }

    static /* synthetic */ void advised$inactivate(AcademicDebtGenerationRule this_) {
        this_.setActive(false);
        this_.checkRules();
    }

    public void toggleBackgroundExecution() {
        Object object = advice$toggleBackgroundExecution.perform((Callable)new AcademicDebtGenerationRule$callable$toggleBackgroundExecution(this));
    }

    static /* synthetic */ void advised$toggleBackgroundExecution(AcademicDebtGenerationRule this_) {
        this_.setBackgroundExecution(!this_.isBackgroundExecution());
    }

    private AcademicDebtGenerationRule findPrevious() {
        List list = AcademicDebtGenerationRule.find(this.getAcademicDebtGenerationRuleType(), this.getExecutionYear()).sorted(COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList());
        AcademicDebtGenerationRule result = null;
        for (AcademicDebtGenerationRule r : list) {
            if (r.getOrderNumber() >= this.getOrderNumber()) continue;
            if (result == null) {
                result = r;
                continue;
            }
            if (r.getOrderNumber() <= result.getOrderNumber()) continue;
            result = r;
        }
        return result;
    }

    private AcademicDebtGenerationRule findNext() {
        List list = AcademicDebtGenerationRule.find(this.getAcademicDebtGenerationRuleType(), this.getExecutionYear()).sorted(COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList());
        AcademicDebtGenerationRule result = null;
        for (AcademicDebtGenerationRule r : list) {
            if (r.getOrderNumber() <= this.getOrderNumber()) continue;
            if (result == null) {
                result = r;
                continue;
            }
            if (r.getOrderNumber() >= result.getOrderNumber()) continue;
            result = r;
        }
        return result;
    }

    public boolean isFirst() {
        return AcademicDebtGenerationRule.find(this.getAcademicDebtGenerationRuleType(), this.getExecutionYear()).min(COMPARE_BY_ORDER_NUMBER).get() == this;
    }

    public boolean isLast() {
        return AcademicDebtGenerationRule.find(this.getAcademicDebtGenerationRuleType(), this.getExecutionYear()).max(COMPARE_BY_ORDER_NUMBER).get() == this;
    }

    public boolean isCopyFromOtherExistingAcademicDebtGenerationRule() {
        return this.getCopyFromAcademicDebtGenerationRule() != null;
    }

    public boolean hasCopiesInExecutionInterval(ExecutionInterval executionInterval) {
        return this.getAcademicDebtGenerationRuleCopiesSet().stream().anyMatch(r -> r.getExecutionYear() == executionInterval);
    }

    public void orderUp() {
        Object object = advice$orderUp.perform((Callable)new AcademicDebtGenerationRule$callable$orderUp(this));
    }

    static /* synthetic */ void advised$orderUp(AcademicDebtGenerationRule this_) {
        AcademicDebtGenerationRule previous = this_.findPrevious();
        if (previous == null) {
            return;
        }
        int t = previous.getOrderNumber();
        previous.setOrderNumber(this_.getOrderNumber());
        this_.setOrderNumber(t);
    }

    public void orderDown() {
        Object object = advice$orderDown.perform((Callable)new AcademicDebtGenerationRule$callable$orderDown(this));
    }

    static /* synthetic */ void advised$orderDown(AcademicDebtGenerationRule this_) {
        AcademicDebtGenerationRule next = this_.findNext();
        if (next == null) {
            return;
        }
        int t = next.getOrderNumber();
        next.setOrderNumber(this_.getOrderNumber());
        this_.setOrderNumber(t);
    }

    public void editDegreeCurricularPlans(Set<DegreeCurricularPlan> set) {
        Object object = advice$editDegreeCurricularPlans.perform((Callable)new AcademicDebtGenerationRule$callable$editDegreeCurricularPlans(this, set));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$editDegreeCurricularPlans(AcademicDebtGenerationRule this_, Set degreeCurricularPlans) {
        this_.getDegreeCurricularPlansSet().clear();
        this_.getDegreeCurricularPlansSet().addAll(degreeCurricularPlans);
    }

    public void edit(AcademicDebtGenerationRuleBean academicDebtGenerationRuleBean) {
        Object object = advice$edit.perform((Callable)new AcademicDebtGenerationRule$callable$edit(this, academicDebtGenerationRuleBean));
    }

    static /* synthetic */ void advised$edit(AcademicDebtGenerationRule this_, AcademicDebtGenerationRuleBean bean) {
        this_.getDegreeCurricularPlansSet().clear();
        while (!this_.getAcademicDebtGenerationRuleEntriesSet().isEmpty()) {
            ((AcademicDebtGenerationRuleEntry)((Object)this_.getAcademicDebtGenerationRuleEntriesSet().iterator().next())).delete();
        }
        List<DegreeCurricularPlan> degreeCurricularPlans = bean.getDegreeCurricularPlans();
        this_.getDegreeCurricularPlansSet().addAll(degreeCurricularPlans);
        this_.setAggregateOnDebitNote(bean.isAggregateOnDebitNote());
        this_.setAggregateAllOrNothing(bean.isAggregateAllOrNothing());
        this_.setEventDebitEntriesMustEqualRuleProducts(bean.isEventDebitEntriesMustEqualRuleProducts());
        this_.setCloseDebitNote(false);
        this_.setAlignAllAcademicTaxesDebitToMaxDueDate(false);
        this_.setCreatePaymentReferenceCode(bean.isToCreatePaymentReferenceCodes());
        if (bean.isToAlignAcademicTaxesDueDate()) {
            this_.setAcademicTaxDueDateAlignmentType(bean.getAcademicTaxDueDateAlignmentType());
        }
        for (AcademicDebtGenerationRuleBean.ProductEntry productEntry : bean.getEntries()) {
            AcademicDebtGenerationRuleEntry.create(this_, productEntry.getProduct(), productEntry.isCreateDebt(), productEntry.isToCreateAfterLastRegistrationStateDate(), productEntry.isForceCreation(), productEntry.isForceCreation() && productEntry.isLimitToRegisteredOnExecutionYear());
        }
        this_.setDays(bean.getNumberOfDaysToDueDate());
        if (bean.isAppliedMinimumAmountForPaymentCode()) {
            this_.setMinimumAmountForPaymentCode(bean.getMinimumAmountForPaymentCode());
        } else {
            this_.setMinimumAmountForPaymentCode(null);
        }
        this_.checkRules();
    }

    public boolean isRuleToApply(Registration registration) {
        if (this.getDebtGenerationRuleRestriction() != null && !this.getDebtGenerationRuleRestriction().strategyImplementation().isToApply(this, registration)) {
            return false;
        }
        return this.getAcademicDebtGenerationRuleRestrictionsSet().isEmpty() || this.getAcademicDebtGenerationRuleRestrictionsSet().stream().allMatch(r -> r.test(registration));
    }

    public static Stream<AcademicDebtGenerationRule> findAll() {
        return FenixFramework.getDomainRoot().getAcademicDebtGenerationRuleSet().stream();
    }

    public static Stream<AcademicDebtGenerationRule> find(AcademicDebtGenerationRuleType type, ExecutionYear executionYear) {
        return AcademicDebtGenerationRule.findAll().filter(r -> r.getExecutionYear() == executionYear).filter(r -> r.getAcademicDebtGenerationRuleType() == type);
    }

    public static Stream<AcademicDebtGenerationRule> findActive() {
        return AcademicDebtGenerationRule.findAll().filter(AcademicDebtGenerationRule::isActive);
    }

    public static Stream<AcademicDebtGenerationRule> findActiveByType(AcademicDebtGenerationRuleType type) {
        return type.getAcademicDebtGenerationRulesSet().stream().filter(AcademicDebtGenerationRule::isActive);
    }

    public static AcademicDebtGenerationRule create(AcademicDebtGenerationRuleBean academicDebtGenerationRuleBean) {
        return (AcademicDebtGenerationRule)((Object)advice$create.perform((Callable)new AcademicDebtGenerationRule$callable$create(academicDebtGenerationRuleBean)));
    }

    static /* synthetic */ AcademicDebtGenerationRule advised$create(AcademicDebtGenerationRuleBean bean) {
        if (bean.isAppliedMinimumAmountForPaymentCode() && (bean.getMinimumAmountForPaymentCode() == null || !TreasuryConstants.isPositive((BigDecimal)bean.getMinimumAmountForPaymentCode()))) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.create.appliedMinimumAmountForPaymentCode.but.minimumAmountForPaymentCode.not.valid", new String[0]);
        }
        return new AcademicDebtGenerationRule(bean);
    }

    public static AcademicDebtGenerationRule copy(AcademicDebtGenerationRule academicDebtGenerationRule, ExecutionYear executionYear) {
        return (AcademicDebtGenerationRule)((Object)advice$copy.perform((Callable)new AcademicDebtGenerationRule$callable$copy(academicDebtGenerationRule, executionYear)));
    }

    static /* synthetic */ AcademicDebtGenerationRule advised$copy(AcademicDebtGenerationRule rule, ExecutionYear executionYear) {
        if (executionYear == rule.getExecutionYear()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.copy.same.executionYear", new String[0]);
        }
        return new AcademicDebtGenerationRule(rule, executionYear);
    }

    public static List<AcademicDebtGenerationProcessingResult> runAllActive(boolean runOnlyWithBackgroundExecution) {
        return AcademicDebtGenerationRule.runAllActive(runOnlyWithBackgroundExecution, null, null, null);
    }

    public static List<AcademicDebtGenerationProcessingResult> runAllActive(boolean runOnlyWithBackgroundExecution, Consumer<List<AcademicDebtGenerationProcessingResult>> ruleExecutionCallback, AcademicDebtGenerationRuleType typeArg, ExecutionYear executionYearArg) {
        ArrayList futureList = Lists.newArrayList();
        ExecutorService exService = Executors.newSingleThreadExecutor();
        for (AcademicDebtGenerationRuleType type : AcademicDebtGenerationRuleType.findAll().sorted(AcademicDebtGenerationRuleType.COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList())) {
            if (typeArg != null && typeArg != type) continue;
            for (AcademicDebtGenerationRule academicDebtGenerationRule : AcademicDebtGenerationRule.findActiveByType(type).sorted(COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList())) {
                if (executionYearArg != null && academicDebtGenerationRule.getExecutionYear() != executionYearArg || runOnlyWithBackgroundExecution && !academicDebtGenerationRule.isBackgroundExecution()) continue;
                RuleCallable exec = new RuleCallable(academicDebtGenerationRule, ruleExecutionCallback);
                futureList.add(exService.submit(exec));
            }
        }
        exService.shutdown();
        ArrayList returnResult = Lists.newArrayList();
        for (Future future : futureList) {
            try {
                returnResult.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
        return returnResult;
    }

    public static List<AcademicDebtGenerationProcessingResult> runAllActiveForRegistration(Registration registration, boolean runOnlyWithBackgroundExecution) {
        ArrayList futureList = Lists.newArrayList();
        ExecutorService exService = Executors.newSingleThreadExecutor();
        for (AcademicDebtGenerationRuleType type : AcademicDebtGenerationRuleType.findAll().sorted(AcademicDebtGenerationRuleType.COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList())) {
            for (AcademicDebtGenerationRule academicDebtGenerationRule : AcademicDebtGenerationRule.findActiveByType(type).sorted(COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList())) {
                if (runOnlyWithBackgroundExecution && !academicDebtGenerationRule.isBackgroundExecution()) continue;
                RuleCallable exec = new RuleCallable(academicDebtGenerationRule, registration, null);
                futureList.add(exService.submit(exec));
            }
        }
        exService.shutdown();
        ArrayList returnResult = Lists.newArrayList();
        for (Future future : futureList) {
            try {
                returnResult.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
        return returnResult;
    }

    public static List<AcademicDebtGenerationProcessingResult> runAllActiveForRegistrationAndExecutionYear(Registration registration, ExecutionYear executionYear, boolean runOnlyWithBackgroundExecution) {
        ArrayList futureList = Lists.newArrayList();
        ExecutorService exService = Executors.newSingleThreadExecutor();
        for (AcademicDebtGenerationRuleType type : AcademicDebtGenerationRuleType.findAll().sorted(AcademicDebtGenerationRuleType.COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList())) {
            for (AcademicDebtGenerationRule academicDebtGenerationRule : AcademicDebtGenerationRule.findActiveByType(type).sorted(COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList())) {
                if (runOnlyWithBackgroundExecution && !academicDebtGenerationRule.isBackgroundExecution() || academicDebtGenerationRule.getExecutionYear() != executionYear) continue;
                RuleCallable exec = new RuleCallable(academicDebtGenerationRule, registration, null);
                futureList.add(exService.submit(exec));
            }
        }
        exService.shutdown();
        ArrayList returnResult = Lists.newArrayList();
        for (Future future : futureList) {
            try {
                returnResult.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
        return returnResult;
    }

    public static List<AcademicDebtGenerationProcessingResult> runAcademicDebtGenerationRule(AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active", new String[0]);
        }
        ExecutorService exService = Executors.newSingleThreadExecutor();
        RuleCallable exec = new RuleCallable(rule, null);
        try {
            return exService.submit(exec).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return Lists.newArrayList();
        }
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$activate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$inactivate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$toggleBackgroundExecution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$orderUp = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$orderDown = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$editDegreeCurricularPlans = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$copy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_ORDER_NUMBER = (o1, o2) -> {
            int v = Integer.compare(o1.getAcademicDebtGenerationRuleType().getOrderNumber(), o2.getAcademicDebtGenerationRuleType().getOrderNumber());
            if (v != 0) {
                return v;
            }
            int c = Integer.compare(o1.getOrderNumber(), o2.getOrderNumber());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARATOR_BY_EXECUTION_YEAR = (o1, o2) -> {
            int c = o1.getExecutionYear().compareTo(o2.getExecutionYear());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        logger = LoggerFactory.getLogger(AcademicDebtGenerationRule.class);
        MESSAGES_TO_IGNORE = Lists.newArrayList((Object[])new String[]{"error.AcademicDebtGenerationRule.debit.note.without.debit.entries", "error.AcademicDebtGenerationRule.debitEntry.with.none.or.annuled.finantial.document"});
    }

    public static final class RuleCallable
    implements Callable<List<AcademicDebtGenerationProcessingResult>> {
        private String academicDebtGenerationRuleId;
        private String registrationId;
        private Consumer<List<AcademicDebtGenerationProcessingResult>> ruleExecutionCallback;
        public static final Advice advice$executeRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

        public RuleCallable(AcademicDebtGenerationRule rule, Consumer<List<AcademicDebtGenerationProcessingResult>> ruleExecutionCallback) {
            this.academicDebtGenerationRuleId = rule.getExternalId();
            this.ruleExecutionCallback = ruleExecutionCallback;
        }

        public RuleCallable(AcademicDebtGenerationRule rule, Registration registration, Consumer<List<AcademicDebtGenerationProcessingResult>> ruleExecutionCallback) {
            this.academicDebtGenerationRuleId = rule.getExternalId();
            this.registrationId = registration.getExternalId();
            this.ruleExecutionCallback = ruleExecutionCallback;
        }

        @Override
        public List<AcademicDebtGenerationProcessingResult> call() {
            return this.executeRule();
        }

        private List<AcademicDebtGenerationProcessingResult> executeRule() {
            return (List)advice$executeRule.perform((Callable)new AcademicDebtGenerationRule$RuleCallable$callable$executeRule(this));
        }

        static /* synthetic */ List<AcademicDebtGenerationProcessingResult> advised$executeRule(RuleCallable this_) {
            ArrayList result = Lists.newArrayList();
            AcademicDebtGenerationRule rule = (AcademicDebtGenerationRule)FenixFramework.getDomainObject((String)this_.academicDebtGenerationRuleId);
            try {
                if (!Strings.isNullOrEmpty((String)this_.registrationId)) {
                    Registration registration = (Registration)FenixFramework.getDomainObject((String)this_.registrationId);
                    result.addAll(rule.getAcademicDebtGenerationRuleType().strategyImplementation().process(rule, registration));
                } else {
                    result.addAll(rule.getAcademicDebtGenerationRuleType().strategyImplementation().process(rule));
                }
            }
            catch (AcademicTreasuryDomainException e) {
                if (!MESSAGES_TO_IGNORE.contains(e.getMessage())) {
                    logger.info(e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this_.ruleExecutionCallback != null) {
                this_.ruleExecutionCallback.accept(result);
            }
            return result;
        }
    }
}

