/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.util;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class AcademicTreasuryConstants {
    private static final int SCALE = 20;
    public static final int EXTENDED_CURRENCY_DECIMAL_DIGITS = 4;
    public static final String BUNDLE = "resources.AcademicTreasuryResources";
    public static final BigDecimal HUNDRED_PERCENT = new BigDecimal("100.00");
    public static final BigDecimal DEFAULT_QUANTITY = new BigDecimal(1);
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD = "yyyy/MM/dd HH:mm:ss";
    public static final String STANDARD_DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final DateTime INFINITY_DATE = new DateTime().plusYears(500);
    public static final TreasuryTupleDataSourceBean SELECT_OPTION = new TreasuryTupleDataSourceBean("", AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryTupleDataSourceBean.select.description", new String[0]));
    public static final Locale DEFAULT_LANGUAGE = new Locale("PT");
    public static final String DEFAULT_COUNTRY = "PT";
    public static final Locale ENGLISH_LANGUAGE = new Locale("EN");

    @Deprecated
    public static boolean isForeignLanguage(Locale language) {
        return !language.getLanguage().equals(DEFAULT_LANGUAGE.getLanguage());
    }

    @Deprecated
    public static boolean isDefaultCountry(String country) {
        if (Strings.isNullOrEmpty((String)country)) {
            return false;
        }
        return DEFAULT_COUNTRY.equals(country.toUpperCase());
    }

    public static boolean isNegative(BigDecimal value) {
        return !AcademicTreasuryConstants.isZero(value) && !AcademicTreasuryConstants.isPositive(value);
    }

    public static boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    public static boolean isPositive(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) < 0;
    }

    public static boolean isGreaterThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public static BigDecimal defaultScale(BigDecimal v) {
        return v.setScale(20, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        return a.divide(b, 20, RoundingMode.HALF_EVEN);
    }

    public static String academicTreasuryBundle(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(BUNDLE, key, args);
    }

    public static String academicTreasuryBundle(Locale locale, String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(locale, BUNDLE, key, args);
    }

    public static LocalizedString academicTreasuryBundleI18N(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundleI18N(BUNDLE, key, args);
    }

    public static Set<Locale> supportedLocales() {
        return TreasuryPlataformDependentServicesFactory.implementation().availableLocales();
    }

    public static boolean isDateBetween(LocalDate beginDate, LocalDate endDate, LocalDate when) {
        return new Interval((ReadableInstant)beginDate.toDateTimeAtStartOfDay(), (ReadableInstant)(endDate != null ? endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : INFINITY_DATE)).contains((ReadableInstant)when.toDateTimeAtStartOfDay());
    }

    public static boolean isDateBetween(LocalDate beginDate, LocalDate endDate, DateTime when) {
        return new Interval((ReadableInstant)beginDate.toDateTimeAtStartOfDay(), (ReadableInstant)(endDate != null ? endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : INFINITY_DATE)).contains((ReadableInstant)when);
    }

    public static Integer getNumberOfUnits(ITreasuryServiceRequest request) {
        if (request.hasNumberOfUnits()) {
            return request.getNumberOfUnits();
        }
        if (request.hasNumberOfDays()) {
            return request.getNumberOfDays();
        }
        Integer numberOfApprovedExtraCurriculum = request.hasApprovedExtraCurriculum() ? request.getApprovedExtraCurriculum().size() : 0;
        Integer numberOfApprovedStandaloneCurriculum = request.hasApprovedStandaloneCurriculum() ? request.getApprovedStandaloneCurriculum().size() : 0;
        Integer numberOfApprovedEnrolments = request.hasApprovedEnrolments() ? request.getApprovedEnrolments().size() : 0;
        Integer numberOfCurriculum = request.hasCurriculum() ? request.getCurriculum().size() : 0;
        int numberOfEnrolments = request.hasEnrolmentsByYear() ? request.getEnrolmentsByYear().size() : 0;
        numberOfEnrolments += request.hasStandaloneEnrolmentsByYear() ? request.getStandaloneEnrolmentsByYear().size() : 0;
        return numberOfApprovedExtraCurriculum + numberOfApprovedStandaloneCurriculum + numberOfApprovedEnrolments + numberOfCurriculum + (numberOfEnrolments += request.hasExtracurricularEnrolmentsByYear() ? request.getExtracurricularEnrolmentsByYear().size() : 0);
    }
}

