/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanOrder$callable$orderDown;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanOrder$callable$orderUp;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanOrder_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionPaymentPlanOrder
extends TuitionPaymentPlanOrder_Base {
    public static final Comparator<? super TuitionPaymentPlanOrder> COMPARE_BY_PAYMENT_PLAN_ORDER;
    public static final Advice advice$orderUp;
    public static final Advice advice$orderDown;

    public TuitionPaymentPlanOrder() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public TuitionPaymentPlanOrder(TuitionPaymentPlan tuitionPaymentPlan, DegreeCurricularPlan degreeCurricularPlan) {
        this();
        TuitionPaymentPlanOrder planOrder1 = TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(tuitionPaymentPlan.getTuitionPaymentPlanGroup(), degreeCurricularPlan, tuitionPaymentPlan.getExecutionYear()).sorted(COMPARE_BY_PAYMENT_PLAN_ORDER.reversed()).findFirst().orElse(null);
        this.setPaymentPlanOrder(planOrder1 == null ? 1 : planOrder1.getPaymentPlanOrder() + 1);
        this.setTuitionPaymentPlan(tuitionPaymentPlan);
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.checkRules();
    }

    public static TuitionPaymentPlanOrder create(TuitionPaymentPlan tuitionPaymentPlan, DegreeCurricularPlan degreeCurricularPlan) {
        TuitionPaymentPlanOrder tuitionPaymentPlanOrder = new TuitionPaymentPlanOrder(tuitionPaymentPlan, degreeCurricularPlan);
        tuitionPaymentPlanOrder.setOnReachablePosition();
        return tuitionPaymentPlanOrder;
    }

    private void checkRules() {
        if (this.getTuitionPaymentPlan() == null) {
            throw new AcademicTreasuryDomainException("error.tuitionPaymentPlanOrder.tuitionPaymentPlan.required", new String[0]);
        }
        if (this.getDegreeCurricularPlan() == null) {
            throw new AcademicTreasuryDomainException("error.tuitionPaymentPlanOrder.degreeCurricularPlan.required", new String[0]);
        }
        if (TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).filter(order -> order.getTuitionPaymentPlan() == this.getTuitionPaymentPlan()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.tuitionPaymentPlanOrder.tuitionPaymentPlan.duplicated", new String[0]);
        }
    }

    public void delete() {
        this.delete(true);
    }

    private void setOnReachablePosition() {
        while (!this.isReacheble()) {
            this.orderUp();
        }
    }

    public boolean isReacheble() {
        List tuitionPaymentPlanOrders = TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList());
        for (TuitionPaymentPlanOrder tuitionPlanOrder : tuitionPaymentPlanOrders) {
            if (this.getTuitionPaymentPlan() == tuitionPlanOrder.getTuitionPaymentPlan()) {
                return true;
            }
            if (this.compareOrderWithTuitionPlan(tuitionPlanOrder.getTuitionPaymentPlan()) >= 0) continue;
            return false;
        }
        return true;
    }

    private int compareOrderWithTuitionPlan(TuitionPaymentPlan plan) {
        TuitionPaymentPlan thisPlan = this.getTuitionPaymentPlan();
        if (thisPlan.isCustomized() || plan.isCustomized()) {
            return 0;
        }
        if (thisPlan.isDefaultPaymentPlan()) {
            return 1;
        }
        if (plan.isDefaultPaymentPlan()) {
            return -1;
        }
        if (thisPlan.equalsTuitionPlanConditions(plan)) {
            return -1;
        }
        if (thisPlan.containsTuitionPlanConditions(plan)) {
            return -1;
        }
        if (plan.containsTuitionPlanConditions(thisPlan)) {
            return 1;
        }
        return 0;
    }

    public void orderUp() {
        Object object = advice$orderUp.perform((Callable)new TuitionPaymentPlanOrder$callable$orderUp(this));
    }

    static /* synthetic */ void advised$orderUp(TuitionPaymentPlanOrder this_) {
        if (this_.isFirst()) {
            return;
        }
        TuitionPaymentPlanOrder previous = this_.getPreviousTuitionPaymentPlan();
        int order = previous.getPaymentPlanOrder();
        previous.setPaymentPlanOrder(this_.getPaymentPlanOrder());
        this_.setPaymentPlanOrder(order);
    }

    public void orderDown() {
        Object object = advice$orderDown.perform((Callable)new TuitionPaymentPlanOrder$callable$orderDown(this));
    }

    static /* synthetic */ void advised$orderDown(TuitionPaymentPlanOrder this_) {
        if (this_.isLast()) {
            return;
        }
        TuitionPaymentPlanOrder next = this_.getNextTuitionPaymentPlan();
        int order = next.getPaymentPlanOrder();
        next.setPaymentPlanOrder(this_.getPaymentPlanOrder());
        this_.setPaymentPlanOrder(order);
    }

    public boolean isFirst() {
        return TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList()).get(0) == this;
    }

    public boolean isLast() {
        List list = TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList());
        return list.get(list.size() - 1) == this;
    }

    public static Stream<TuitionPaymentPlanOrder> findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlanOrder.find(degreeCurricularPlan).filter(o -> o.getTuitionPaymentPlan().getTuitionPaymentPlanGroup() == tuitionPaymentPlanGroup && o.getTuitionPaymentPlan().getExecutionYear() == executionYear).sorted(COMPARE_BY_PAYMENT_PLAN_ORDER);
    }

    private TuitionPaymentPlanOrder getPreviousTuitionPaymentPlan() {
        if (this.isFirst()) {
            return null;
        }
        return (TuitionPaymentPlanOrder)((Object)TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList()).get(this.getPaymentPlanOrder() - 2));
    }

    private TuitionPaymentPlanOrder getNextTuitionPaymentPlan() {
        if (this.isLast()) {
            return null;
        }
        return (TuitionPaymentPlanOrder)((Object)TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList()).get(this.getPaymentPlanOrder()));
    }

    private ExecutionYear getExecutionYear() {
        return this.getTuitionPaymentPlan().getExecutionYear();
    }

    private TuitionPaymentPlanGroup getTuitionPaymentPlanGroup() {
        return this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup();
    }

    public void delete(boolean deletePlan) {
        TuitionPaymentPlan tuitionPaymentPlan = this.getTuitionPaymentPlan();
        List collect = TuitionPaymentPlanOrder.find(this.getDegreeCurricularPlan()).filter(order -> order.getTuitionPaymentPlan().getExecutionYear() == tuitionPaymentPlan.getExecutionYear() && order != this && tuitionPaymentPlan.getTuitionPaymentPlanGroup() == order.getTuitionPaymentPlan().getTuitionPaymentPlanGroup()).sorted(COMPARE_BY_PAYMENT_PLAN_ORDER).collect(Collectors.toList());
        this.setDomainRoot(null);
        this.setTuitionPaymentPlan(null);
        this.setDegreeCurricularPlan(null);
        if (deletePlan && tuitionPaymentPlan.getTuitionPaymentPlanOrdersSet().isEmpty()) {
            tuitionPaymentPlan.delete();
        }
        int i = 1;
        for (TuitionPaymentPlanOrder order2 : collect) {
            order2.setPaymentPlanOrder(i);
            ++i;
        }
        super.deleteDomainObject();
    }

    public TuitionPaymentPlanOrder copyToPlan(TuitionPaymentPlan tuitionPaymentPlan) {
        TuitionPaymentPlanOrder result = new TuitionPaymentPlanOrder();
        result.setDomainRoot(this.getDomainRoot());
        result.setDegreeCurricularPlan(this.getDegreeCurricularPlan());
        result.setPaymentPlanOrder(this.getPaymentPlanOrder());
        result.setTuitionPaymentPlan(tuitionPaymentPlan);
        result.checkRules();
        return result;
    }

    public static Stream<TuitionPaymentPlanOrder> findAll() {
        return FenixFramework.getDomainRoot().getTuitionPaymentPlansOrderSet().stream();
    }

    public static Stream<TuitionPaymentPlanOrder> find(DegreeCurricularPlan dcp) {
        return TuitionPaymentPlanOrder.findAll().filter(o -> o.getDegreeCurricularPlan() == dcp);
    }

    static {
        advice$orderUp = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$orderDown = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_PAYMENT_PLAN_ORDER = (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getPaymentPlanOrder() < o2.getPaymentPlanOrder() ? -1 : 1;
        };
    }
}

