/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff$callable$edit;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionInstallmentTariff
extends TuitionInstallmentTariff_Base {
    public static final Comparator<? super TuitionInstallmentTariff> COMPARATOR_BY_INSTALLMENT_NUMBER;
    public static final Advice advice$edit;

    protected TuitionInstallmentTariff() {
    }

    protected TuitionInstallmentTariff(FinantialEntity finantialEntity, TuitionPaymentPlan tuitionPaymentPlan, AcademicTariffBean bean) {
        this();
        this.init(finantialEntity, tuitionPaymentPlan, bean);
    }

    public TuitionInstallmentTariff(TuitionInstallmentTariff t, TuitionPaymentPlan copyOfTuitionPaymentPlan) {
        this();
        this.setTuitionPaymentPlan(copyOfTuitionPaymentPlan);
        this.init(t);
    }

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        throw new RuntimeException("wrong call");
    }

    protected void init(FinantialEntity finantialEntity, TuitionPaymentPlan tuitionPaymentPlan, AcademicTariffBean bean) {
        Product product = bean.getTuitionInstallmentProduct();
        if (product == null && (tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForStandalone() || tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForExtracurricular())) {
            product = tuitionPaymentPlan.getProduct();
        }
        super.init(finantialEntity, product, bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getEndDate() != null ? bean.getEndDate().toDateTimeAtStartOfDay() : null, bean.getDueDateCalculationType(), bean.getFixedDueDate(), bean.getNumberOfDaysAfterCreationForDueDate(), bean.isApplyInterests(), bean.getInterestType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        super.setTuitionPaymentPlan(tuitionPaymentPlan);
        super.setInstallmentOrder(bean.getInstallmentOrder());
        super.setTuitionCalculationType(bean.getTuitionCalculationType());
        super.setTuitionTariffCalculatedAmountType(bean.getTuitionTariffCalculatedAmountType());
        this.setTuitionTariffCustomCalculator(bean.getTuitionTariffCustomCalculator());
        super.setFixedAmount(bean.getFixedAmount());
        super.setEctsCalculationType(bean.getEctsCalculationType());
        super.setFactor(bean.getFactor());
        super.setTotalEctsOrUnits(bean.getTotalEctsOrUnits());
        super.setAcademicalActBlockingOff(bean.isAcademicalActBlockingOff());
        this.setBlockAcademicActsOnDebt(bean.isBlockAcademicActsOnDebt());
        if (bean.isApplyMaximumAmount()) {
            if (bean.getMaximumAmount() == null || !AcademicTreasuryConstants.isPositive(bean.getMaximumAmount())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.maximum.amount.required", this.getTuitionPaymentPlan().getConditionsDescription());
            }
            this.setMaximumAmount(bean.getMaximumAmount());
        } else {
            this.setMaximumAmount(BigDecimal.ZERO);
        }
        this.checkRules();
    }

    protected void init(TuitionInstallmentTariff tariff) {
        FinantialEntity finantialEntity = tariff.getFinantialEntity();
        Product product = tariff.getProduct();
        ExecutionYear executionYear = this.getTuitionPaymentPlan().getExecutionYear();
        ExecutionYear copiedExecutionYear = tariff.getTuitionPaymentPlan().getExecutionYear();
        int executionYearInterval = executionYear.getAcademicInterval().getStart().getYear() - copiedExecutionYear.getAcademicInterval().getStart().getYear();
        super.init(finantialEntity, product, tariff.getBeginDate().plusYears(executionYearInterval), tariff.getEndDate() != null ? tariff.getEndDate().plusYears(executionYearInterval) : null, tariff.getDueDateCalculationType(), tariff.getFixedDueDate() != null ? tariff.getFixedDueDate().plusYears(executionYearInterval) : null, tariff.getNumberOfDaysAfterCreationForDueDate(), tariff.isApplyInterests(), tariff.getInterestRate() != null ? tariff.getInterestRate().getInterestType() : null, tariff.getInterestRate() != null ? tariff.getInterestRate().getNumberOfDaysAfterDueDate() : 0, tariff.getInterestRate() != null ? tariff.getInterestRate().isApplyInFirstWorkday() : false, tariff.getInterestRate() != null ? tariff.getInterestRate().getMaximumDaysToApplyPenalty() : 0, tariff.getInterestRate() != null ? tariff.getInterestRate().getInterestFixedAmount() : null, tariff.getInterestRate() != null ? tariff.getInterestRate().getRate() : null);
        super.setTuitionTariffCalculatedAmountType(tariff.getTuitionTariffCalculatedAmountType());
        this.setTuitionTariffCustomCalculator(tariff.getTuitionTariffCustomCalculator());
        super.setInstallmentOrder(tariff.getInstallmentOrder());
        super.setTuitionCalculationType(tariff.getTuitionCalculationType());
        super.setFixedAmount(tariff.getFixedAmount());
        super.setEctsCalculationType(tariff.getEctsCalculationType());
        super.setFactor(tariff.getFactor());
        super.setTotalEctsOrUnits(tariff.getTotalEctsOrUnits());
        super.setAcademicalActBlockingOff(tariff.isAcademicalActBlockingOff());
        super.setBlockAcademicActsOnDebt(tariff.isBlockAcademicActsOnDebt());
        super.setMaximumAmount(tariff.getMaximumAmount());
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getTuitionPaymentPlan() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tuitionPaymentPlan.required", new String[0]);
        }
        if (this.getFinantialEntity() != this.getTuitionPaymentPlan().getFinantialEntity()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.finantialEntity.different.from.payment.plan", new String[0]);
        }
        if (this.getInstallmentOrder() <= 0) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.installmentOrder.must.be.positive", new String[0]);
        }
        if (TuitionInstallmentTariff.find(this.getTuitionPaymentPlan(), this.getInstallmentOrder()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tariff.installment.order.already.exists", new String[0]);
        }
        if (this.getTuitionCalculationType() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tuitionCalculationType.required", new String[0]);
        }
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.ectsCalculationType.required", new String[0]);
        }
        if (this.isFixedAmountRequired() && this.getFixedAmount() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.fixedAmount.required", new String[0]);
        }
        if (this.isFixedAmountRequired() && !this.isPositive(this.getFixedAmount())) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.fixedAmount.must.be.positive", new String[0]);
        }
        if (this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration() && this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.defaultPaymentPlanCourseFunctionCostIndexed.not.supported.for.registrationTuition", new String[0]);
        }
        if (this.isDefaultPaymentPlanDependent()) {
            if (this.getFactor() == null) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.factor.required", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
            if (this.getTotalEctsOrUnits() == null) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.totalEctsOrUnits.required", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
            if (!this.isPositive(this.getFactor())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.factor.must.be.positive", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
            if (!this.isPositive(this.getTotalEctsOrUnits())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.totalEctsOrUnits.must.be.positive", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
        }
        if (this.isAcademicalActBlockingOff() && this.isBlockAcademicActsOnDebt()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.cannot.suspend.and.also.block.academical.acts.on.debt.detailed", this.getProduct().getName().getContent());
        }
    }

    private boolean isFixedAmountRequired() {
        return !(this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType() != null && this.getEctsCalculationType().isDependentOnDefaultPaymentPlan() || this.getTuitionCalculationType().isCalculatedAmount() && this.getTuitionTariffCalculatedAmountType() != null && !this.getTuitionTariffCalculatedAmountType().isCaptive());
    }

    private boolean isTuitionCalculationByEctsOrUnits() {
        return this.getTuitionCalculationType().isEcts() || this.getTuitionCalculationType().isUnits();
    }

    public boolean isDefaultPaymentPlanDependent() {
        return this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType() != null && this.getEctsCalculationType().isDependentOnDefaultPaymentPlan();
    }

    public boolean isDefaultPaymentPlanDefined() {
        return this.getTuitionPaymentPlan().getTuitionPaymentPlanOrdersSet().stream().map(order -> order.getDegreeCurricularPlan()).allMatch(dcp -> TuitionPaymentPlan.isDefaultPaymentPlanDefined(dcp, this.getTuitionPaymentPlan().getExecutionYear()));
    }

    public boolean isAcademicalActBlockingOff() {
        return super.getAcademicalActBlockingOff();
    }

    public boolean isBlockAcademicActsOnDebt() {
        return super.getBlockAcademicActsOnDebt();
    }

    public boolean isApplyMaximumAmount() {
        return this.getMaximumAmount() != null && this.isPositive(this.getMaximumAmount());
    }

    public BigDecimal getAmountPerEctsOrUnit(DegreeCurricularPlan dcp) {
        if (this.getTuitionCalculationType().isFixedAmount()) {
            throw new RuntimeException("invalid call");
        }
        if (this.getEctsCalculationType().isFixedAmount()) {
            return this.getFixedAmount();
        }
        if (!this.isDefaultPaymentPlanDefined()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.default.payment.plan.not.defined", new String[0]);
        }
        TuitionPaymentPlan defaultPaymentPlan = TuitionPaymentPlan.findUniqueDefaultPaymentPlan(dcp, this.getTuitionPaymentPlan().getExecutionYear()).get();
        return AcademicTreasuryConstants.divide(AcademicTreasuryConstants.defaultScale(defaultPaymentPlan.tuitionTotalAmount()).multiply(this.getFactor()), this.getTotalEctsOrUnits());
    }

    private BigDecimal getAmountPerEctsOrUnitUsingFunctionCostIndexed(Enrolment enrolment) {
        if (!this.isTuitionCalculationByEctsOrUnits() || !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            throw new RuntimeException("invalid call");
        }
        if (!this.isDefaultPaymentPlanDefined()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.default.payment.plan.not.defined", new String[0]);
        }
        if (!CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).isPresent()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.courseFunctionCourse.not.defined", new String[0]);
        }
        CourseFunctionCost cost = CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).get();
        TuitionPaymentPlan defaultPaymentPlan = TuitionPaymentPlan.findUniqueDefaultPaymentPlan(enrolment.getDegreeCurricularPlanOfDegreeModule(), this.getTuitionPaymentPlan().getExecutionYear()).get();
        return AcademicTreasuryConstants.divide(AcademicTreasuryConstants.defaultScale(defaultPaymentPlan.tuitionTotalAmount()).multiply(this.getFactor()), this.getTotalEctsOrUnits()).multiply(AcademicTreasuryConstants.divide(cost.getFunctionCost(), BigDecimal.TEN).add(BigDecimal.ONE));
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        BigDecimal enrolledEctsUnits = academicTreasuryEvent.getEnrolledEctsUnits();
        BigDecimal enrolledCoursesCount = academicTreasuryEvent.getEnrolledCoursesCount();
        return this.amountToPay(academicTreasuryEvent.getRegistration(), enrolledEctsUnits, enrolledCoursesCount, calculatorsMap);
    }

    public BigDecimal amountToPay(Registration registration, BigDecimal enrolledEctsUnits, BigDecimal enrolledCoursesCount, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amountToPay = null;
        if (this.getTuitionCalculationType().isFixedAmount()) {
            amountToPay = this.getFixedAmount();
        } else if (this.getTuitionCalculationType().isEcts()) {
            amountToPay = enrolledEctsUnits.multiply(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()));
        } else if (this.getTuitionCalculationType().isUnits()) {
            amountToPay = enrolledCoursesCount.multiply(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            BigDecimal customAmount = calculatorsMap.get(this.getTuitionTariffCustomCalculator()).getTotalAmount();
            BigDecimal totalCaptiveAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isCaptive() && tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator())).map(tariff -> tariff.getFixedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal customAmountWithoutCaptive = customAmount.subtract(totalCaptiveAmount);
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                amountToPay = this.getFixedAmount();
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                amountToPay = Currency.getValueWithScale((BigDecimal)this.getFactor().multiply(customAmountWithoutCaptive));
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                BigDecimal totalPercentageAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isPercentage() && tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator())).map(tariff -> Currency.getValueWithScale((BigDecimal)tariff.getFactor().multiply(customAmountWithoutCaptive))).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalTariffAmount = totalCaptiveAmount.add(totalPercentageAmount);
                amountToPay = customAmount.subtract(totalTariffAmount);
            }
        }
        if (amountToPay == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.unknown.amountToPay", new String[0]);
        }
        if (this.isApplyMaximumAmount() && AcademicTreasuryConstants.isGreaterThan(amountToPay, this.getMaximumAmount())) {
            return this.getMaximumAmount();
        }
        return amountToPay;
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent, Enrolment enrolment, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForStandalone() && !this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amountToPay = null;
        if (this.getTuitionCalculationType().isFixedAmount()) {
            amountToPay = this.getFixedAmount();
        } else if (this.getTuitionCalculationType().isUnits() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule());
        } else if (this.getTuitionCalculationType().isEcts() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).multiply(this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule()));
        } else if (this.getTuitionCalculationType().isUnits() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment);
        } else if (this.getTuitionCalculationType().isEcts() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).multiply(this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            BigDecimal customAmount = calculatorsMap.get(this.getTuitionTariffCustomCalculator()).getTotalAmount();
            BigDecimal totalCaptiveAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isCaptive() && tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator())).map(tariff -> tariff.getFixedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal customAmountWithoutCaptive = customAmount.subtract(totalCaptiveAmount);
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                amountToPay = this.getFixedAmount();
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                amountToPay = Currency.getValueWithScale((BigDecimal)this.getFactor().multiply(customAmountWithoutCaptive));
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                BigDecimal totalPercentageAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isPercentage() && tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator())).map(tariff -> Currency.getValueWithScale((BigDecimal)tariff.getFactor().multiply(customAmountWithoutCaptive))).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalTariffAmount = totalCaptiveAmount.add(totalPercentageAmount);
                amountToPay = customAmount.subtract(totalTariffAmount);
            }
        }
        if (amountToPay == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.unknown.amountToPay", new String[0]);
        }
        if (this.isApplyMaximumAmount() && AcademicTreasuryConstants.isGreaterThan(amountToPay, this.getMaximumAmount())) {
            return this.getMaximumAmount();
        }
        return amountToPay;
    }

    public DebitEntry createDebitEntryForRegistration(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap, BigDecimal amountToDiscount) {
        if (amountToDiscount == null) {
            amountToDiscount = BigDecimal.ZERO;
        }
        if (TreasuryConstants.isNegative((BigDecimal)amountToDiscount)) {
            throw new RuntimeException("invalid amount to discount");
        }
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, calculatorsMap).subtract(amountToDiscount);
        if (TreasuryConstants.isNegative((BigDecimal)amount)) {
            throw new RuntimeException("invalid tuition installment amount");
        }
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForRegistration(academicTreasuryEvent, dueDate, when, calculatorsMap);
        DebitEntry debitEntry = DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.installmentName(academicTreasuryEvent.getRegistration()).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
        if (this.isAcademicalActBlockingOff()) {
            debitEntry.markAcademicalActBlockingSuspension();
        }
        if (this.isBlockAcademicActsOnDebt()) {
            debitEntry.markBlockAcademicActsOnDebt();
        }
        if (this.getTuitionPaymentPlan().isPayorDebtAccountDefined()) {
            debitEntry.setPayorDebtAccount(this.getTuitionPaymentPlan().getPayorDebtAccount());
        }
        return debitEntry;
    }

    public DebitEntry createDebitEntryForStandalone(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment standaloneEnrolment, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForStandalone()) {
            throw new RuntimeException("wrong call");
        }
        if (!standaloneEnrolment.isStandalone()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.standalone");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, standaloneEnrolment, calculatorsMap);
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForStandaloneOrExtracurricular(academicTreasuryEvent, standaloneEnrolment, dueDate, calculatorsMap);
        DebitEntry debitEntry = DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.standaloneDebitEntryName(standaloneEnrolment).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
        academicTreasuryEvent.associateEnrolment(debitEntry, standaloneEnrolment);
        return debitEntry;
    }

    public DebitEntry createDebitEntryForExtracurricular(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment extracurricularEnrolment, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        if (!extracurricularEnrolment.isExtraCurricular()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.extracurricular");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, extracurricularEnrolment, calculatorsMap);
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForStandaloneOrExtracurricular(academicTreasuryEvent, extracurricularEnrolment, dueDate, calculatorsMap);
        DebitEntry debitEntry = DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.extracurricularDebitEntryName(extracurricularEnrolment).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
        academicTreasuryEvent.associateEnrolment(debitEntry, extracurricularEnrolment);
        return debitEntry;
    }

    private void updatePriceValuesInEvent(AcademicTreasuryEvent academicTreasuryEvent) {
    }

    public LocalizedString installmentName(Registration registration) {
        return this.getTuitionPaymentPlan().installmentName(registration, this);
    }

    public LocalizedString standaloneDebitEntryName(Enrolment standaloneEnrolment) {
        if (!standaloneEnrolment.isStandalone()) {
            throw new RuntimeException("wrong call");
        }
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            result = result.with(locale, AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.standalone.debit.entry.name", academicTreasuryServices.localizedNameOfEnrolment(standaloneEnrolment, locale), standaloneEnrolment.getExecutionPeriod().getQualifiedName(), new BigDecimal(standaloneEnrolment.getCurricularCourse().getEctsCredits()).toString()));
        }
        return result;
    }

    public LocalizedString extracurricularDebitEntryName(Enrolment extracurricularEnrolment) {
        if (!extracurricularEnrolment.isExtraCurricular()) {
            throw new RuntimeException("wrong call");
        }
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            result = result.with(locale, AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.extracurricular.debit.entry.name", academicTreasuryServices.localizedNameOfEnrolment(extracurricularEnrolment, locale), extracurricularEnrolment.getExecutionPeriod().getQualifiedName(), new BigDecimal(extracurricularEnrolment.getCurricularCourse().getEctsCredits()).toString()));
        }
        return result;
    }

    public Vat vat(LocalDate when) {
        return (Vat)Vat.findActiveUnique((VatType)this.getProduct().getVatType(), (FinantialInstitution)this.getFinantialEntity().getFinantialInstitution(), (DateTime)when.toDateTimeAtStartOfDay()).get();
    }

    private Map<String, String> fillPricePropertiesForStandaloneOrExtracurricular(AcademicTreasuryEvent academicTreasuryEvent, Enrolment enrolment, LocalDate dueDate, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForStandalone() && !this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ENROLMENT.getDescriptionI18N().getContent(), academicTreasuryServices.localizedNameOfEnrolment(enrolment, AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), enrolment.getCurricularCourse().getDegreeCurricularPlan().getName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), enrolment.getCurricularCourse().getDegree().getPresentationName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), enrolment.getCurricularCourse().getDegree().getCode());
        if (this.getTuitionCalculationType().isFixedAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FIXED_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getFixedAmount()));
        } else if (this.getTuitionCalculationType().isEcts() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ECTS_CREDITS.getDescriptionI18N().getContent(), new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_ECTS.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isUnits() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_COURSE.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isEcts() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            TuitionPaymentPlan defaultPaymentPlan = TuitionPaymentPlan.findUniqueDefaultPaymentPlan(enrolment.getDegreeCurricularPlanOfDegreeModule(), this.getTuitionPaymentPlan().getExecutionYear()).get();
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEFAULT_TUITION_TOTAL_AMOUNT.getDescriptionI18N().getContent(), defaultPaymentPlan.tuitionTotalAmount().toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ECTS_CREDITS.getDescriptionI18N().getContent(), new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_ECTS.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            CourseFunctionCost cost = CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).get();
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.COURSE_FUNCTION_COST.getDescriptionI18N().getContent(), cost.getFunctionCost().toPlainString());
        } else if (this.getTuitionCalculationType().isUnits() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_COURSE.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            CourseFunctionCost cost = CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).get();
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.COURSE_FUNCTION_COST.getDescriptionI18N().getContent(), cost.getFunctionCost().toPlainString());
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CUSTOM_CALCULATOR.getDescriptionI18N().getContent(), this.getTuitionTariffCustomCalculator().getSimpleName());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_AMOUNT_TYPE.getDescriptionI18N().getContent(), this.getTuitionTariffCalculatedAmountType().getDescriptionI18N().getContent());
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            }
        }
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType().isDependentOnDefaultPaymentPlan()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TOTAL_ECTS_OR_UNITS.getDescriptionI18N().getContent(), this.getTotalEctsOrUnits().toPlainString());
        }
        if (this.isApplyMaximumAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.MAXIMUM_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getMaximumAmount()));
        }
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DUE_DATE.getDescriptionI18N().getContent(), dueDate.toString("dd/MM/yyyy"));
        return propertiesMap;
    }

    public Map<String, String> fillPricePropertiesForRegistration(AcademicTreasuryEvent event, LocalDate dueDate, LocalDate usedDate, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_CALCULATION_TYPE.getDescriptionI18N().getContent(), this.getTuitionCalculationType().getDescriptionI18N().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN_CONDITIONS.getDescriptionI18N().getContent(), this.getTuitionPaymentPlan().getConditionsDescription());
        if (this.getTuitionPaymentPlan().getPayorDebtAccount() != null) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYOR_DEBT_ACCOUNT.getDescriptionI18N().getContent(), this.getTuitionPaymentPlan().getPayorDebtAccount().getCustomer().getUiFiscalNumber());
        }
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = event.getTuitionPaymentPlanGroup();
        Registration registration = event.getRegistration();
        ExecutionYear executionYear = event.getExecutionYear();
        if (this.getTuitionCalculationType().isFixedAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FIXED_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getFixedAmount()));
        } else if (this.getTuitionCalculationType().isEcts()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ECTS_CREDITS.getDescriptionI18N().getContent(), AcademicTreasuryEvent.getEnrolledEctsUnits(tuitionPaymentPlanGroup, registration, executionYear).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_ECTS.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isUnits()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ENROLLED_COURSES.getDescriptionI18N().getContent(), AcademicTreasuryEvent.getEnrolledCoursesCount(tuitionPaymentPlanGroup, registration, executionYear).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_COURSE.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CUSTOM_CALCULATOR.getDescriptionI18N().getContent(), this.getTuitionTariffCustomCalculator().getSimpleName());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_AMOUNT_TYPE.getDescriptionI18N().getContent(), this.getTuitionTariffCalculatedAmountType().getDescriptionI18N().getContent());
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
            }
        }
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType().isDefaultPaymentPlanIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TOTAL_ECTS_OR_UNITS.getDescriptionI18N().getContent(), this.getTotalEctsOrUnits().toPlainString());
        }
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.USED_DATE.getDescriptionI18N().getContent(), usedDate.toString("dd/MM/yyyy"));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DUE_DATE.getDescriptionI18N().getContent(), dueDate.toString("dd/MM/yyyy"));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), event.getRegistration().getDegree().getCode());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), event.getRegistration().getDegree().getPresentationName(event.getExecutionYear()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), event.getRegistration().getDegreeCurricularPlanName());
        if (this.isApplyMaximumAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.MAXIMUM_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getMaximumAmount()));
        }
        return propertiesMap;
    }

    public void edit(AcademicTariffBean academicTariffBean) {
        Object object = advice$edit.perform((Callable)new TuitionInstallmentTariff$callable$edit(this, academicTariffBean));
    }

    static /* synthetic */ void advised$edit(TuitionInstallmentTariff this_, AcademicTariffBean bean) {
        if (this_.getInterestRate() == null && bean.isApplyInterests()) {
            this_.setInterestRate(InterestRate.createForTariff((Tariff)this_, (InterestType)bean.getInterestType(), (int)bean.getNumberOfDaysAfterCreationForDueDate(), (boolean)bean.isApplyInFirstWorkday(), (int)bean.getMaximumDaysToApplyPenalty(), (BigDecimal)bean.getInterestFixedAmount(), (BigDecimal)bean.getRate()));
        } else if (this_.getInterestRate() != null && !bean.isApplyInterests()) {
            this_.getInterestRate().delete();
        } else if (this_.getInterestRate() != null && bean.isApplyInterests()) {
            this_.getInterestRate().edit(bean.getInterestType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        }
        super.setBeginDate(bean.getBeginDate().toDateTimeAtStartOfDay());
        super.setEndDate(bean.getEndDate() != null ? bean.getEndDate().toDateTimeAtStartOfDay() : null);
        super.setTuitionTariffCalculatedAmountType(bean.getTuitionTariffCalculatedAmountType());
        super.setTuitionTariffCustomCalculatorClassName(bean.getTuitionTariffCustomCalculator() != null ? bean.getTuitionTariffCustomCalculator().getName() : null);
        this_.setDueDateCalculationType(bean.getDueDateCalculationType());
        this_.setFixedDueDate(bean.getFixedDueDate());
        super.setNumberOfDaysAfterCreationForDueDate(bean.getNumberOfDaysAfterCreationForDueDate());
        super.setApplyInterests(bean.isApplyInterests());
        super.setTuitionCalculationType(bean.getTuitionCalculationType());
        super.setFixedAmount(bean.getFixedAmount());
        super.setEctsCalculationType(bean.getEctsCalculationType());
        super.setFactor(bean.getFactor());
        super.setTotalEctsOrUnits(bean.getTotalEctsOrUnits());
        super.setAcademicalActBlockingOff(bean.isAcademicalActBlockingOff());
        super.setBlockAcademicActsOnDebt(bean.isBlockAcademicActsOnDebt());
        if (bean.isApplyMaximumAmount()) {
            if (bean.getMaximumAmount() == null || !AcademicTreasuryConstants.isPositive(bean.getMaximumAmount())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.maximum.amount.required", this_.getTuitionPaymentPlan().getConditionsDescription());
            }
            super.setMaximumAmount(bean.getMaximumAmount());
        } else {
            this_.setMaximumAmount(BigDecimal.ZERO);
        }
        this_.checkRules();
    }

    public void delete() {
        super.setTuitionPaymentPlan(null);
        super.delete();
    }

    public BigDecimal amountToPay() {
        throw new RuntimeException("not supported");
    }

    public boolean isBroadTariffForFinantialEntity() {
        return false;
    }

    protected static Stream<TuitionInstallmentTariff> find(TuitionPaymentPlan tuitionPaymentPlan, int installmentOrder) {
        return tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().filter(t -> t.getInstallmentOrder() == installmentOrder);
    }

    public static Optional<TuitionInstallmentTariff> findUnique(TuitionPaymentPlan tuitionPaymentPlan, int installmentOrder) {
        return TuitionInstallmentTariff.find(tuitionPaymentPlan, installmentOrder).findFirst();
    }

    public static TuitionInstallmentTariff create(FinantialEntity finantialEntity, TuitionPaymentPlan tuitionPaymentPlan, AcademicTariffBean bean) {
        return new TuitionInstallmentTariff(finantialEntity, tuitionPaymentPlan, bean);
    }

    public static TuitionInstallmentTariff copy(TuitionInstallmentTariff tuitionInstallmentTariffToCopy, TuitionPaymentPlan copyOfTuitionPaymentPlan) {
        return new TuitionInstallmentTariff(tuitionInstallmentTariffToCopy, copyOfTuitionPaymentPlan);
    }

    public Class<? extends TuitionTariffCustomCalculator> getTuitionTariffCustomCalculator() {
        try {
            return this.getTuitionTariffCustomCalculatorClassName() == null ? null : Class.forName(this.getTuitionTariffCustomCalculatorClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void setTuitionTariffCustomCalculator(Class<? extends TuitionTariffCustomCalculator> clazz) {
        this.setTuitionTariffCustomCalculatorClassName(clazz != null ? clazz.getName() : "");
    }

    public void setFixedDueDate(LocalDate fixedDueDate) {
        if (this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) {
            super.setFixedDueDate(fixedDueDate);
        } else {
            super.setFixedDueDate(null);
        }
    }

    public void setDueDateCalculationType(DueDateCalculationType dueDateCalculationType) {
        super.setDueDateCalculationType(dueDateCalculationType);
        if (!dueDateCalculationType.isBestOfFixedDateAndDaysAfterCreation()) {
            this.setFixedDueDate(null);
        }
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_INSTALLMENT_NUMBER = (o1, o2) -> {
            int c = Integer.compare(o1.getInstallmentOrder(), o2.getInstallmentOrder());
            return c != 0 ? c : DomainObjectUtil.COMPARATOR_BY_ID.compare(o1, o2);
        };
    }
}

