/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.paymentpenalty;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.paymentpenalty.PaymentPenaltyEventTarget$callable$delete;
import org.fenixedu.academictreasury.domain.paymentpenalty.PaymentPenaltyEventTarget_Base;
import org.fenixedu.academictreasury.domain.paymentpenalty.PaymentPenaltySettings;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class PaymentPenaltyEventTarget
extends PaymentPenaltyEventTarget_Base
implements IAcademicTreasuryTarget {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PaymentPenaltyEventTarget() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected PaymentPenaltyEventTarget(DebitEntry originDebitEntry) {
        this();
        this.setOriginDebitEntry(originDebitEntry);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new IllegalStateException("error.PaymentPenaltyEventTarget.domainRoot.required");
        }
        if (this.getOriginDebitEntry() == null) {
            throw new IllegalStateException("error.PaymentPenaltyEventTarget.originDebitEntry.required");
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentPenaltyEventTarget$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentPenaltyEventTarget this_) {
        this_.setDomainRoot(null);
        this_.setOriginDebitEntry(null);
        super.deleteDomainObject();
    }

    public Degree getAcademicTreasuryTargetDegree() {
        if (this.getOriginDebitEntry().getTreasuryEvent() != null && this.getOriginDebitEntry().getTreasuryEvent() instanceof AcademicTreasuryEvent) {
            AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)this.getOriginDebitEntry().getTreasuryEvent();
            if (academicTreasuryEvent.getRegistration() != null) {
                return academicTreasuryEvent.getRegistration().getDegree();
            }
            return academicTreasuryEvent.getDegree();
        }
        return null;
    }

    public LocalizedString getAcademicTreasuryTargetDescription() {
        return PaymentPenaltySettings.getInstance().buildEmolumentDescription(this);
    }

    public LocalDate getAcademicTreasuryTargetEventDate() {
        return super.getOriginDebitEntry().getLastPaymentDate().toLocalDate();
    }

    public ExecutionInterval getAcademicTreasuryTargetExecutionSemester() {
        return null;
    }

    public ExecutionYear getAcademicTreasuryTargetExecutionYear() {
        if (this.getOriginDebitEntry().getTreasuryEvent() != null && this.getOriginDebitEntry().getTreasuryEvent() instanceof AcademicTreasuryEvent) {
            return ((AcademicTreasuryEvent)this.getOriginDebitEntry().getTreasuryEvent()).getExecutionYear();
        }
        return null;
    }

    public Person getAcademicTreasuryTargetPerson() {
        if (this.getOriginDebitEntry().getDebtAccount().getCustomer().isPersonCustomer()) {
            return ((PersonCustomer)this.getOriginDebitEntry().getDebtAccount().getCustomer()).getAssociatedPerson();
        }
        throw new IllegalStateException("error.PaymentPenaltyEventTarget.person.not.found");
    }

    public Map<String, String> getAcademicTreasuryTargetPropertiesMap() {
        return Collections.emptyMap();
    }

    public Registration getAcademicTreasuryTargetRegistration() {
        if (this.getOriginDebitEntry().getTreasuryEvent() != null && this.getOriginDebitEntry().getTreasuryEvent() instanceof AcademicTreasuryEvent) {
            return ((AcademicTreasuryEvent)this.getOriginDebitEntry().getTreasuryEvent()).getRegistration();
        }
        return null;
    }

    public void handleTotalPayment(IAcademicTreasuryEvent event) {
    }

    public static PaymentPenaltyEventTarget create(DebitEntry originDebitEntry) {
        throw new RuntimeException("deprecated");
    }

    public static Stream<PaymentPenaltyEventTarget> findAll() {
        return FenixFramework.getDomainRoot().getPaymentPenaltyEventTargetsSet().stream();
    }

    public static Optional<PaymentPenaltyEventTarget> findUnique(DebitEntry originDebitEntry) {
        return Optional.ofNullable(originDebitEntry.getPaymentPenaltyEventTarget());
    }
}

