/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.forwardpayments.implementations.onlinepaymentsgateway.sibs;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.forwardpayments.implementations.onlinepaymentsgateway.sibs.SibsOnlinePaymentsGatewayForwardImplementation$callable$prepareCheckout;
import org.fenixedu.onlinepaymentsgateway.api.CheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsResultCodeType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsBillingAddressBean;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsOnlinePaymentsGatewayForwardImplementation
implements IForwardPaymentImplementation {
    private static final String ERROR_UNEXPECTED_NUMBER_TRANSACTIONS_BY_MERCHANT_TRANSACTION_ID = "error.SibsOnlinePaymentsGatewayForwardImplementation.paymentStatus.unexpected.number.transactions.by.merchantTransactionId";
    public static final String ONLINE_PAYMENTS_GATEWAY = "ONLINE-PAYMENTS-GATEWAY";
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway/returnforwardpayment";
    public static final Advice advice$prepareCheckout = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

    public IForwardPaymentController getForwardPaymentController(ForwardPayment forwardPayment) {
        return null;
    }

    public String getPaymentURL(ForwardPayment forwardPayment) {
        return forwardPayment.getForwardPaymentConfiguration().getPaymentURL() + "/paymentWidgets.js?checkoutId=" + forwardPayment.getSibsCheckoutId();
    }

    public String getFormattedAmount(ForwardPayment forwardPayment) {
        return null;
    }

    public String getLogosJspPage(ForwardPaymentConfiguration forwardPaymentConfiguration) {
        return forwardPaymentConfiguration.getLogosJspPageFile();
    }

    public String getWarningBeforeRedirectionJspPage() {
        return null;
    }

    public String getReturnURL(ForwardPayment forwardPayment) {
        return String.format("%s%s/%s", forwardPayment.getForwardPaymentConfiguration().getReturnURL(), RETURN_FORWARD_PAYMENT_URL, forwardPayment.getExternalId());
    }

    public ForwardPaymentStatusBean prepareCheckout(ForwardPayment forwardPayment, SibsBillingAddressBean sibsBillingAddressBean) {
        return (ForwardPaymentStatusBean)advice$prepareCheckout.perform((Callable)new SibsOnlinePaymentsGatewayForwardImplementation$callable$prepareCheckout(this, forwardPayment, sibsBillingAddressBean));
    }

    static /* synthetic */ ForwardPaymentStatusBean advised$prepareCheckout(SibsOnlinePaymentsGatewayForwardImplementation this_, ForwardPayment forwardPayment, SibsBillingAddressBean addressBean) {
        SibsOnlinePaymentsGateway gateway = forwardPayment.getForwardPaymentConfiguration().getSibsOnlinePaymentsGateway();
        String merchantTransactionId = gateway.generateNewMerchantTransactionId();
        FenixFramework.atomic(() -> {
            if (!StringUtils.isEmpty((String)forwardPayment.getSibsMerchantTransactionId())) {
                throw new AcademicTreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.sibsMerchantTransactionId.already.filled", new String[0]);
            }
            forwardPayment.setSibsMerchantTransactionId(merchantTransactionId);
        });
        try {
            CheckoutResultBean checkoutBean = gateway.prepareCheckout(forwardPayment.getDebtAccount(), merchantTransactionId, forwardPayment.getAmount(), this_.getReturnURL(forwardPayment), addressBean);
            ForwardPaymentStateType type = this_.translateForwardPaymentStateType(checkoutBean.getOperationResultType(), false);
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(checkoutBean.isOperationSuccess(), type, checkoutBean.getPaymentGatewayResultCode(), checkoutBean.getPaymentGatewayResultDescription(), checkoutBean.getRequestLog(), checkoutBean.getResponseLog());
            FenixFramework.atomic(() -> forwardPayment.setSibsCheckoutId(checkoutBean.getCheckoutId()));
            FenixFramework.atomic(() -> {
                if (!result.isInvocationSuccess() || result.getStateType() == ForwardPaymentStateType.REJECTED) {
                    forwardPayment.reject(checkoutBean.getPaymentGatewayResultCode(), checkoutBean.getPaymentGatewayResultDescription(), checkoutBean.getRequestLog(), checkoutBean.getResponseLog());
                } else {
                    forwardPayment.advanceToRequestState(checkoutBean.getPaymentGatewayResultCode(), checkoutBean.getPaymentGatewayResultDescription(), checkoutBean.getRequestLog(), checkoutBean.getResponseLog());
                }
            });
            result.defineSibsOnlinePaymentBrands(checkoutBean.getPaymentBrands());
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                forwardPayment.logException(e, requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public ForwardPaymentStatusBean paymentStatusByCheckoutId(ForwardPayment forwardPayment) {
        SibsOnlinePaymentsGateway gateway = forwardPayment.getForwardPaymentConfiguration().getSibsOnlinePaymentsGateway();
        try {
            PaymentStateBean paymentStateBean = gateway.getPaymentStatusBySibsCheckoutId(forwardPayment.getSibsCheckoutId());
            String requestLog = paymentStateBean.getRequestLog();
            String responseLog = paymentStateBean.getResponseLog();
            ForwardPaymentStateType type = this.translateForwardPaymentStateType(paymentStateBean.getOperationResultType(), paymentStateBean.isPaid());
            ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(paymentStateBean.isOperationSuccess(), type, paymentStateBean.getPaymentGatewayResultCode(), paymentStateBean.getPaymentGatewayResultDescription(), requestLog, responseLog);
            bean.editTransactionDetails(paymentStateBean.getTransactionId(), paymentStateBean.getPaymentDate(), paymentStateBean.getAmount());
            return bean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                forwardPayment.logException(e, requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public ForwardPaymentStatusBean paymentStatus(ForwardPayment forwardPayment) {
        SibsOnlinePaymentsGateway gateway = forwardPayment.getForwardPaymentConfiguration().getSibsOnlinePaymentsGateway();
        try {
            PaymentStateBean paymentStateBean = null;
            if (!StringUtils.isEmpty((String)forwardPayment.getSibsTransactionId())) {
                paymentStateBean = gateway.getPaymentStatusBySibsTransactionId(forwardPayment.getSibsTransactionId());
            } else {
                List paymentStateBeanList = gateway.getPaymentTransactionsReportListByMerchantId(forwardPayment.getSibsMerchantTransactionId());
                if (paymentStateBeanList.size() != 1) {
                    throw new TreasuryDomainException(ERROR_UNEXPECTED_NUMBER_TRANSACTIONS_BY_MERCHANT_TRANSACTION_ID, new String[0]);
                }
                paymentStateBean = (PaymentStateBean)paymentStateBeanList.get(0);
            }
            String requestLog = paymentStateBean.getRequestLog();
            String responseLog = paymentStateBean.getResponseLog();
            ForwardPaymentStateType type = this.translateForwardPaymentStateType(paymentStateBean.getOperationResultType(), paymentStateBean.isPaid());
            ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(paymentStateBean.isOperationSuccess(), type, paymentStateBean.getPaymentGatewayResultCode(), paymentStateBean.getPaymentGatewayResultDescription(), requestLog, responseLog);
            bean.editTransactionDetails(paymentStateBean.getTransactionId(), paymentStateBean.getPaymentDate(), paymentStateBean.getAmount());
            return bean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                if (!ERROR_UNEXPECTED_NUMBER_TRANSACTIONS_BY_MERCHANT_TRANSACTION_ID.equals(e.getMessage())) {
                    forwardPayment.logException(e, requestBody, responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private ForwardPaymentStateType translateForwardPaymentStateType(SibsResultCodeType operationResultType, boolean paid) {
        if (operationResultType == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.unknown.payment.state", new String[0]);
        }
        if (paid) {
            if (operationResultType != SibsResultCodeType.SUCCESSFUL_TRANSACTION && operationResultType != SibsResultCodeType.SUCESSFUL_PROCESSED_TRANSACTION_FOR_REVIEW) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.payment.appears.paid.but.inconsistent.with.result.code", new String[0]);
            }
            return ForwardPaymentStateType.PAYED;
        }
        if (operationResultType == SibsResultCodeType.PENDING_TRANSACTION) {
            return ForwardPaymentStateType.REQUESTED;
        }
        return ForwardPaymentStateType.REJECTED;
    }

    public PostProcessPaymentStatusBean postProcessPayment(ForwardPayment forwardPayment, String justification, Optional<String> specificTransactionId) {
        if (!specificTransactionId.isPresent()) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.postProcessPayment.specificTransactionId.required", new String[0]);
        }
        String transactionId = specificTransactionId.get();
        ForwardPaymentStateType previousState = forwardPayment.getCurrentState();
        List<ForwardPaymentStatusBean> paymentStatusBeanList = this.verifyPaymentStatus(forwardPayment);
        Optional<ForwardPaymentStatusBean> optionalPaymentStatusBean = paymentStatusBeanList.stream().filter(bean -> transactionId.equals(bean.getTransactionId())).findFirst();
        if (optionalPaymentStatusBean.isPresent()) {
            if (StringUtils.isEmpty((String)forwardPayment.getTransactionId()) && paymentStatusBeanList.size() == 1) {
                FenixFramework.atomic(() -> forwardPayment.setSibsTransactionId(((ForwardPaymentStatusBean)optionalPaymentStatusBean.get()).getTransactionId()));
            }
            ForwardPaymentStatusBean paymentStatusBean = optionalPaymentStatusBean.get();
            if (!forwardPayment.getCurrentState().isInStateToPostProcessPayment()) {
                throw new TreasuryDomainException("error.ManageForwardPayments.forwardPayment.not.created.nor.requested", new String[]{String.valueOf(forwardPayment.getOrderNumber())});
            }
            if (Strings.isNullOrEmpty((String)justification)) {
                throw new TreasuryDomainException("label.ManageForwardPayments.postProcessPayment.justification.required", new String[0]);
            }
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(paymentStatusBean.getStateType())) {
                return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
            }
            boolean success = paymentStatusBean.isInPayedState();
            if (!paymentStatusBean.isInvocationSuccess()) {
                throw new TreasuryDomainException("error.ManageForwardPayments.postProcessPayment.invocation.unsucessful", new String[]{String.valueOf(forwardPayment.getOrderNumber())});
            }
            if (success) {
                FenixFramework.atomic(() -> forwardPayment.advanceToPayedState(paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getPayedAmount(), paymentStatusBean.getTransactionDate(), paymentStatusBean.getTransactionId(), paymentStatusBean.getAuthorizationNumber(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody(), justification));
            } else {
                FenixFramework.atomic(() -> forwardPayment.reject(paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody()));
            }
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, true);
        }
        return null;
    }

    public String getImplementationCode() {
        return ONLINE_PAYMENTS_GATEWAY;
    }

    public List<ForwardPaymentStatusBean> verifyPaymentStatus(ForwardPayment forwardPayment) {
        SibsOnlinePaymentsGateway gateway = forwardPayment.getForwardPaymentConfiguration().getSibsOnlinePaymentsGateway();
        try {
            String sibsMerchantTransactionId = forwardPayment.getSibsMerchantTransactionId();
            List paymentStateBeanList = gateway.getPaymentTransactionsReportListByMerchantId(sibsMerchantTransactionId);
            ArrayList result = Lists.newArrayList();
            for (PaymentStateBean paymentStateBean : paymentStateBeanList) {
                String requestLog = paymentStateBean.getRequestLog();
                String responseLog = paymentStateBean.getResponseLog();
                ForwardPaymentStateType type = this.translateForwardPaymentStateType(paymentStateBean.getOperationResultType(), paymentStateBean.isPaid());
                ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(paymentStateBean.isOperationSuccess(), type, paymentStateBean.getPaymentGatewayResultCode(), paymentStateBean.getPaymentGatewayResultDescription(), requestLog, responseLog);
                bean.editTransactionDetails(paymentStateBean.getTransactionId(), paymentStateBean.getPaymentDate(), paymentStateBean.getAmount());
                result.add(bean);
            }
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                forwardPayment.logException(e, requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }
}

