/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.exemptions.requests;

import java.math.BigDecimal;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;

public class ExemptionsGenerationRowResult {
    private int rowNum;
    private Registration registration;
    private ExecutionYear executionYear;
    private TreasuryEvent treasuryEvent;
    private DebitEntry debitEntry;
    private BigDecimal amountToExempt;
    private String reason;
    private SortedSet<Integer> tuitionInstallmentsOrderSet;

    public ExemptionsGenerationRowResult(int rowNum, Registration registration, ExecutionYear executionYear, TreasuryEvent treasuryEvent, DebitEntry debitEntry, BigDecimal amountToExempt, String reason, SortedSet<Integer> tuitionInstallmentsOrderSet) {
        this.rowNum = rowNum;
        this.registration = registration;
        this.executionYear = executionYear;
        this.treasuryEvent = treasuryEvent;
        this.debitEntry = debitEntry;
        this.amountToExempt = amountToExempt;
        this.reason = reason;
        this.tuitionInstallmentsOrderSet = tuitionInstallmentsOrderSet;
    }

    public BigDecimal getDiscountAmount() {
        if (this.treasuryEvent instanceof AcademicTreasuryEvent && this.getAcademicTreasuryEvent().isForRegistrationTuition()) {
            throw new RuntimeException("invalid call");
        }
        if (this.debitEntry == null) {
            throw new RuntimeException("debit entry must not be null");
        }
        return this.calculateDebitEntryDiscount(this.debitEntry);
    }

    public BigDecimal getDiscountAmount(int tuitionInstallmentOrder) {
        DebitEntry tuitionDebitEntry = this.getTuitionDebitEntry(tuitionInstallmentOrder);
        if (tuitionDebitEntry == null) {
            throw new RuntimeException("debit entry must not be null");
        }
        return this.calculateDebitEntryDiscount(tuitionDebitEntry);
    }

    public DebitEntry getTuitionDebitEntry(int tuitionInstallmentOrder) {
        Set debitEntriesSet = DebitEntry.findActive((TreasuryEvent)this.getTreasuryEvent()).filter(d -> d.getProduct().getTuitionInstallmentOrder() == tuitionInstallmentOrder).collect(Collectors.toSet());
        if (debitEntriesSet.size() == 0) {
            return null;
        }
        if (debitEntriesSet.size() > 1) {
            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.installmentOrder.debit.entries.found.more.than.one", new String[]{String.valueOf(this.rowNum), String.valueOf(tuitionInstallmentOrder)});
        }
        return (DebitEntry)debitEntriesSet.iterator().next();
    }

    public boolean isTreasuryEventForRegistrationTuition() {
        return this.treasuryEvent instanceof AcademicTreasuryEvent && ((AcademicTreasuryEvent)this.treasuryEvent).isTuitionEvent();
    }

    private BigDecimal calculateDebitEntryDiscount(DebitEntry debitEntry) {
        return this.amountToExempt;
    }

    public AcademicTreasuryEvent getAcademicTreasuryEvent() {
        return (AcademicTreasuryEvent)this.getTreasuryEvent();
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public TreasuryEvent getTreasuryEvent() {
        return this.treasuryEvent;
    }

    public DebitEntry getDebitEntry() {
        return this.debitEntry;
    }

    public BigDecimal getAmountToExempt() {
        return this.amountToExempt;
    }

    public String getReason() {
        return this.reason;
    }

    public SortedSet<Integer> getTuitionInstallmentsOrderSet() {
        return this.tuitionInstallmentsOrderSet;
    }
}

