/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.ExecutionIntervalConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class ExecutionIntervalConditionRule
extends ExecutionIntervalConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof ExecutionIntervalConditionRule)) {
            return false;
        }
        ExecutionIntervalConditionRule rule = (ExecutionIntervalConditionRule)((Object)tuitionConditionRule);
        return this.getExecutionIntervalSet().containsAll(rule.getExecutionIntervalSet());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        Set collect = registration.getEnrolments(executionYear).stream().map(e -> this.academicTreasuryServices().executionSemester((Enrolment)e)).collect(Collectors.toSet());
        if (collect.size() != 1) {
            return false;
        }
        return this.getExecutionIntervalSet().contains(collect.iterator().next());
    }

    private IAcademicTreasuryPlatformDependentServices academicTreasuryServices() {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation();
    }

    public boolean checkRules() {
        if (this.getExecutionIntervalSet() == null || this.getExecutionIntervalSet().isEmpty()) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.executionIntervalConditionRule.executionIntervalSet.cannotBeEmpty", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        return this.getExecutionIntervalSet().stream().sorted(ExecutionInterval.COMPARATOR_BY_BEGIN_DATE).map(c -> c.getName()).collect(Collectors.joining(", "));
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.getExecutionIntervalSet().clear();
        this.setTuitionPaymentPlan(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule copyToPlan(TuitionPaymentPlan tuitionPaymentPlan) {
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        ExecutionIntervalConditionRule result = new ExecutionIntervalConditionRule();
        result.setTuitionPaymentPlan(tuitionPaymentPlan);
        Set executionIntervalOfTuitionPaymentPlanExecutionYear = this.getExecutionIntervalSet().stream().map(c -> tuitionPaymentPlan.getExecutionYear().getExecutionSemesterFor(implementation.executionIntervalChildOrder((ExecutionInterval)c))).collect(Collectors.toSet());
        result.getExecutionIntervalSet().addAll(executionIntervalOfTuitionPaymentPlanExecutionYear);
        return result;
    }

    public TuitionConditionRule duplicate() {
        ExecutionIntervalConditionRule result = new ExecutionIntervalConditionRule();
        this.getExecutionIntervalSet().forEach(c -> result.addExecutionInterval((ExecutionInterval)c));
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        for (String s : split = string.split("\\|")) {
            ExecutionYear b = bean.getExecutionYear();
            ExecutionInterval value = b.getChildIntervals().stream().filter(i -> i.getName().equals(s)).findFirst().orElse(null);
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.addExecutionInterval(value);
        }
    }
}

