/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$cancelRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$create;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$extractInformationForDebitAndCredits;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$extractInformationForPaymentCodes;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$extractInformationForPaymentCodesTransactions;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$extractInformationForSettlements;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$extractOtherTreasuryData;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$processRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$writeReportResultFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultErrorsFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest_Base;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AcademicActBlockingSuspensionReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtAccountReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtReportRequestBean;
import org.fenixedu.academictreasury.dto.reports.PaymentReferenceCodeEntryBean;
import org.fenixedu.academictreasury.dto.reports.PaymentReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.ProductReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.SettlementReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.SibsTransactionDetailEntryBean;
import org.fenixedu.academictreasury.dto.reports.TreasuryExemptionReportEntryBean;
import org.fenixedu.academictreasury.services.debtReports.DebtReportService;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DebtReportRequest
extends DebtReportRequest_Base {
    private static Logger logger;
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final Advice advice$processRequest;
    public static final Advice advice$writeReportResultFile;
    public static final Advice advice$extractInformationForSettlements;
    public static final Advice advice$extractInformationForPaymentCodesTransactions;
    public static final Advice advice$extractInformationForPaymentCodes;
    public static final Advice advice$extractOtherTreasuryData;
    public static final Advice advice$extractInformationForDebitAndCredits;
    public static final Advice advice$cancelRequest;
    public static final Advice advice$create;

    protected DebtReportRequest() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setDomainRootForPendingReportRequests(FenixFramework.getDomainRoot());
    }

    protected DebtReportRequest(DebtReportRequestBean bean) {
        this();
        this.setBeginDate(bean.getBeginDate());
        this.setEndDate(bean.getEndDate());
        this.setType(bean.getType());
        this.setDecimalSeparator(bean.getDecimalSeparator());
        this.setIncludeAnnuledEntries(bean.isIncludeAnnuledEntries());
        this.setIncludeExtraAcademicInfo(bean.isIncludeExtraAcademicInfo());
        this.setIncludeErpIntegrationInfo(bean.isIncludeErpIntegrationInfo());
        this.setIncludeSibsInfo(bean.isIncludeSibsInfo());
        this.setIncludeProductsInfo(bean.isIncludeProductsInfo());
        this.setDegreeType(bean.getDegreeType());
        this.setExecutionYear(bean.getExecutionYear());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getBeginDate() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.beginDate.required", new String[0]);
        }
        if (this.getEndDate() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.endDate.required", new String[0]);
        }
        if (this.getType() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.type.required", new String[0]);
        }
        if (this.getEndDate().isBefore((ReadablePartial)this.getBeginDate())) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.endDate.before.beginDate", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDecimalSeparator()) || !this.getDecimalSeparator().equals(COMMA) && !this.getDecimalSeparator().equals(DOT)) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.decimalSeparator.invalid", new String[0]);
        }
    }

    public boolean isPending() {
        return this.getDomainRootForPendingReportRequests() != null;
    }

    public boolean isIncludeAnnuledEntries() {
        return super.getIncludeAnnuledEntries();
    }

    public boolean isIncludeExtraAcademicInfo() {
        return this.getIncludeExtraAcademicInfo();
    }

    public boolean isIncludeErpIntegrationInfo() {
        return this.getIncludeErpIntegrationInfo();
    }

    public boolean isIncludeSibsInfo() {
        return this.getIncludeSibsInfo();
    }

    public boolean isIncludeProductsInfo() {
        return this.getIncludeProductsInfo();
    }

    public void processRequest() {
        Object object = advice$processRequest.perform((Callable)new DebtReportRequest$callable$processRequest(this));
    }

    static /* synthetic */ void advised$processRequest(DebtReportRequest this_) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        ErrorsLog errorsLog = new ErrorsLog();
        if (this_.getType().isRequestForInvoiceEntries()) {
            executorService.submit(() -> {
                try {
                    this.extractInformationForDebitAndCredits(errorsLog, zos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
            executorService.submit(() -> {
                try {
                    this.extractInformationForSettlements(errorsLog, zos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
            executorService.submit(() -> {
                try {
                    this.extractInformationForPaymentCodesTransactions(errorsLog, zos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
        } else if (this_.getType().isRequestForPaymentReferenceCodes()) {
            executorService.submit(() -> {
                try {
                    this.extractInformationForPaymentCodes(errorsLog, zos);
                    this.extractInformationForPaymentCodesTransactions(errorsLog, zos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
        } else if (this_.getType().isRequestForOtherData()) {
            executorService.submit(() -> {
                try {
                    this.extractOtherTreasuryData(errorsLog, zos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
        }
        executorService.submit(() -> {
            logger.info("writeReportResultFile");
            try {
                zos.close();
                baos.close();
                byte[] contents = baos.toByteArray();
                this.writeReportResultFile(errorsLog, contents);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        executorService.shutdown();
        try {
            logger.info("awaitTermination");
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeReportResultFile(ErrorsLog errorsLog, byte[] byArray) {
        Object object = advice$writeReportResultFile.perform((Callable)new DebtReportRequest$callable$writeReportResultFile(this, errorsLog, byArray));
    }

    static /* synthetic */ void advised$writeReportResultFile(DebtReportRequest this_, ErrorsLog errorsLog, byte[] content) {
        DebtReportRequestResultFile.create(this_, content);
        DebtReportRequestResultErrorsFile.create(this_, errorsLog.getLog().getBytes());
        this_.setDomainRootForPendingReportRequests(null);
    }

    private void extractInformationForSettlements(ErrorsLog errorsLog, ZipOutputStream zipOutputStream) throws IOException {
        Object object = advice$extractInformationForSettlements.perform((Callable)new DebtReportRequest$callable$extractInformationForSettlements(this, errorsLog, zipOutputStream));
    }

    static /* synthetic */ void advised$extractInformationForSettlements(DebtReportRequest this_, final ErrorsLog errorsLog, ZipOutputStream zos) throws IOException {
        logger.info("START extractInformationForSettlements");
        zos.putNextEntry(new ZipEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultFile.SETTLEMENT_ENTRIES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
        logger.info("CREATED extractInformationForSettlements");
        try {
            Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

                public ExcelSheet[] getSheets() {
                    return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.settlementEntriesSheetName(), (String[])SettlementReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.settlementEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.paymentEntriesSheetName(), (String[])PaymentReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.paymentEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.reimbursementEntriesSheetName(), (String[])PaymentReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.reimbursementEntriesReport(DebtReportRequest.this, errorsLog))};
                }
            }, (IErrorsLog)errorsLog, (OutputStream)zos);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        zos.closeEntry();
        logger.info("END extractInformationForSettlements");
    }

    private void extractInformationForPaymentCodesTransactions(ErrorsLog errorsLog, ZipOutputStream zipOutputStream) throws IOException {
        Object object = advice$extractInformationForPaymentCodesTransactions.perform((Callable)new DebtReportRequest$callable$extractInformationForPaymentCodesTransactions(this, errorsLog, zipOutputStream));
    }

    static /* synthetic */ void advised$extractInformationForPaymentCodesTransactions(DebtReportRequest this_, final ErrorsLog errorsLog, ZipOutputStream zos) throws IOException {
        logger.info("START extractInformationForPaymentCodeTransactions");
        zos.putNextEntry(new ZipEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultFile.PAYMENT_CODES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
        Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.sibsTransactionDetailSheetName(), (String[])SibsTransactionDetailEntryBean.SPREADSHEET_HEADERS, DebtReportService.sibsTransactionDetailReport(DebtReportRequest.this, errorsLog))};
            }
        }, (IErrorsLog)errorsLog, (OutputStream)zos);
        zos.closeEntry();
        logger.info("END extractInformationForPaymentCodeTransactions");
    }

    private void extractInformationForPaymentCodes(ErrorsLog errorsLog, ZipOutputStream zipOutputStream) throws IOException {
        Object object = advice$extractInformationForPaymentCodes.perform((Callable)new DebtReportRequest$callable$extractInformationForPaymentCodes(this, errorsLog, zipOutputStream));
    }

    static /* synthetic */ void advised$extractInformationForPaymentCodes(DebtReportRequest this_, final ErrorsLog errorsLog, ZipOutputStream zos) throws IOException {
        logger.info("START extractInformationForPaymentCodes");
        zos.putNextEntry(new ZipEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultFile.PAYMENT_CODES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
        Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.paymentReferenceCodeSheetName(), (String[])PaymentReferenceCodeEntryBean.SPREADSHEET_HEADERS, DebtReportService.paymentReferenceCodeReport(DebtReportRequest.this, errorsLog))};
            }
        }, (IErrorsLog)errorsLog, (OutputStream)zos);
        zos.closeEntry();
        logger.info("END extractInformationForPaymentCodes");
    }

    private void extractOtherTreasuryData(ErrorsLog errorsLog, ZipOutputStream zipOutputStream) throws IOException {
        Object object = advice$extractOtherTreasuryData.perform((Callable)new DebtReportRequest$callable$extractOtherTreasuryData(this, errorsLog, zipOutputStream));
    }

    static /* synthetic */ void advised$extractOtherTreasuryData(DebtReportRequest this_, final ErrorsLog errorsLog, ZipOutputStream zos) throws IOException {
        logger.info("START extractOtherTreasuryData");
        zos.putNextEntry(new ZipEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultFile.OTHER.filename", new DateTime().toString("YYYYMMddHHmmss"))));
        Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.debtAccountEntriesSheetName(), (String[])DebtAccountReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.debtAccountEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.academicActBlockingSuspensionSheetName(), (String[])AcademicActBlockingSuspensionReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.academicActBlockingSuspensionReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.treasuryExemptionSheetName(), (String[])TreasuryExemptionReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.treasuryExemptionReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.productSheetName(), (String[])ProductReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.productReport(DebtReportRequest.this, errorsLog))};
            }
        }, (IErrorsLog)errorsLog, (OutputStream)zos);
        zos.closeEntry();
        logger.info("END extractOtherTreasuryData");
    }

    private void extractInformationForDebitAndCredits(ErrorsLog errorsLog, ZipOutputStream zipOutputStream) throws IOException {
        Object object = advice$extractInformationForDebitAndCredits.perform((Callable)new DebtReportRequest$callable$extractInformationForDebitAndCredits(this, errorsLog, zipOutputStream));
    }

    static /* synthetic */ void advised$extractInformationForDebitAndCredits(DebtReportRequest this_, final ErrorsLog errorsLog, ZipOutputStream zos) throws IOException {
        logger.info("START extractInformationForDebitAndCredits");
        zos.putNextEntry(new ZipEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultFile.INVOICE_ENTRIES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
        logger.info("CREATED extractInformationForDebitAndCredits");
        Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.debitEntriesSheetName(), (String[])DebtReportEntryBean.SPREADSHEET_DEBIT_HEADERS, DebtReportService.debitEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.creditEntriesSheetName(), (String[])DebtReportEntryBean.SPREADSHEET_CREDIT_HEADERS, DebtReportService.creditEntriesReport(DebtReportRequest.this, errorsLog))};
            }

            private String decimalSeparator() {
                if (Strings.isNullOrEmpty((String)DebtReportRequest.this.getDecimalSeparator())) {
                    return DebtReportRequest.DOT;
                }
                return DebtReportRequest.this.getDecimalSeparator();
            }
        }, (IErrorsLog)errorsLog, (OutputStream)zos);
        logger.info("CLOSE extractInformationForDebitAndCredits");
        zos.closeEntry();
        logger.info("END extractInformationForDebitAndCredits");
    }

    public void cancelRequest() {
        Object object = advice$cancelRequest.perform((Callable)new DebtReportRequest$callable$cancelRequest(this));
    }

    static /* synthetic */ void advised$cancelRequest(DebtReportRequest this_) {
        this_.setDomainRootForPendingReportRequests(null);
    }

    protected String treasuryExemptionSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.treasuryExemptionSheetName", new String[0]);
    }

    protected String sibsTransactionDetailSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.sibsTransactionDetailSheetName", new String[0]);
    }

    protected String paymentReferenceCodeSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.paymentReferenceCodeSheetName", new String[0]);
    }

    private String academicActBlockingSuspensionSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.academicActBlockingSuspensionSheetName", new String[0]);
    }

    private String debitEntriesSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.debitEntriesSheetName", new String[0]);
    }

    private String creditEntriesSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.creditEntriesSheetName", new String[0]);
    }

    private String paymentEntriesSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.paymentEntriesSheetName", new String[0]);
    }

    private String settlementEntriesSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.settlementEntriesSheetName", new String[0]);
    }

    private String reimbursementEntriesSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.reimbursementEntriesSheetName", new String[0]);
    }

    private String debtAccountEntriesSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.debtAccountEntriesSheetName", new String[0]);
    }

    private String productSheetName() {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequest.productsSheetName", new String[0]);
    }

    public static Stream<DebtReportRequest> findAll() {
        return FenixFramework.getDomainRoot().getDebtReportRequestsSet().stream();
    }

    public static Stream<DebtReportRequest> findPending() {
        return FenixFramework.getDomainRoot().getDebtReportRequestsSet().stream().filter(i -> i.isPending());
    }

    public static DebtReportRequest create(DebtReportRequestBean debtReportRequestBean) {
        return (DebtReportRequest)((Object)advice$create.perform((Callable)new DebtReportRequest$callable$create(debtReportRequestBean)));
    }

    static /* synthetic */ DebtReportRequest advised$create(DebtReportRequestBean bean) {
        return new DebtReportRequest(bean);
    }

    static {
        advice$processRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$writeReportResultFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$extractInformationForSettlements = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$extractInformationForPaymentCodesTransactions = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$extractInformationForPaymentCodes = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$extractOtherTreasuryData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$extractInformationForDebitAndCredits = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$cancelRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(DebtReportRequest.class);
    }
}

