/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.importation;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportFile$callable$create;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportFile_Base;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryImportFile
extends TreasuryImportFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected TreasuryImportFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected TreasuryImportFile(TreasuryImportType type, String filename, byte[] content) {
        this();
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile((IGenericFile)this, filename, CONTENT_TYPE, content);
        this.setTreasuryImportType(type);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTreasuryImportType() == null) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportFile.type.required", new String[0]);
        }
    }

    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember((String)username);
    }

    public boolean isProcessed() {
        return this.getWhenProcessed() != null;
    }

    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        this.setTreasuryImportType(null);
        services.deleteFile((IGenericFile)this);
        super.deleteDomainObject();
    }

    public static Stream<TreasuryImportFile> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryImportFilesSet().stream();
    }

    public static TreasuryImportFile create(TreasuryImportType treasuryImportType, String string, byte[] byArray) {
        return (TreasuryImportFile)((Object)advice$create.perform((Callable)new TreasuryImportFile$callable$create(treasuryImportType, string, byArray)));
    }

    static /* synthetic */ TreasuryImportFile advised$create(TreasuryImportType type, String filename, byte[] content) {
        type.implementation().readExcel(content);
        return new TreasuryImportFile(type, filename, content);
    }
}

