/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry$callable$delete;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry_Base;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.treasury.domain.Product;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicDebtGenerationRuleEntry
extends AcademicDebtGenerationRuleEntry_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AcademicDebtGenerationRuleEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AcademicDebtGenerationRuleEntry(AcademicDebtGenerationRule rule, Product product, boolean createDebt, boolean toCreateAfterLastRegistrationStateDate, boolean forceCreation, boolean limitToRegisteredOnExecutionYear) {
        this();
        this.setAcademicDebtGenerationRule(rule);
        this.setProduct(product);
        this.setCreateDebt(createDebt);
        this.setToCreateAfterLastRegistrationStateDate(toCreateAfterLastRegistrationStateDate);
        this.setForceCreation(forceCreation);
        this.setLimitToRegisteredOnExecutionYear(forceCreation && limitToRegisteredOnExecutionYear);
        this.checkRules();
    }

    public boolean isCreateDebt() {
        return super.getCreateDebt();
    }

    public boolean isToCreateAfterLastRegistrationStateDate() {
        return super.getToCreateAfterLastRegistrationStateDate();
    }

    public boolean isForceCreation() {
        return super.getForceCreation();
    }

    public boolean isLimitToRegisteredOnExecutionYear() {
        return super.getLimitToRegisteredOnExecutionYear();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleEntry.bennu.required", new String[0]);
        }
        if (this.getAcademicDebtGenerationRule() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleEntry.academicDebtGenerationRule.required", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleEntry.product.required", new String[0]);
        }
        if (AcademicDebtGenerationRuleEntry.find(this.getAcademicDebtGenerationRule(), this.getProduct()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleEntry.product.duplicated.in.rule", new String[0]);
        }
        if (!this.isProductTuition() && !this.isProductAcademicTax() && this.isCreateDebt()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleEntry.createDebt.only.supported.for.tuition.or.academicTax", new String[0]);
        }
    }

    private boolean isProductAcademicTax() {
        return AcademicTax.findUnique(this.getProduct()).isPresent();
    }

    private boolean isProductTuition() {
        return this.getProduct().getProductGroup() == AcademicTreasurySettings.getInstance().getTuitionProductGroup();
    }

    private boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicDebtGenerationRuleEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicDebtGenerationRuleEntry this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleEntry.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setAcademicDebtGenerationRule(null);
        this_.setProduct(null);
        super.deleteDomainObject();
    }

    public static Stream<AcademicDebtGenerationRuleEntry> findAll() {
        return FenixFramework.getDomainRoot().getAcademicDebtGenerationRuleEntriesSet().stream();
    }

    public static Stream<AcademicDebtGenerationRuleEntry> find(AcademicDebtGenerationRule academicDebtGenerationRule) {
        return academicDebtGenerationRule.getAcademicDebtGenerationRuleEntriesSet().stream();
    }

    public static Stream<AcademicDebtGenerationRuleEntry> find(AcademicDebtGenerationRule academicDebtGenerationRule, Product product) {
        return AcademicDebtGenerationRuleEntry.find(academicDebtGenerationRule).filter(l -> l.getProduct() == product);
    }

    public static AcademicDebtGenerationRuleEntry create(AcademicDebtGenerationRule rule, Product product, boolean createDebt, boolean toCreateAfterLastRegistrationStateDate, boolean forceCreation, boolean limitToRegisteredOnExecutionYear) {
        return new AcademicDebtGenerationRuleEntry(rule, product, createDebt, toCreateAfterLastRegistrationStateDate, forceCreation, limitToRegisteredOnExecutionYear);
    }
}

