/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.coursefunctioncost;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost$callable$create;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost$callable$create$1;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost$callable$delete;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.dto.coursefunctioncost.CourseFunctionCostBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CourseFunctionCost
extends CourseFunctionCost_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CourseFunctionCost(DegreeCurricularPlan degreeCurricularPlan, CompetenceCourse competenceCourse, ExecutionYear executionYear, BigDecimal functionCost) {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setCompetenceCourses(competenceCourse);
        this.setExecutionYear(executionYear);
        this.setFunctionCost(functionCost);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDegreeCurricularPlan() == null) {
            throw new AcademicTreasuryDomainException("error.CourseFunctionCost.degreeCurricularPlan.required", new String[0]);
        }
        if (this.getCompetenceCourses() == null) {
            throw new AcademicTreasuryDomainException("error.CourseFunctionCost.competenceCourses.required", new String[0]);
        }
        if (this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.CourseFunctionCost.executionYear.required", new String[0]);
        }
        if (this.getFunctionCost() == null) {
            throw new AcademicTreasuryDomainException("error.CourseFunctionCost.functionCost.required", new String[0]);
        }
        if (AcademicTreasuryConstants.isNegative(this.getFunctionCost())) {
            throw new AcademicTreasuryDomainException("error.CourseFunctionCost.functionCost.must.be.positive.or.zero", new String[0]);
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CourseFunctionCost$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CourseFunctionCost this_) {
        this_.setDomainRoot(null);
        this_.setExecutionYear(null);
        this_.setDegreeCurricularPlan(null);
        this_.setCompetenceCourses(null);
        this_.deleteDomainObject();
    }

    public static Stream<CourseFunctionCost> findAll() {
        return FenixFramework.getDomainRoot().getCourseFunctionCostsSet().stream();
    }

    public static Stream<CourseFunctionCost> find(ExecutionYear executionYear, CurricularCourse curricularCourse) {
        return CourseFunctionCost.find(curricularCourse.getDegreeCurricularPlan(), curricularCourse.getCompetenceCourse(), executionYear);
    }

    public static Stream<CourseFunctionCost> find(DegreeCurricularPlan degreeCurricularPlan, CompetenceCourse competenceCourse, ExecutionYear executionYear) {
        return CourseFunctionCost.findAll().filter(c -> c.getCompetenceCourses() == competenceCourse).filter(l -> l.getExecutionYear() == executionYear && l.getDegreeCurricularPlan() == degreeCurricularPlan);
    }

    public static Optional<CourseFunctionCost> findUnique(ExecutionYear executionYear, CurricularCourse curricularCourse) {
        return CourseFunctionCost.find(executionYear, curricularCourse).findFirst();
    }

    public static Optional<CourseFunctionCost> findUnique(DegreeCurricularPlan degreeCurricularPlan, CompetenceCourse competenceCourse, ExecutionYear executionYear) {
        return CourseFunctionCost.find(degreeCurricularPlan, competenceCourse, executionYear).findFirst();
    }

    public static CourseFunctionCost create(ExecutionYear executionYear, CurricularCourse curricularCourse, BigDecimal bigDecimal) {
        return (CourseFunctionCost)((Object)advice$create.perform((Callable)new CourseFunctionCost$callable$create(executionYear, curricularCourse, bigDecimal)));
    }

    static /* synthetic */ CourseFunctionCost advised$create(ExecutionYear executionYear, CurricularCourse curricularCourse, BigDecimal functionCost) {
        return new CourseFunctionCost(curricularCourse.getDegreeCurricularPlan(), curricularCourse.getCompetenceCourse(), executionYear, functionCost);
    }

    public static CourseFunctionCost create(CourseFunctionCostBean courseFunctionCostBean) {
        return (CourseFunctionCost)((Object)advice$create$1.perform((Callable)new CourseFunctionCost$callable$create$1(courseFunctionCostBean)));
    }

    static /* synthetic */ CourseFunctionCost advised$create(CourseFunctionCostBean bean) {
        return new CourseFunctionCost(bean.getDegreeCurricularPlan(), bean.getCompetenceCourses(), bean.getExecutionYear(), bean.getFunctionCost());
    }
}

