/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

public class FenixEduAcademicTreasuryPlatformDependentServices
implements IAcademicTreasuryPlatformDependentServices {
    @Override
    public Set<Degree> readDegrees(FinantialEntity finantialEntity) {
        if (finantialEntity.getAdministrativeOffice() != null) {
            return finantialEntity.getAdministrativeOffice().getAdministratedDegrees();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isFrontOfficeMember(String username, FinantialEntity finantialEntity) {
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    @Override
    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS_ADV, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    @Override
    public boolean isAllowToModifySettlements(String username, FinantialEntity finantialEntity) {
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.PAYMENTS_MODIFY_SETTLEMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    @Override
    public boolean isAllowToModifyInvoices(String username, FinantialEntity finantialEntity) {
        User user = User.findByUsername((String)username);
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.PAYMENTS_MODIFY_INVOICES, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    @Override
    public Set<String> getFrontOfficeMemberUsernames(FinantialEntity finantialEntity) {
        return AcademicAccessRule.getMembers((AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice())).filter(u -> !Strings.isNullOrEmpty((String)u.getUsername())).map(u -> u.getUsername()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getBackOfficeMemberUsernames(FinantialEntity finantialEntity) {
        return AcademicAccessRule.getMembers((AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS_ADV, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice())).filter(u -> !Strings.isNullOrEmpty((String)u.getUsername())).map(u -> u.getUsername()).collect(Collectors.toSet());
    }

    @Override
    public String fiscalCountry(Person person) {
        return person.getFiscalAddress() != null && person.getFiscalAddress().getCountryOfResidence() != null ? person.getFiscalAddress().getCountryOfResidence().getCode() : null;
    }

    @Override
    public String fiscalNumber(Person person) {
        return person.getSocialSecurityNumber();
    }

    @Override
    public String localizedNameOfDegreeType(DegreeType degreeType) {
        return degreeType.getName().getContent();
    }

    @Override
    public String localizedNameOfStatuteType(StatuteType statuteType) {
        return statuteType.getName().getContent();
    }

    @Override
    public IngressionType ingression(Registration registration) {
        return registration.getIngressionType();
    }

    @Override
    public FinantialEntity finantialEntityOfDegree(Degree degree, LocalDate when) {
        AdministrativeOffice administrativeOffice = degree.getAdministrativeOffice();
        return administrativeOffice.getFinantialEntity();
    }

    @Override
    public String localizedNameOfEnrolment(Enrolment enrolment) {
        return this.localizedNameOfEnrolment(enrolment, I18N.getLocale());
    }

    @Override
    public String localizedNameOfEnrolment(Enrolment enrolment, Locale locale) {
        return enrolment.getName().getContent(locale);
    }

    @Override
    public RegistrationRegimeType registrationRegimeType(Registration registration, ExecutionYear executionYear) {
        return registration.getRegimeType(executionYear);
    }

    @Override
    public Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor(Registration registration, ExecutionInterval executionInterval) {
        return Sets.newHashSet(FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypes(registration, executionInterval));
    }

    public static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionYear) {
            return FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypesByYear(registration, (ExecutionYear)executionInterval);
        }
        return FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypesByChildInterval(registration, executionInterval);
    }

    private static Collection<StatuteType> findStatuteTypesByYear(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            result.addAll(FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypesByChildInterval(registration, executionInterval));
        }
        return result;
    }

    private static Collection<StatuteType> findStatuteTypesByChildInterval(Registration registration, ExecutionInterval executionInterval) {
        return registration.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidInExecutionInterval(executionInterval) && (s.getRegistration() == null || s.getRegistration() == registration)).map(s -> s.getType()).collect(Collectors.toSet());
    }

    public static String getVisibleStatuteTypesDescription(Registration registration, ExecutionInterval executionInterval) {
        return FenixEduAcademicTreasuryPlatformDependentServices.findVisibleStatuteTypes(registration, executionInterval).stream().map(s -> s.getName().getContent()).distinct().collect(Collectors.joining(", "));
    }

    public static Collection<StatuteType> findVisibleStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        return FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypes(registration, executionInterval).stream().filter(s -> s.getVisible()).collect(Collectors.toSet());
    }
}

