/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.InferTuitionStudentConditionsBean;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan$callable$create;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan$callable$delete;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan$callable$orderDown;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan$callable$orderUp;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan_Base;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.academictreasury.util.LocalizedStringUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionPaymentPlan
extends TuitionPaymentPlan_Base {
    private static final String CONDITIONS_DESCRIPTION_SEPARATOR = ", ";
    public static final Comparator<TuitionPaymentPlan> COMPARE_BY_PAYMENT_PLAN_ORDER;
    public static final Comparator<TuitionPaymentPlan> COMPARE_BY_DCP_AND_PAYMENT_PLAN_ORDER;
    private static final int MAX_PAYMENT_PLANS_LIMIT = 50;
    public static final Advice advice$orderUp;
    public static final Advice advice$orderDown;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    public TuitionPaymentPlan() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TuitionPaymentPlan(DegreeCurricularPlan degreeCurricularPlan, TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        this();
        this.setFinantialEntity(tuitionPaymentPlanBean.getFinantialEntity());
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanBean.getTuitionPaymentPlanGroup());
        this.setProduct(tuitionPaymentPlanBean.getTuitionPaymentPlanGroup().getCurrentProduct());
        this.setExecutionYear(tuitionPaymentPlanBean.getExecutionYear());
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setDefaultPaymentPlan(tuitionPaymentPlanBean.isDefaultPaymentPlan());
        this.setRegistrationRegimeType(tuitionPaymentPlanBean.getRegistrationRegimeType());
        this.setRegistrationProtocol(tuitionPaymentPlanBean.getRegistrationProtocol());
        this.setIngression(tuitionPaymentPlanBean.getIngression());
        this.setCurricularYear(tuitionPaymentPlanBean.getCurricularYear());
        this.setStatuteType(tuitionPaymentPlanBean.getStatuteType());
        this.setPayorDebtAccount(tuitionPaymentPlanBean.getPayorDebtAccount());
        this.setSemester(tuitionPaymentPlanBean.getExecutionSemester() != null ? tuitionPaymentPlanBean.getExecutionSemester().getChildOrder() : null);
        this.setFirstTimeStudent(tuitionPaymentPlanBean.isFirstTimeStudent());
        this.setCustomized(tuitionPaymentPlanBean.isCustomized());
        LocalizedString mls = new LocalizedString();
        for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
            mls = mls.with(locale, tuitionPaymentPlanBean.getName());
        }
        this.setCustomizedName(mls);
        this.setWithLaboratorialClasses(tuitionPaymentPlanBean.isWithLaboratorialClasses());
        this.setPaymentPlanOrder(TuitionPaymentPlan.find(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).max(COMPARE_BY_PAYMENT_PLAN_ORDER).map(TuitionPaymentPlan_Base::getPaymentPlanOrder).orElse(0) + 1);
        this.createInstallments(tuitionPaymentPlanBean);
        this.checkRules();
    }

    protected TuitionPaymentPlan(TuitionPaymentPlan tuitionPaymentPlanToCopy, ExecutionYear toExecutionYear) {
        this();
        this.setFinantialEntity(tuitionPaymentPlanToCopy.getFinantialEntity());
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanToCopy.getTuitionPaymentPlanGroup());
        this.setProduct(tuitionPaymentPlanToCopy.getTuitionPaymentPlanGroup().getCurrentProduct());
        this.setExecutionYear(toExecutionYear);
        this.setDegreeCurricularPlan(tuitionPaymentPlanToCopy.getDegreeCurricularPlan());
        this.setDefaultPaymentPlan(tuitionPaymentPlanToCopy.isDefaultPaymentPlan());
        this.setRegistrationRegimeType(tuitionPaymentPlanToCopy.getRegistrationRegimeType());
        this.setRegistrationProtocol(tuitionPaymentPlanToCopy.getRegistrationProtocol());
        this.setIngression(tuitionPaymentPlanToCopy.getIngression());
        this.setCurricularYear(tuitionPaymentPlanToCopy.getCurricularYear());
        this.setStatuteType(tuitionPaymentPlanToCopy.getStatuteType());
        this.setPayorDebtAccount(tuitionPaymentPlanToCopy.getPayorDebtAccount());
        this.setSemester(tuitionPaymentPlanToCopy.getSemester());
        this.setFirstTimeStudent(tuitionPaymentPlanToCopy.isFirstTimeStudent());
        this.setCustomized(tuitionPaymentPlanToCopy.isCustomized());
        this.setCustomizedName(tuitionPaymentPlanToCopy.getCustomizedName());
        this.setWithLaboratorialClasses(tuitionPaymentPlanToCopy.isWithLaboratorialClasses());
        this.setPaymentPlanOrder(TuitionPaymentPlan.find(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).max(COMPARE_BY_PAYMENT_PLAN_ORDER).map(TuitionPaymentPlan_Base::getPaymentPlanOrder).orElse(0) + 1);
        this.createInstallments(tuitionPaymentPlanToCopy);
        this.setCopyFromTuitionPaymentPlan(tuitionPaymentPlanToCopy);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTuitionPaymentPlanGroup() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.tuitionPaymentPlanGroup.required", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.finantialEntity.required", new String[0]);
        }
        if (this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.executionYear.required", new String[0]);
        }
        if (this.getDegreeCurricularPlan() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.degreeCurricularPlan.required", new String[0]);
        }
        if (this.isCustomized() && LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.customized.required.name", new String[0]);
        }
        if (this.isCustomized() && this.hasStudentSpecificConditionSelected()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.customized.plan.cannot.have.other.options", new String[0]);
        }
        if (this.isDefaultPaymentPlan() && this.getTuitionPaymentPlanGroup() != TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.default.payment.plan.must.be.for.registration", new String[0]);
        }
        if (this.isDefaultPaymentPlan()) {
            for (TuitionInstallmentTariff tuitionInstallmentTariff : this.getTuitionInstallmentTariffsSet()) {
                if (tuitionInstallmentTariff.getTuitionCalculationType().isFixedAmount()) continue;
                throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.default.payment.plan.tariffs.calculation.type.not.fixed.amount", new String[0]);
            }
        }
        if (TuitionPaymentPlan.findDefaultPaymentPlans(this.getDegreeCurricularPlan(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.defaultPaymentPlan.not.unique", this.getDegreeCurricularPlan().getPresentationName());
        }
        if (TuitionPaymentPlan.find(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear(), this.getPaymentPlanOrder()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.paymentPlan.with.order.already.exists", new String[0]);
        }
        if (this.getTuitionInstallmentTariffsSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.installments.must.not.be.empty", new String[0]);
        }
        if ((this.getTuitionPaymentPlanGroup().isForStandalone() || this.getTuitionPaymentPlanGroup().isForExtracurricular()) && this.getTuitionInstallmentTariffsSet().size() > 1) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.standalone.and.extracurricular.supports.only.one.installment", new String[0]);
        }
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && !this.hasAtLeastOneConditionSpecified()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.specify.at.least.one.condition", new String[0]);
        }
    }

    private boolean hasStudentSpecificConditionSelected() {
        return this.getRegistrationRegimeType() != null || this.isDefaultPaymentPlan() || this.getRegistrationProtocol() != null || this.getIngression() != null || this.getCurricularYear() != null || this.getSemester() != null || this.isFirstTimeStudent() || this.getStatuteType() != null;
    }

    private boolean hasAtLeastOneConditionSpecified() {
        boolean hasAtLeastOneCondition = false;
        hasAtLeastOneCondition |= this.getDefaultPaymentPlan();
        hasAtLeastOneCondition |= this.getRegistrationRegimeType() != null;
        hasAtLeastOneCondition |= this.getRegistrationProtocol() != null;
        hasAtLeastOneCondition |= this.getIngression() != null;
        hasAtLeastOneCondition |= this.getCurricularYear() != null;
        hasAtLeastOneCondition |= this.getStatuteType() != null;
        hasAtLeastOneCondition |= this.getSemester() != null;
        hasAtLeastOneCondition |= this.isFirstTimeStudent();
        hasAtLeastOneCondition |= this.isCustomized();
        return hasAtLeastOneCondition |= this.isWithLaboratorialClasses();
    }

    private void createInstallments(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        for (AcademicTariffBean academicTariffBean : tuitionPaymentPlanBean.getTuitionInstallmentBeans()) {
            TuitionInstallmentTariff.create(tuitionPaymentPlanBean.getFinantialEntity(), this, academicTariffBean);
        }
    }

    private void createInstallments(TuitionPaymentPlan tuitionPaymentPlanToCopy) {
        tuitionPaymentPlanToCopy.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).forEach(t -> TuitionInstallmentTariff.copy(t, this));
    }

    public LocalizedString getName() {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            String paymentPlanLabel = this.isCustomized() ? "label.TuitionPaymentPlan.paymentPlanName.customized" : "label.TuitionPaymentPlan.paymentPlanName";
            result = result.with(locale, AcademicTreasuryConstants.academicTreasuryBundle(locale, paymentPlanLabel, "[" + this.getDegreeCurricularPlan().getDegree().getCode() + "] " + this.getDegreeCurricularPlan().getDegree().getPresentationNameI18N().getContent(locale) + " - " + this.getDegreeCurricularPlan().getName(), this.getExecutionYear().getQualifiedName(), this.isCustomized() ? this.getCustomizedName().getContent(locale) : null));
        }
        return result;
    }

    public LocalizedString getConditionsDescription() {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            StringBuilder description = new StringBuilder();
            if (this.isDefaultPaymentPlan()) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlan.defaultPaymentPlan", new String[0])).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getTuitionPaymentPlanGroup().isForStandalone()) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.standalone", new String[0])).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            } else if (this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.extracurricular", new String[0])).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getRegistrationRegimeType() != null) {
                description.append(this.getRegistrationRegimeType().getLocalizedName()).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getRegistrationProtocol() != null) {
                description.append(this.getRegistrationProtocol().getDescription().getContent(locale)).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getIngression() != null) {
                description.append(this.getIngression().getLocalizedName()).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getCurricularYear() != null) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.curricularYear.description", String.valueOf(this.getCurricularYear().getYear()))).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getSemester() != null) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.curricularSemester.description", String.valueOf(this.getSemester()))).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.getStatuteType() != null) {
                description.append(academicTreasuryServices.localizedNameOfStatuteType(this.getStatuteType())).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.isFirstTimeStudent()) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.firstTimeStudent", new String[0])).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.isCustomized()) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.customized", new String[0])).append(" [").append(this.getCustomizedName().getContent()).append("]").append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (this.isWithLaboratorialClasses()) {
                description.append(AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.withLaboratorialClasses", new String[0])).append(CONDITIONS_DESCRIPTION_SEPARATOR);
            }
            if (description.toString().contains(CONDITIONS_DESCRIPTION_SEPARATOR)) {
                description.delete(description.length() - CONDITIONS_DESCRIPTION_SEPARATOR.length(), description.length());
            }
            result = result.with(locale, description.toString());
        }
        return result;
    }

    public List<TuitionInstallmentTariff> getOrderedTuitionInstallmentTariffs() {
        return super.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).collect(Collectors.toList());
    }

    public TuitionInstallmentTariff getStandaloneTuitionInstallmentTariff() {
        if (!this.getTuitionPaymentPlanGroup().isForStandalone()) {
            throw new RuntimeException("wrong call");
        }
        return this.getOrderedTuitionInstallmentTariffs().get(0);
    }

    public TuitionInstallmentTariff getExtracurricularTuitionInstallmentTariff() {
        if (!this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        return this.getOrderedTuitionInstallmentTariffs().get(0);
    }

    public LocalizedString installmentName(TuitionInstallmentTariff installmentTariff) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        Object label = "label.TuitionInstallmentTariff.debitEntry.name.";
        if (this.getTuitionPaymentPlanGroup().isForRegistration()) {
            label = (String)label + "registration";
        } else if (this.getTuitionPaymentPlanGroup().isForStandalone()) {
            label = (String)label + "standalone";
        } else if (this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            label = (String)label + "extracurricular";
        }
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            String installmentName = AcademicTreasuryConstants.academicTreasuryBundle(locale, (String)label, String.valueOf(installmentTariff.getInstallmentOrder()), this.getDegreeCurricularPlan().getDegree().getPresentationName(this.getExecutionYear(), locale), this.getExecutionYear().getQualifiedName());
            result = result.with(locale, installmentName);
        }
        return result;
    }

    public boolean isCustomized() {
        return this.getCustomized();
    }

    public boolean isDefaultPaymentPlan() {
        return this.getDefaultPaymentPlan();
    }

    public boolean isFirstTimeStudent() {
        return this.getFirstTimeStudent();
    }

    public boolean isFirst() {
        return TuitionPaymentPlan.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList()).get(0) == this;
    }

    public boolean isLast() {
        List list = TuitionPaymentPlan.findSortedByPaymentPlanOrder(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toList());
        return list.get(list.size() - 1) == this;
    }

    public boolean isWithLaboratorialClasses() {
        return super.getWithLaboratorialClasses();
    }

    public void orderUp() {
        Object object = advice$orderUp.perform((Callable)new TuitionPaymentPlan$callable$orderUp(this));
    }

    static /* synthetic */ void advised$orderUp(TuitionPaymentPlan this_) {
        if (this_.isFirst()) {
            return;
        }
        TuitionPaymentPlan previous = this_.getPreviousTuitionPaymentPlan();
        int order = previous.getPaymentPlanOrder();
        previous.setPaymentPlanOrder(this_.getPaymentPlanOrder());
        this_.setPaymentPlanOrder(order);
    }

    public void orderDown() {
        Object object = advice$orderDown.perform((Callable)new TuitionPaymentPlan$callable$orderDown(this));
    }

    static /* synthetic */ void advised$orderDown(TuitionPaymentPlan this_) {
        if (this_.isLast()) {
            return;
        }
        TuitionPaymentPlan next = this_.getNextTuitionPaymentPlan();
        int order = this_.getPaymentPlanOrder() + 1;
        next.setPaymentPlanOrder(this_.getPaymentPlanOrder());
        this_.setPaymentPlanOrder(order);
    }

    public boolean createDebitEntriesForRegistration(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!this.getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        if (academicTreasuryEvent.isCharged()) {
            return false;
        }
        boolean createdDebitEntries = false;
        for (TuitionInstallmentTariff tariff : this.getTuitionInstallmentTariffsSet()) {
            if (academicTreasuryEvent.isChargedWithDebitEntry(tariff)) continue;
            tariff.createDebitEntryForRegistration(debtAccount, academicTreasuryEvent, when);
            createdDebitEntries = true;
        }
        return createdDebitEntries;
    }

    public boolean createDebitEntriesForStandalone(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment standaloneEnrolment, LocalDate when) {
        if (!this.getTuitionPaymentPlanGroup().isForStandalone()) {
            throw new RuntimeException("wrong call");
        }
        if (!standaloneEnrolment.isStandalone()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.standalone");
        }
        boolean createdDebitEntries = false;
        HashSet createdDebitEntriesSet = Sets.newHashSet();
        for (TuitionInstallmentTariff tariff : this.getTuitionInstallmentTariffsSet()) {
            if (academicTreasuryEvent.isChargedWithDebitEntry(standaloneEnrolment)) continue;
            createdDebitEntriesSet.add(tariff.createDebitEntryForStandalone(debtAccount, academicTreasuryEvent, standaloneEnrolment, when));
            createdDebitEntries = true;
        }
        if (createdDebitEntries) {
            DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
            debitNote.addDebitNoteEntries((List)Lists.newArrayList((Iterable)createdDebitEntriesSet));
            if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
                debitNote.closeDocument();
            }
        }
        return createdDebitEntries;
    }

    public boolean createDebitEntriesForExtracurricular(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment extracurricularEnrolment, LocalDate when) {
        if (!this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        if (!extracurricularEnrolment.isExtraCurricular()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.standalone");
        }
        boolean createdDebitEntries = false;
        HashSet createdDebitEntriesSet = Sets.newHashSet();
        for (TuitionInstallmentTariff tariff : this.getTuitionInstallmentTariffsSet()) {
            if (academicTreasuryEvent.isChargedWithDebitEntry(extracurricularEnrolment)) continue;
            createdDebitEntriesSet.add(tariff.createDebitEntryForExtracurricular(debtAccount, academicTreasuryEvent, extracurricularEnrolment, when));
            createdDebitEntries = true;
        }
        if (createdDebitEntries) {
            DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
            debitNote.addDebitNoteEntries((List)Lists.newArrayList((Iterable)createdDebitEntriesSet));
            if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
                debitNote.closeDocument();
            }
        }
        return createdDebitEntries;
    }

    public boolean isDeletable() {
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && this.isDefaultPaymentPlan()) {
            HashSet allPlans = Sets.newHashSet();
            allPlans.addAll(TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toSet()));
            allPlans.addAll(TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toSet()));
            allPlans.addAll(TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), this.getDegreeCurricularPlan(), this.getExecutionYear()).collect(Collectors.toSet()));
            for (TuitionPaymentPlan tuitionPaymentPlan : allPlans) {
                if (tuitionPaymentPlan == this) continue;
                for (TuitionInstallmentTariff tuitionInstallmentTariff : tuitionPaymentPlan.getTuitionInstallmentTariffsSet()) {
                    if (!tuitionInstallmentTariff.isDefaultPaymentPlanDependent()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public BigDecimal tuitionTotalAmount() {
        return this.getTuitionInstallmentTariffsSet().stream().map(t -> t.getFixedAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TuitionPaymentPlan$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TuitionPaymentPlan this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        while (!this_.getTuitionInstallmentTariffsSet().isEmpty()) {
            ((TuitionInstallmentTariff)((Object)this_.getTuitionInstallmentTariffsSet().iterator().next())).delete();
        }
        super.setTuitionPaymentPlanGroup(null);
        super.setExecutionYear(null);
        super.setDegreeCurricularPlan(null);
        super.setRegistrationProtocol(null);
        super.setProduct(null);
        this_.setCurricularYear(null);
        this_.setFinantialEntity(null);
        this_.setIngression(null);
        this_.setStatuteType(null);
        this_.setPayorDebtAccount(null);
        this_.setCopyFromTuitionPaymentPlan(null);
        while (!this_.getTuitionPaymentPlanCopiesSet().isEmpty()) {
            ((TuitionPaymentPlan)((Object)this_.getTuitionPaymentPlanCopiesSet().iterator().next())).setCopyFromTuitionPaymentPlan(null);
        }
        super.deleteDomainObject();
    }

    protected FinantialEntity finantialEntity() {
        return (FinantialEntity)FinantialEntity.findAll().findFirst().get();
    }

    public boolean isStudentMustBeEnrolled() {
        return true;
    }

    public boolean isPayorDebtAccountDefined() {
        return this.getPayorDebtAccount() != null;
    }

    public boolean isCopyFromOtherExistingTuitionPaymentPlan() {
        return this.getCopyFromTuitionPaymentPlan() != null;
    }

    public boolean hasCopiesInExecutionInterval(ExecutionInterval executionInterval) {
        return this.getTuitionPaymentPlanCopiesSet().stream().anyMatch(p -> p.getExecutionYear() == executionInterval);
    }

    public static Stream<TuitionPaymentPlan> findAll() {
        return FenixFramework.getDomainRoot().getTuitionPaymentPlansSet().stream();
    }

    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        return tuitionPaymentPlanGroup.getTuitionPaymentPlansSet().stream();
    }

    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, FinantialEntity finantialEntity, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup).filter(t -> t.finantialEntity() == finantialEntity);
    }

    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup).filter(t -> t.getExecutionYear() == executionYear && t.getDegreeCurricularPlan() == degreeCurricularPlan);
    }

    public static Stream<TuitionPaymentPlan> findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup, degreeCurricularPlan, executionYear).sorted(COMPARE_BY_PAYMENT_PLAN_ORDER).collect(Collectors.toList()).stream();
    }

    protected static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, int paymentPlanOrder) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup, degreeCurricularPlan, executionYear).filter(t -> t.getPaymentPlanOrder() == paymentPlanOrder);
    }

    protected static Optional<TuitionPaymentPlan> findUnique(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, int paymentPlanOrder) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup, degreeCurricularPlan, executionYear, paymentPlanOrder).findFirst();
    }

    private static Stream<TuitionPaymentPlan> findDefaultPaymentPlans(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), degreeCurricularPlan, executionYear).filter(t -> t.isDefaultPaymentPlan());
    }

    public static Optional<TuitionPaymentPlan> findUniqueDefaultPaymentPlan(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.findDefaultPaymentPlans(degreeCurricularPlan, executionYear).findFirst();
    }

    public static boolean isDefaultPaymentPlanDefined(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.findUniqueDefaultPaymentPlan(degreeCurricularPlan, executionYear).isPresent();
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForRegistration(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, InferTuitionStudentConditionsBean conditionsBean) {
        List plans = TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), degreeCurricularPlan, executionYear).collect(Collectors.toList());
        ArrayList filtered = Lists.newArrayList();
        for (TuitionPaymentPlan t : plans) {
            if (t.getRegistrationRegimeType() != null && t.getRegistrationRegimeType() != conditionsBean.getRegimeType() || t.getRegistrationProtocol() != null && t.getRegistrationProtocol() != conditionsBean.getRegistrationProtocol() || t.getIngression() != null && t.getIngression() != conditionsBean.getIngression()) continue;
            if (t.getSemester() != null) {
                if (conditionsBean.getSemestersWithEnrolments().size() != 1) continue;
                Integer semester = conditionsBean.getSemestersWithEnrolments().iterator().next();
                if (!t.getSemester().equals(semester)) continue;
            }
            if (t.getCurricularYear() != null && t.getCurricularYear() != conditionsBean.getCurricularYear() || t.getStatuteType() != null && !conditionsBean.getStatutes().contains(t.getStatuteType()) || t.getFirstTimeStudent() && !conditionsBean.isFirstTimeStudent() || t.isCustomized()) continue;
            filtered.add(t);
        }
        return !filtered.isEmpty() ? (TuitionPaymentPlan)((Object)filtered.get(0)) : null;
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForRegistration(Registration registration, ExecutionYear executionYear, InferTuitionStudentConditionsBean conditionsBean) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return null;
        }
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan.getDegreeCurricularPlan();
        return TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(degreeCurricularPlan, executionYear, conditionsBean);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForRegistration(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return null;
        }
        InferTuitionStudentConditionsBean conditionsBean = InferTuitionStudentConditionsBean.build(registration, executionYear);
        return TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(registration, executionYear, conditionsBean);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForStandaloneEnrolment(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (!enrolment.isStandalone()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.enrolment.is.not.standalone", new String[0]);
        }
        DegreeCurricularPlan degreeCurricularPlan = enrolment.getCurricularCourse().getDegreeCurricularPlan();
        RegistrationProtocol registrationProtocol = registration.getRegistrationProtocol();
        IngressionType ingression = registration.getIngressionType();
        boolean laboratorial = TuitionPaymentPlan.laboratorial(enrolment);
        Set<StatuteType> statutes = academicTreasuryServices.statutesTypesValidOnAnyExecutionSemesterFor(registration, (ExecutionInterval)executionYear);
        Stream<TuitionPaymentPlan> stream = TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get(), degreeCurricularPlan, executionYear);
        List l = stream.collect(Collectors.toList());
        List plans = Lists.newArrayList(l).stream().filter(t -> !(t.getRegistrationProtocol() != null && t.getRegistrationProtocol() != registrationProtocol || t.getIngression() != null && t.getIngression() != ingression || t.isWithLaboratorialClasses() && t.isWithLaboratorialClasses() != laboratorial || t.isCustomized())).collect(Collectors.toList());
        ArrayList filtered = Lists.newArrayList();
        for (TuitionPaymentPlan t2 : plans) {
            if (t2.getStatuteType() != null && !statutes.contains(t2.getStatuteType())) continue;
            filtered.add(t2);
        }
        return filtered.stream().findFirst().orElse(null);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForExtracurricularEnrolment(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (!enrolment.isExtraCurricular()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.enrolment.is.not.extracurricular", new String[0]);
        }
        DegreeCurricularPlan degreeCurricularPlan = enrolment.getCurricularCourse().getDegreeCurricularPlan();
        RegistrationProtocol registrationProtocol = registration.getRegistrationProtocol();
        IngressionType ingression = registration.getIngressionType();
        boolean laboratorial = TuitionPaymentPlan.laboratorial(enrolment);
        Set<StatuteType> statutes = academicTreasuryServices.statutesTypesValidOnAnyExecutionSemesterFor(registration, (ExecutionInterval)executionYear);
        Stream<TuitionPaymentPlan> stream = TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), degreeCurricularPlan, executionYear);
        List l = stream.collect(Collectors.toList());
        List plans = Lists.newArrayList(l).stream().filter(t -> !(t.getRegistrationProtocol() != null && t.getRegistrationProtocol() != registrationProtocol || t.getIngression() != null && t.getIngression() != ingression || t.isWithLaboratorialClasses() && t.isWithLaboratorialClasses() != laboratorial || t.isCustomized())).collect(Collectors.toList());
        ArrayList filtered = Lists.newArrayList();
        for (TuitionPaymentPlan t2 : plans) {
            if (t2.getStatuteType() != null && !statutes.contains(t2.getStatuteType())) continue;
            filtered.add(t2);
        }
        return filtered.stream().findFirst().orElse(null);
    }

    private static boolean laboratorial(Enrolment enrolment) {
        return AcademicTreasuryConstants.isPositive(new BigDecimal(enrolment.getCurricularCourse().getCompetenceCourse().getLaboratorialHours(enrolment.getExecutionInterval())));
    }

    public static boolean firstTimeStudent(Registration registration, ExecutionYear executionYear) {
        return registration.isFirstTime(executionYear);
    }

    public static Integer curricularYear(Registration registration, ExecutionYear executionYear) {
        return registration.getCurricularYear(executionYear);
    }

    public static Set<Integer> semestersWithEnrolments(Registration registration, ExecutionYear executionYear) {
        return registration.getEnrolments(executionYear).stream().map(e -> e.getExecutionInterval().getChildOrder()).collect(Collectors.toSet());
    }

    private TuitionPaymentPlan getPreviousTuitionPaymentPlan() {
        for (int i = this.getPaymentPlanOrder() - 1; i >= 0; --i) {
            if (!TuitionPaymentPlan.findUnique(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear(), i).isPresent()) continue;
            return TuitionPaymentPlan.findUnique(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear(), i).get();
        }
        return null;
    }

    private TuitionPaymentPlan getNextTuitionPaymentPlan() {
        for (int i = this.getPaymentPlanOrder() + 1; i <= 50; ++i) {
            if (!TuitionPaymentPlan.findUnique(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear(), i).isPresent()) continue;
            return TuitionPaymentPlan.findUnique(this.getTuitionPaymentPlanGroup(), this.getDegreeCurricularPlan(), this.getExecutionYear(), i).get();
        }
        return null;
    }

    public static Set<TuitionPaymentPlan> create(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        return (Set)advice$create.perform((Callable)new TuitionPaymentPlan$callable$create(tuitionPaymentPlanBean));
    }

    static /* synthetic */ Set<TuitionPaymentPlan> advised$create(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        HashSet result = Sets.newHashSet();
        for (DegreeCurricularPlan degreeCurricularPlan : tuitionPaymentPlanBean.getDegreeCurricularPlans()) {
            result.add(new TuitionPaymentPlan(degreeCurricularPlan, tuitionPaymentPlanBean));
        }
        return result;
    }

    public static TuitionPaymentPlan copy(TuitionPaymentPlan tuitionPaymentPlanToCopy, ExecutionYear toExecutionYear) {
        return new TuitionPaymentPlan(tuitionPaymentPlanToCopy, toExecutionYear);
    }

    static {
        advice$orderUp = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$orderDown = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_PAYMENT_PLAN_ORDER = (o1, o2) -> {
            int c = Integer.compare(o1.getPaymentPlanOrder(), o2.getPaymentPlanOrder());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARE_BY_DCP_AND_PAYMENT_PLAN_ORDER = (o1, o2) -> {
            int c = DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME.compare(o1.getDegreeCurricularPlan(), o2.getDegreeCurricularPlan());
            if (c != 0) {
                return c;
            }
            c = Integer.compare(o1.getPaymentPlanOrder(), o2.getPaymentPlanOrder());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

