/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoCreationReportFile;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoExportOperation;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo$3$callable$call;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo$4$callable$call;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo$callable$exportTuitionInformation;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo$callable$markToInfoExport;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoSettings;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeAcademicEntry;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo_Base;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.exceptions.ERPTuitionInfoNoDifferencesException;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.exceptions.ERPTuitionInfoPendingException;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPTuitionInfo
extends ERPTuitionInfo_Base {
    public static Comparator<ERPTuitionInfo> COMPARE_BY_CREATION_DATE;
    public static final Advice advice$markToInfoExport;
    public static final Advice advice$exportTuitionInformation;

    public ERPTuitionInfo() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public ERPTuitionInfo(Customer customer, ERPTuitionInfoType erpTuitionInfoType, BigDecimal tuitionTotalAmount, BigDecimal deltaTuitionAmount, LocalDate beginDate, LocalDate endDate, ERPTuitionInfo lastSucessfulSentErpTuitionInfo) {
        this();
        this.setCreationDate(new DateTime());
        this.setCustomer(customer);
        this.setErpTuitionInfoType(erpTuitionInfoType);
        this.setTuitionTotalAmount(tuitionTotalAmount);
        this.setTuitionDeltaAmount(deltaTuitionAmount);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setLastSuccessfulSentERPTuitionInfo(lastSucessfulSentErpTuitionInfo);
        Series series = ERPTuitionInfoSettings.getInstance().getSeries();
        DocumentNumberSeries documentNumberSeries = null;
        if (AcademicTreasuryConstants.isPositive(this.getTuitionDeltaAmount())) {
            documentNumberSeries = DocumentNumberSeries.find((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (Series)series);
        } else if (AcademicTreasuryConstants.isNegative(this.getTuitionDeltaAmount())) {
            documentNumberSeries = DocumentNumberSeries.find((FinantialDocumentType)FinantialDocumentType.findForCreditNote(), (Series)series);
        }
        this.setDocumentNumberSeries(documentNumberSeries);
        this.setDocumentNumber("" + this.getDocumentNumberSeries().getSequenceNumberAndIncrement());
        this.setFirstERPTuitionInfo(ERPTuitionInfo.findFirstIntegratedWithSuccess(this).orElse(null));
        this.checkRules();
        this.markToInfoExport();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.bennu.required", new String[0]);
        }
        if (this.getCreationDate() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.createDate.required", new String[0]);
        }
        if (this.getErpTuitionInfoType() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.erpTuitionInfoType.required", new String[0]);
        }
        if (this.getDocumentNumberSeries() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.documentNumberSeries.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDocumentNumber())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.documentNumber.required", new String[0]);
        }
        if (this.getTuitionTotalAmount() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.tuitionTotalAmount.required", new String[0]);
        }
        if (AcademicTreasuryConstants.isNegative(this.getTuitionTotalAmount())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.tuitionTotalAmount.negative", new String[0]);
        }
        if (this.getTuitionDeltaAmount() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.tuitionDeltaAmount.required", new String[0]);
        }
        if (AcademicTreasuryConstants.isZero(this.getTuitionDeltaAmount())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.tuitionDeltaAmount.cannot.be.zero", new String[0]);
        }
        if (this.getBeginDate() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.beginDate.required", new String[0]);
        }
        if (this.getEndDate() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.endDate.required", new String[0]);
        }
        if (this.getBeginDate().isAfter((ReadablePartial)this.getEndDate())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.beginDate.after.endDate", new String[0]);
        }
        if (AcademicTreasuryConstants.isPositive(this.getTuitionDeltaAmount()) && !this.getDocumentNumberSeries().getFinantialDocumentType().getType().isDebitNote()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.tuitionDeltaAmount.positive.but.finantialDocument.not.debit.note", new String[0]);
        }
        if (AcademicTreasuryConstants.isNegative(this.getTuitionDeltaAmount()) && !this.getDocumentNumberSeries().getFinantialDocumentType().getType().isCreditNote()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.tuitionDeltaAmount.negative.but.finantialDocument.not.credit.note", new String[0]);
        }
        if (ERPTuitionInfo.findPendingToExport(this.getCustomer(), this.getErpTuitionInfoType()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.pending.to.export.already.exists", new String[0]);
        }
        if (this.isSubsequent() ^ this.isFollowedBySuccessfulSent()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.first.and.last.successful.sent.incoerent", new String[0]);
        }
    }

    public String getUiDocumentNumber() {
        return String.format("%s %s/%s", this.getDocumentNumberSeries().documentNumberSeriesPrefix(), this.getDocumentNumberSeries().getSeries().getCode(), Strings.padStart((String)this.getDocumentNumber(), (int)7, (char)'0'));
    }

    public boolean isDebit() {
        return this.getDocumentNumberSeries().getFinantialDocumentType().getType().isDebitNote();
    }

    public boolean isCredit() {
        return this.getDocumentNumberSeries().getFinantialDocumentType().getType().isCreditNote();
    }

    public String getUiSettlementDocumentNumberForERP() {
        return this.getUiDocumentNumber().replaceAll(this.getDocumentNumberSeries().documentNumberSeriesPrefix(), FinantialDocumentType.findForSettlementNote().getDocumentNumberSeriesPrefix());
    }

    public boolean isPendingToExport() {
        return this.getDomainRootPendingToExport() != null;
    }

    public boolean isExportationSuccess() {
        return this.getExportationSuccess();
    }

    public boolean isSubsequent() {
        return this.getFirstERPTuitionInfo() != null;
    }

    public boolean isFollowedBySuccessfulSent() {
        return this.getLastSuccessfulSentERPTuitionInfo() != null;
    }

    public void export() {
        ERPTuitionInfoSettings.getInstance().exporter().export(this);
    }

    public void markToInfoExport() {
        Object object = advice$markToInfoExport.perform((Callable)new ERPTuitionInfo$callable$markToInfoExport(this));
    }

    static /* synthetic */ void advised$markToInfoExport(ERPTuitionInfo this_) {
        this_.setDomainRootPendingToExport(FenixFramework.getDomainRoot());
    }

    public void markIntegratedWithSuccess(String message) {
        this.setDomainRootPendingToExport(null);
        this.setExportationMessage(message);
        this.setExportationSuccess(true);
        this.checkRules();
    }

    private void cancelExportation(String reason) {
        this.setDomainRootPendingToExport(null);
        this.setExportationMessage(reason);
        this.setExportationSuccess(false);
        this.checkRules();
    }

    public void editPendingToExport(BigDecimal tuitionTotalAmount, BigDecimal tuitionDeltaAmount, LocalDate beginDate, LocalDate endDate) {
        if (!this.isPendingToExport()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.editPendingToExport.already.exported", new String[0]);
        }
        this.setTuitionTotalAmount(tuitionTotalAmount);
        this.setTuitionDeltaAmount(tuitionDeltaAmount);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.checkRules();
    }

    public Optional<ERPTuitionInfoExportOperation> getLastERPExportOperation() {
        if (this.getErpTuitionInfoExportOperationsSet().isEmpty()) {
            return Optional.empty();
        }
        return this.getErpTuitionInfoExportOperationsSet().stream().sorted(ERPTuitionInfoExportOperation.COMPARE_BY_VERSIONING_CREATION_DATE.reversed()).findFirst();
    }

    public static Stream<ERPTuitionInfo> findAll() {
        return FenixFramework.getDomainRoot().getErpTuitionInfosSet().stream();
    }

    public static Stream<ERPTuitionInfo> find(Customer customer) {
        return customer.getErpTuitionInfosSet().stream();
    }

    public static Stream<ERPTuitionInfo> find(Customer customer, ERPTuitionInfoType type) {
        return ERPTuitionInfo.find(customer).filter(i -> i.getErpTuitionInfoType() == type);
    }

    public static Optional<ERPTuitionInfo> findUniqueByDocumentNumber(String documentNumber) {
        return ERPTuitionInfo.findAll().filter(e -> documentNumber.equals(e.getUiDocumentNumber())).findFirst();
    }

    public static Stream<ERPTuitionInfo> findPendingToExport(Customer customer, ERPTuitionInfoType type) {
        return ERPTuitionInfo.find(customer, type).filter(i -> i.isPendingToExport());
    }

    public static Optional<ERPTuitionInfo> findUniquePendingToExport(Customer customer, ERPTuitionInfoType type) {
        return ERPTuitionInfo.findPendingToExport(customer, type).findFirst();
    }

    public static Optional<ERPTuitionInfo> findFirstIntegratedWithSuccess(Customer customer, ERPTuitionInfoType type) {
        return ERPTuitionInfo.find(customer, type).filter(t -> t.isExportationSuccess()).sorted(COMPARE_BY_CREATION_DATE).findFirst();
    }

    public static Optional<ERPTuitionInfo> findFirstIntegratedWithSuccess(ERPTuitionInfo erpTuitionInfo) {
        return ERPTuitionInfo.findFirstIntegratedWithSuccess(erpTuitionInfo.getCustomer(), erpTuitionInfo.getErpTuitionInfoType());
    }

    public static Optional<ERPTuitionInfo> findLastIntegratedWithSuccess(Customer customer, ERPTuitionInfoType type) {
        return ERPTuitionInfo.find(customer, type).filter(t -> t.isExportationSuccess()).sorted(COMPARE_BY_CREATION_DATE.reversed()).findFirst();
    }

    private static ERPTuitionInfo create(Customer customer, ERPTuitionInfoType type, BigDecimal tuitionTotalAmount, BigDecimal deltaTuitionAmount, LocalDate beginDate, LocalDate endDate, ERPTuitionInfo lastSucessfulSentErpTuitionInfo) {
        if (ERPTuitionInfo.findUniquePendingToExport(customer, type).isPresent()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.pending.to.export.already.exists", new String[0]);
        }
        return new ERPTuitionInfo(customer, type, tuitionTotalAmount, deltaTuitionAmount, beginDate, endDate, lastSucessfulSentErpTuitionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerTuitionInfoCalculation(Predicate<ERPTuitionInfoType> erpTuitionInfoTypeFilterPredicate, Predicate<PersonCustomer> personCustomerPredicate) {
        if (!ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.exportation.active.disabled", new String[0]);
        }
        if (erpTuitionInfoTypeFilterPredicate == null) {
            erpTuitionInfoTypeFilterPredicate = t -> true;
        }
        if (personCustomerPredicate == null) {
            personCustomerPredicate = t -> true;
        }
        ArrayList callablesList = Lists.newArrayList();
        List<ERPTuitionInfoCalculationReportEntry> reportEntries = Collections.synchronizedList(Lists.newArrayList());
        for (ExecutionYear executionYear : ERPTuitionInfoSettings.getInstance().getActiveExecutionYearsSet()) {
            for (ERPTuitionInfoType type : ERPTuitionInfoType.findActiveForExecutionYear(executionYear).collect(Collectors.toSet())) {
                if (!erpTuitionInfoTypeFilterPredicate.test(type)) continue;
                for (PersonCustomer customer : PersonCustomer.findAll().collect(Collectors.toSet())) {
                    if (customer.getAssociatedPerson().getStudent() == null || !personCustomerPredicate.test(customer)) continue;
                    callablesList.add(ERPTuitionInfo.createTuitionInformationCallable(customer, type, reportEntries));
                }
            }
        }
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.invokeAll(callablesList);
            executor.shutdown();
            executor.awaitTermination(3L, TimeUnit.HOURS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ERPTuitionInfo.writeSpreadsheet(reportEntries);
        }
    }

    private static void writeSpreadsheet(final List<ERPTuitionInfoCalculationReportEntry> reportEntries) {
        Spreadsheet spreadsheet = new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{new ExcelSheet(){

                    public Stream<? extends SpreadsheetRow> getRows() {
                        return reportEntries.stream();
                    }

                    public String getName() {
                        return AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.sheet.name", new String[0]);
                    }

                    public String[] getHeaders() {
                        return new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.executionDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.studentName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.customerFiscalNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.erpTuitionInfoTypeCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.erpTuitionInfoTypeName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.executionYearQualifiedName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.erpTuitionInfoExternalId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.erpTuitionInfoCreationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.erpTuitionInfoUpdateDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.erpTuitionInfoDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.totalAmount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.deltaAmount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.errorOccured", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCalculationReportEntry.errorDescription", new String[0])};
                    }
                }};
            }
        };
        byte[] spreadsheetContent = Spreadsheet.buildSpreadsheetContent((Spreadsheet)spreadsheet, null);
        DateTime now = DateTime.now();
        String filename = AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoCreationReportFile.filename", now.toString("yyyyMMddHHmmss"));
        ERPTuitionInfoCreationReportFile.create(filename, filename, spreadsheetContent);
    }

    public static void triggerTuitionExportationToERP(Predicate<ERPTuitionInfo> erpTuitionInfoPredicate) {
        if (!ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.exportation.active.disabled", new String[0]);
        }
        if (erpTuitionInfoPredicate == null) {
            erpTuitionInfoPredicate = t -> true;
        }
        ArrayList callablesList = Lists.newArrayList();
        for (ERPTuitionInfo info : ERPTuitionInfo.findPendingToExport().collect(Collectors.toSet())) {
            if (!erpTuitionInfoPredicate.test(info)) continue;
            callablesList.add(ERPTuitionInfo.exportTuitionInformationCallable(info));
        }
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.invokeAll(callablesList);
            executor.shutdown();
            executor.awaitTermination(3L, TimeUnit.HOURS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Stream<ERPTuitionInfo> findPendingToExport() {
        return FenixFramework.getDomainRoot().getErpTuitionInfosPendingToExportSet().stream();
    }

    public static ERPTuitionInfo exportTuitionInformation(PersonCustomer personCustomer, ERPTuitionInfoType eRPTuitionInfoType) {
        return (ERPTuitionInfo)((Object)advice$exportTuitionInformation.perform((Callable)new ERPTuitionInfo$callable$exportTuitionInformation(personCustomer, eRPTuitionInfoType)));
    }

    static /* synthetic */ ERPTuitionInfo advised$exportTuitionInformation(PersonCustomer customer, ERPTuitionInfoType type) {
        if (!ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.exportation.active.disabled", new String[0]);
        }
        ExecutionYear executionYear = type.getExecutionYear();
        BigDecimal totalAmount = BigDecimal.ZERO;
        Set treasuryEventsSet = AcademicTreasuryEvent.find(customer.getAssociatedPerson()).filter(e -> e.getExecutionYear() == executionYear).collect(Collectors.toSet());
        block0: for (AcademicTreasuryEvent event : treasuryEventsSet) {
            for (ERPTuitionInfoTypeAcademicEntry academicEntry : type.getErpTuitionInfoTypeAcademicEntriesSet()) {
                if (!academicEntry.isAppliedOnAcademicTreasuryEvent(event, executionYear)) continue;
                totalAmount = totalAmount.add(event.getAmountToPay((Customer)customer, null)).subtract(event.getInterestsAmountToPay((Customer)customer, null));
                continue block0;
            }
        }
        Optional<ERPTuitionInfo> lastIntegratedWithSuccess = ERPTuitionInfo.findLastIntegratedWithSuccess((Customer)customer, type);
        BigDecimal deltaAmount = totalAmount.subtract(lastIntegratedWithSuccess.isPresent() ? lastIntegratedWithSuccess.get().getTuitionTotalAmount() : BigDecimal.ZERO);
        if (ERPTuitionInfo.findUniquePendingToExport((Customer)customer, type).isPresent()) {
            ERPTuitionInfo pendingErpTuitionInfo = ERPTuitionInfo.findUniquePendingToExport((Customer)customer, type).get();
            throw new ERPTuitionInfoPendingException("error.ERPTuitionInfo.pending.to.export", pendingErpTuitionInfo.getUiDocumentNumber());
        }
        if (AcademicTreasuryConstants.isZero(deltaAmount)) {
            throw new ERPTuitionInfoNoDifferencesException("error.ErpTuitionInfo.no.differences.from.last.successul.exportation", new String[0]);
        }
        return ERPTuitionInfo.create((Customer)customer, type, totalAmount, deltaAmount, executionYear.getBeginLocalDate(), executionYear.getEndLocalDate(), lastIntegratedWithSuccess.orElse(null));
    }

    protected static Callable<ERPTuitionInfo> createTuitionInformationCallable(final PersonCustomer customer, final ERPTuitionInfoType type, final List<ERPTuitionInfoCalculationReportEntry> reportEntries) {
        return new Callable<ERPTuitionInfo>(){
            private String customerId;
            private String erpTuitionInfoTypeId;
            public static final Advice advice$call = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
            public static final Advice advice$call$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
            {
                this.customerId = customer.getExternalId();
                this.erpTuitionInfoTypeId = type.getExternalId();
            }

            @Override
            public ERPTuitionInfo call() throws Exception {
                return (ERPTuitionInfo)((Object)advice$call.perform((Callable)new ERPTuitionInfo$3$callable$call(this)));
            }

            static /* synthetic */ ERPTuitionInfo advised$call(3 this_) throws Exception {
                if (!ERPTuitionInfoSettings.getInstance().isExportationActive()) {
                    throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.exportation.active.disabled", new String[0]);
                }
                ERPTuitionInfoCalculationReportEntry reportEntry = new ERPTuitionInfoCalculationReportEntry();
                this_.reportEntries.add(reportEntry);
                try {
                    PersonCustomer c = (PersonCustomer)FenixFramework.getDomainObject((String)this_.customerId);
                    ERPTuitionInfoType t = (ERPTuitionInfoType)FenixFramework.getDomainObject((String)this_.erpTuitionInfoTypeId);
                    reportEntry.executionDate = DateTime.now().toString("yyyy/MM/dd HH:mm:ss");
                    reportEntry.studentNumber = c.getAssociatedPerson().getStudent().getNumber().toString();
                    reportEntry.studentName = c.getName();
                    reportEntry.customerFiscalNumber = c.getUiFiscalNumber();
                    reportEntry.erpTuitionInfoTypeCode = t.getErpTuitionInfoProduct().getCode();
                    reportEntry.erpTuitionInfoTypeName = t.getErpTuitionInfoProduct().getName();
                    reportEntry.executionYearQualifiedName = t.getExecutionYear().getQualifiedName();
                    ERPTuitionInfo erpTuitionInfo = ERPTuitionInfo.exportTuitionInformation(c, t);
                    reportEntry.erpTuitionInfoExternalId = erpTuitionInfo.getExternalId();
                    reportEntry.erpTuitionInfoCreationDate = TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate((Object)erpTuitionInfo).toString("yyyy/MM/dd HH:mm:ss");
                    DateTime versioningUpdateDate = TreasuryPlataformDependentServicesFactory.implementation().versioningUpdateDate((Object)erpTuitionInfo);
                    reportEntry.erpTuitionInfoUpdateDate = versioningUpdateDate != null ? versioningUpdateDate.toString("yyyy/MM/dd HH:mm:ss") : "";
                    reportEntry.erpTuitionInfoDocumentNumber = erpTuitionInfo.getUiDocumentNumber();
                    reportEntry.totalAmount = erpTuitionInfo.getTuitionTotalAmount().toString();
                    reportEntry.deltaAmount = erpTuitionInfo.getTuitionDeltaAmount().toString();
                    return erpTuitionInfo;
                }
                catch (ERPTuitionInfoNoDifferencesException e) {
                    this_.reportEntries.remove(reportEntry);
                    throw e;
                }
                catch (AcademicTreasuryDomainException e) {
                    reportEntry.errorOccured = Boolean.TRUE.toString();
                    reportEntry.errorDescription = e.getLocalizedMessage();
                    throw e;
                }
                catch (TreasuryDomainException e) {
                    reportEntry.errorOccured = Boolean.TRUE.toString();
                    reportEntry.errorDescription = e.getLocalizedMessage();
                    throw e;
                }
                catch (Throwable e) {
                    reportEntry.errorOccured = Boolean.TRUE.toString();
                    reportEntry.errorDescription = e.getClass().getSimpleName() + " - " + e.getMessage();
                    ArrayList exceptionStackTraceList = Lists.newArrayList((Object[])ExceptionUtils.getFullStackTrace((Throwable)e).split("\n"));
                    reportEntry.errorDescription = reportEntry.errorDescription + "\n" + String.join((CharSequence)"\n", exceptionStackTraceList.subList(0, Integer.min(exceptionStackTraceList.size(), 5)));
                    throw e;
                }
            }

            static /* bridge */ /* synthetic */ Object advised$call(3 this_) throws Exception {
                return this_.call();
            }
        };
    }

    protected static Callable<ERPTuitionInfo> exportTuitionInformationCallable(final ERPTuitionInfo erpTuitionInfo) {
        if (!ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.exportation.active.disabled", new String[0]);
        }
        return new Callable<ERPTuitionInfo>(){
            private String erpTuitionInfoId;
            public static final Advice advice$call = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
            public static final Advice advice$call$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
            {
                this.erpTuitionInfoId = erpTuitionInfo.getExternalId();
            }

            @Override
            public ERPTuitionInfo call() throws Exception {
                return (ERPTuitionInfo)((Object)advice$call.perform((Callable)new ERPTuitionInfo$4$callable$call(this)));
            }

            static /* synthetic */ ERPTuitionInfo advised$call(4 this_) throws Exception {
                ERPTuitionInfo info = (ERPTuitionInfo)FenixFramework.getDomainObject((String)this_.erpTuitionInfoId);
                info.export();
                return info;
            }

            static /* bridge */ /* synthetic */ Object advised$call(4 this_) throws Exception {
                return this_.call();
            }
        };
    }

    static {
        advice$markToInfoExport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$exportTuitionInformation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        COMPARE_BY_CREATION_DATE = new Comparator<ERPTuitionInfo>(){

            @Override
            public int compare(ERPTuitionInfo o1, ERPTuitionInfo o2) {
                int c = o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }

    private static class ERPTuitionInfoCalculationReportEntry
    implements SpreadsheetRow {
        private String executionDate;
        private String studentNumber;
        private String studentName;
        private String customerFiscalNumber;
        private String erpTuitionInfoTypeCode;
        private String erpTuitionInfoTypeName;
        private String executionYearQualifiedName;
        private String erpTuitionInfoExternalId;
        private String erpTuitionInfoCreationDate;
        private String erpTuitionInfoUpdateDate;
        private String erpTuitionInfoDocumentNumber;
        private String totalAmount;
        private String deltaAmount;
        private String errorOccured;
        private String errorDescription;

        private ERPTuitionInfoCalculationReportEntry() {
        }

        public void writeCellValues(Row row, IErrorsLog log) {
            int i = 0;
            row.createCell(i++).setCellValue(this.executionDate);
            row.createCell(i++).setCellValue(this.studentNumber);
            row.createCell(i++).setCellValue(this.studentName);
            row.createCell(i++).setCellValue(this.customerFiscalNumber);
            row.createCell(i++).setCellValue(this.erpTuitionInfoTypeCode);
            row.createCell(i++).setCellValue(this.erpTuitionInfoTypeName);
            row.createCell(i++).setCellValue(this.executionYearQualifiedName);
            row.createCell(i++).setCellValue(this.erpTuitionInfoExternalId);
            row.createCell(i++).setCellValue(this.erpTuitionInfoCreationDate);
            row.createCell(i++).setCellValue(this.erpTuitionInfoUpdateDate);
            row.createCell(i++).setCellValue(this.erpTuitionInfoDocumentNumber);
            row.createCell(i++).setCellValue(this.totalAmount);
            row.createCell(i++).setCellValue(this.deltaAmount);
            row.createCell(i++).setCellValue(this.errorOccured);
            row.createCell(i++).setCellValue(this.errorDescription);
        }
    }
}

