/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.exemptions.requests;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.exemptions.requests.ExemptionsGenerationRequestFile$callable$create;
import org.fenixedu.academictreasury.domain.exemptions.requests.ExemptionsGenerationRequestFile$callable$process;
import org.fenixedu.academictreasury.domain.exemptions.requests.ExemptionsGenerationRequestFile_Base;
import org.fenixedu.academictreasury.domain.exemptions.requests.ExemptionsGenerationRowResult;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.util.ExcelUtils;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExemptionsGenerationRequestFile
extends ExemptionsGenerationRequestFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";
    public static final Comparator<ExemptionsGenerationRequestFile> COMPARE_BY_CREATION_DATE;
    private static final int MAX_COLS = 24;
    private static final int STUDENT_NUMBER_IDX = 0;
    private static final int STUDENT_NAME_IDX = 1;
    private static final int DEGREE_IDX = 2;
    private static final int EXECUTION_YEAR_IDX = 3;
    private static final int TREASURY_EVENT_IDX = 4;
    private static final int DEBIT_ENTRY_IDX = 5;
    private static final int REASON_IDX = 6;
    private static final int AMOUNT_TO_EXEMPT_IDX = 7;
    private static final int TUITION_INSTALLMENT_ORDER_IDX = 8;
    public static final Advice advice$process;
    public static final Advice advice$create;

    protected ExemptionsGenerationRequestFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected ExemptionsGenerationRequestFile(TreasuryExemptionType treasuryExemptionType, String filename, byte[] content) {
        this();
        this.setTreasuryExemptionType(treasuryExemptionType);
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile((IGenericFile)this, filename, CONTENT_TYPE, content);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.bennu.required", new String[0]);
        }
        if (this.getTreasuryExemptionType() == null) {
            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.treasuryExemptionType.required", new String[0]);
        }
    }

    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember((String)username);
    }

    public void process() {
        Object object = advice$process.perform((Callable)new ExemptionsGenerationRequestFile$callable$process(this));
    }

    static /* synthetic */ void advised$process(ExemptionsGenerationRequestFile this_) {
        List<ExemptionsGenerationRowResult> rowResult = ExemptionsGenerationRequestFile.readExcel(this_.getTreasuryExemptionType(), this_.getContent());
        for (ExemptionsGenerationRowResult row : rowResult) {
            try {
                if (row.isTreasuryEventForRegistrationTuition()) {
                    Iterator iterator = row.getTuitionInstallmentsOrderSet().iterator();
                    while (iterator.hasNext()) {
                        int installmentOrder = (Integer)iterator.next();
                        DebitEntry tuitionDebitEntry = row.getTuitionDebitEntry(installmentOrder);
                        if (tuitionDebitEntry == null) continue;
                        TreasuryExemption.create((TreasuryExemptionType)this_.getTreasuryExemptionType(), (TreasuryEvent)row.getTreasuryEvent(), (String)row.getReason(), (BigDecimal)row.getDiscountAmount(installmentOrder), (DebitEntry)tuitionDebitEntry);
                    }
                    continue;
                }
                TreasuryExemption.create((TreasuryExemptionType)this_.getTreasuryExemptionType(), (TreasuryEvent)row.getTreasuryEvent(), (String)row.getReason(), (BigDecimal)row.getDiscountAmount(), (DebitEntry)row.getDebitEntry());
            }
            catch (DomainException e) {
                throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.unable.to.create.exemption", String.valueOf(row.getRowNum()), String.valueOf(row.getRegistration().getNumber()), row.getRegistration().getStudent().getName(), e.getLocalizedMessage());
            }
        }
        DateTime now = new DateTime();
        this_.setWhenProcessed(now);
    }

    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        this.setTreasuryExemptionType(null);
        services.deleteFile((IGenericFile)this);
        super.deleteDomainObject();
    }

    public static Stream<ExemptionsGenerationRequestFile> findAll() {
        return FenixFramework.getDomainRoot().getExemptionsGenerationRequestFileSet().stream();
    }

    public static ExemptionsGenerationRequestFile create(TreasuryExemptionType treasuryExemptionType, String string, byte[] byArray) {
        return (ExemptionsGenerationRequestFile)((Object)advice$create.perform((Callable)new ExemptionsGenerationRequestFile$callable$create(treasuryExemptionType, string, byArray)));
    }

    static /* synthetic */ ExemptionsGenerationRequestFile advised$create(TreasuryExemptionType treasuryExemptionType, String filename, byte[] content) {
        return new ExemptionsGenerationRequestFile(treasuryExemptionType, filename, content);
    }

    public static List<ExemptionsGenerationRowResult> readExcel(TreasuryExemptionType treasuryExemptionType, byte[] content) {
        try {
            if (treasuryExemptionType == null) {
                throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.treasuryExemptionType.required", new String[0]);
            }
            List<List<String>> data = ExcelUtils.readExcel(new ByteArrayInputStream(content), 24);
            ArrayList result = Lists.newArrayList();
            int rowNum = 0;
            for (List<String> row : data) {
                Product product;
                if (++rowNum == 1) continue;
                String studentNumberValue = ExemptionsGenerationRequestFile.trim(row.get(0));
                String studentNameValue = ExemptionsGenerationRequestFile.trim(row.get(1));
                String degreeCodeValue = ExemptionsGenerationRequestFile.trim(row.get(2));
                String executionYearValue = ExemptionsGenerationRequestFile.trim(row.get(3));
                String treasuryEventValue = ExemptionsGenerationRequestFile.trim(row.get(4));
                String debitEntryValue = ExemptionsGenerationRequestFile.trim(row.get(5));
                String reasonValue = ExemptionsGenerationRequestFile.trim(row.get(6));
                String amountToExemptValue = ExemptionsGenerationRequestFile.trim(row.get(7));
                if (Strings.isNullOrEmpty((String)studentNumberValue)) continue;
                if (Strings.isNullOrEmpty((String)studentNameValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.student.name.required", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)degreeCodeValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.degree.code.required", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)executionYearValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.execution.year.required", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)treasuryEventValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.treasuryEvent.required", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)amountToExemptValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.amountToExempt.required", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)reasonValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.reasonValue.required", String.valueOf(rowNum));
                }
                int registrationNumber = -1;
                try {
                    registrationNumber = Integer.parseInt(studentNumberValue);
                }
                catch (NumberFormatException e) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.student.number.invalid", String.valueOf(rowNum), studentNumberValue);
                }
                Degree degree = Degree.find((String)degreeCodeValue);
                if (degree == null) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.degree.invalid", String.valueOf(rowNum), degreeCodeValue);
                }
                ExecutionYear executionYear = ExecutionYear.readExecutionYearByName((String)executionYearValue);
                if (executionYear == null) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.executionYear.invalid", String.valueOf(rowNum), executionYearValue);
                }
                Registration registration = ExemptionsGenerationRequestFile.findActiveRegistration(executionYear, registrationNumber, degree, null, rowNum);
                if (registration == null) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.registration.not.found", String.valueOf(rowNum), studentNumberValue, degreeCodeValue, degree.getPresentationName());
                }
                if (!registration.getStudent().getName().trim().equals(studentNameValue)) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.student.name.not.equal", String.valueOf(rowNum), studentNameValue, registration.getStudent().getName().trim());
                }
                Person person = registration.getPerson();
                String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
                String fiscalNumber = PersonCustomer.fiscalNumber(person);
                if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                    throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
                }
                if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.student.has.no.debt.account", String.valueOf(rowNum), studentNumberValue);
                }
                PersonCustomer personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get();
                if (!personCustomer.isActive()) {
                    throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", addressFiscalCountryCode, fiscalNumber);
                }
                TreasuryEvent treasuryEvent = null;
                Set treasuryEventsSet = AcademicTreasuryEvent.findByDescription(person, treasuryEventValue, true).collect(Collectors.toSet());
                if (treasuryEventsSet.size() > 0) {
                    if (treasuryEventsSet.size() > 1) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.found.more.than.one.treasuryEvent", String.valueOf(rowNum), treasuryEventValue);
                    }
                    treasuryEvent = (TreasuryEvent)treasuryEventsSet.iterator().next();
                }
                if (treasuryEvent == null && (product = (Product)Product.findByName((String)treasuryEventValue).findFirst().orElse(null)) != null) {
                    if (product == TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get().getCurrentProduct()) {
                        treasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).orElse(null);
                    } else if (AcademicTax.findUnique(product).isPresent()) {
                        treasuryEvent = AcademicTreasuryEvent.findUniqueForAcademicTax(registration, executionYear, AcademicTax.findUnique(product).get()).orElse(null);
                    }
                }
                if (treasuryEvent == null) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.treasuryEvent.invalid", String.valueOf(rowNum), treasuryEventValue);
                }
                DebitEntry debitEntry = null;
                if (!Strings.isNullOrEmpty((String)debitEntryValue)) {
                    Set debitEntries = DebitEntry.findActiveByDescription((TreasuryEvent)treasuryEvent, (String)debitEntryValue, (boolean)true).collect(Collectors.toSet());
                    if (debitEntries.size() == 0) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.debitEntry.invalid", String.valueOf(rowNum), debitEntryValue, treasuryEvent.getDescription().getContent());
                    }
                    if (debitEntries.size() > 1) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.debitEntry.found.more.than.one", String.valueOf(rowNum), debitEntryValue, treasuryEvent.getDescription().getContent());
                    }
                    debitEntry = (DebitEntry)debitEntries.iterator().next();
                }
                BigDecimal amountToExempt = null;
                try {
                    amountToExempt = new BigDecimal(amountToExemptValue);
                }
                catch (NumberFormatException e) {
                    throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.amountToExempt.invalid", String.valueOf(rowNum), amountToExemptValue);
                }
                TreeSet tuitionInstallmentsOrderSet = Sets.newTreeSet();
                if (ExemptionsGenerationRequestFile.isTreasuryEventForRegistrationTuition(treasuryEvent)) {
                    for (int i = 8; i < row.size(); ++i) {
                        String installmentOrderValue = ExemptionsGenerationRequestFile.trim(row.get(i));
                        if (Strings.isNullOrEmpty((String)installmentOrderValue)) continue;
                        int installmentOrder = -1;
                        try {
                            installmentOrder = Integer.parseInt(installmentOrderValue);
                        }
                        catch (NumberFormatException e) {
                            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.installmentOrder.invalid", String.valueOf(rowNum), installmentOrderValue);
                        }
                        if (installmentOrder <= 0) {
                            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.installmentOrder.invalid", String.valueOf(rowNum), installmentOrderValue);
                        }
                        int installmentOrderFinal = installmentOrder;
                        if (installmentOrderFinal <= 0) continue;
                        Set debitEntriesSet = DebitEntry.findActive((TreasuryEvent)treasuryEvent).filter(d -> d.getProduct().getTuitionInstallmentOrder() == installmentOrderFinal).collect(Collectors.toSet());
                        if (debitEntriesSet.size() > 1) {
                            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.installmentOrder.debit.entries.found.more.than.one", String.valueOf(rowNum), installmentOrderValue);
                        }
                        if (debitEntriesSet.isEmpty()) {
                            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.installmentOrder.debit.entries.not.found", String.valueOf(rowNum), installmentOrderValue);
                        }
                        DebitEntry tuitionDebitEntry = (DebitEntry)debitEntriesSet.iterator().next();
                        if (TreasuryConstants.isLessThan((BigDecimal)amountToExempt, (BigDecimal)BigDecimal.ZERO) || TreasuryConstants.isGreaterThan((BigDecimal)amountToExempt, (BigDecimal)tuitionDebitEntry.getTotalAmount())) {
                            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.amountToExempt.invalid", String.valueOf(rowNum), amountToExemptValue);
                        }
                        tuitionInstallmentsOrderSet.add(installmentOrder);
                    }
                    if (tuitionInstallmentsOrderSet.isEmpty()) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.installmentOrders.required", String.valueOf(rowNum));
                    }
                }
                if (debitEntry == null && !ExemptionsGenerationRequestFile.isTreasuryEventForRegistrationTuition(treasuryEvent)) {
                    Set debitEntries = DebitEntry.findActive((TreasuryEvent)treasuryEvent).collect(Collectors.toSet());
                    if (debitEntries.size() == 0) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.event.has.no.debitEntries", String.valueOf(rowNum), treasuryEvent.getDescription().getContent());
                    }
                    if (debitEntries.size() > 1) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.event.found.more.than.one.debit.entry", String.valueOf(rowNum), treasuryEvent.getDescription().getContent());
                    }
                    debitEntry = (DebitEntry)debitEntries.iterator().next();
                    if (TreasuryConstants.isLessThan((BigDecimal)amountToExempt, (BigDecimal)BigDecimal.ZERO) || TreasuryConstants.isGreaterThan((BigDecimal)amountToExempt, (BigDecimal)debitEntry.getTotalAmount())) {
                        throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.amountToExempt.invalid", String.valueOf(rowNum), amountToExemptValue);
                    }
                }
                ExemptionsGenerationRowResult rowResult = new ExemptionsGenerationRowResult(rowNum, registration, executionYear, treasuryEvent, debitEntry, amountToExempt, reasonValue, tuitionInstallmentsOrderSet);
                result.add(rowResult);
            }
            if (result.isEmpty()) {
                throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.result.empty", new String[0]);
            }
            return result;
        }
        catch (IOException e) {
            throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.invalid.sheet", new String[0]);
        }
    }

    private static boolean isTreasuryEventForRegistrationTuition(TreasuryEvent treasuryEvent) {
        return treasuryEvent instanceof AcademicTreasuryEvent && ((AcademicTreasuryEvent)treasuryEvent).isTuitionEvent();
    }

    private static Registration findActiveRegistration(ExecutionYear executionYear, int registrationNumber, Degree degree, String dcpName, int rowNum) {
        Registration result = null;
        for (Registration registration : Registration.readByNumber((Integer)registrationNumber)) {
            if (registration.getLastStateType() == null || !registration.getLastStateType().isActive() || registration.getDegree() != degree || !Strings.isNullOrEmpty((String)dcpName) && registration.getStudentCurricularPlan(executionYear) == null || Strings.isNullOrEmpty((String)dcpName) && registration.getLastStudentCurricularPlan() == null || !Strings.isNullOrEmpty((String)dcpName) && !registration.getStudentCurricularPlan(executionYear).getName().equals(dcpName)) continue;
            if (result != null) {
                throw new AcademicTreasuryDomainException("error.ExemptionsGenerationRequestFile.found.more.than.one.registration", String.valueOf(rowNum));
            }
            result = registration;
        }
        return result;
    }

    private static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_CREATION_DATE = (o1, o2) -> {
            int c = o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

