/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.AggregateDebtsStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.AggregateDebtsStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.AggregateDebtsStrategy$callable$processDebtsForRegistration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AggregateDebtsStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static Logger logger;
    private static final List<String> MESSAGES_TO_IGNORE;
    public static final Advice advice$process;
    public static final Advice advice$process$1;
    public static final Advice advice$processDebtsForRegistration;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return true;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return false;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return false;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return false;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        return (List)advice$process.perform((Callable)new AggregateDebtsStrategy$callable$process(this, academicDebtGenerationRule));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(AggregateDebtsStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        ArrayList resultList = Lists.newArrayList();
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : degreeCurricularPlan.getRegistrations()) {
                if (!rule.isRuleToApply(registration) || registration.getStudentCurricularPlan(rule.getExecutionYear()) == null || !rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) continue;
                AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
                resultList.add(result);
                try {
                    this_.processDebtsForRegistration(rule, registration);
                }
                catch (AcademicTreasuryDomainException e) {
                    result.markException((Exception)((Object)e));
                    if (MESSAGES_TO_IGNORE.contains(e.getMessage())) continue;
                    logger.debug(e.getMessage());
                }
                catch (Exception e) {
                    result.markException(e);
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        return (List)advice$process$1.perform((Callable)new AggregateDebtsStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(AggregateDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
        try {
            if (!rule.isRuleToApply(registration)) {
                return Lists.newArrayList();
            }
            if (registration.getStudentCurricularPlan(rule.getExecutionYear()) == null) {
                return Lists.newArrayList();
            }
            if (!rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) {
                return Lists.newArrayList();
            }
            this_.processDebtsForRegistration(rule, registration);
            result.markProcessingEndDateTime();
        }
        catch (AcademicTreasuryDomainException e) {
            result.markException((Exception)((Object)e));
            if (!MESSAGES_TO_IGNORE.contains(e.getMessage())) {
                logger.info(e.getMessage());
            }
        }
        catch (Exception e) {
            result.markException(e);
            e.printStackTrace();
        }
        return Lists.newArrayList((Object[])new AcademicDebtGenerationProcessingResult[]{result});
    }

    private void processDebtsForRegistration(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$processDebtsForRegistration.perform((Callable)new AggregateDebtsStrategy$callable$processDebtsForRegistration(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$processDebtsForRegistration(AggregateDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        HashSet debitEntries = Sets.newHashSet();
        DebitEntry grabbedDebitEntry = null;
        for (AcademicDebtGenerationRuleEntry entry : rule.getAcademicDebtGenerationRuleEntriesSet()) {
            Product product = entry.getProduct();
            if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == product.getProductGroup()) {
                grabbedDebitEntry = this_.grabDebitEntryForTuition(rule, registration, entry);
            } else if (AcademicTax.findUnique(product).isPresent()) {
                grabbedDebitEntry = this_.grabDebitEntryForAcademicTax(rule, registration, entry);
            }
            if (grabbedDebitEntry == null) continue;
            debitEntries.add(grabbedDebitEntry);
        }
        if (debitEntries.isEmpty()) {
            return;
        }
        if (!rule.isAggregateOnDebitNote()) {
            return;
        }
        DebitNote debitNote = this_.grabPreparingOrCreateDebitNote(debitEntries);
        for (DebitEntry debitEntry : debitEntries) {
            if (debitEntry.getFinantialDocument() == null) {
                debitEntry.setFinantialDocument((FinantialDocument)debitNote);
            }
            if (debitNote.getPayorDebtAccount() == null && debitEntry.getPayorDebtAccount() != null) {
                debitNote.updatePayorDebtAccount(debitEntry.getPayorDebtAccount());
            }
            if (debitEntry.getDebtAccount() == debitNote.getDebtAccount()) continue;
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.entry.debtAccount.not.equal.debit.note.debtAccount", new String[0]);
        }
        if (debitNote.getFinantialDocumentEntriesSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.note.without.debit.entries", new String[0]);
        }
        if (rule.isAggregateAllOrNothing()) {
            for (DebitEntry debitEntry : debitEntries) {
                if (debitEntry.getFinantialDocument() == debitNote) continue;
                throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.entries.not.aggregated.on.same.debit.note", new String[0]);
            }
            for (Product product : rule.getAcademicDebtGenerationRuleEntriesSet().stream().map(AcademicDebtGenerationRuleEntry_Base::getProduct).collect(Collectors.toSet())) {
                if (debitNote.getDebitEntries().filter(l -> l.getProduct() == product).count() != 0L) continue;
                throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.entries.not.aggregated.on.same.debit.note", new String[0]);
            }
        }
    }

    private DebitEntry grabDebitEntryForAcademicTax(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        AcademicTax academicTax;
        if (registration.getPerson().getPersonCustomer() == null) {
            return null;
        }
        PersonCustomer personCustomer = registration.getPerson().getPersonCustomer();
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax = AcademicTax.findUnique(product).get());
        if (t == null || !t.isChargedWithDebitEntry()) {
            return null;
        }
        if (t != null && t.isChargedWithDebitEntry()) {
            return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(personCustomer, (TreasuryEvent)t).filter(d -> d.isInDebt()).findFirst().orElse(null);
        }
        return null;
    }

    private DebitEntry grabDebitEntryForTuition(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        if (registration.getPerson().getPersonCustomer() == null) {
            return null;
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (t == null || !t.isChargedWithDebitEntry(product)) {
            return null;
        }
        if (!t.isChargedWithDebitEntry(product)) {
            return null;
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(registration.getPerson().getPersonCustomer(), (TreasuryEvent)t, product).filter(d -> d.isInDebt()).findFirst().orElse(null);
    }

    private DebitNote grabPreparingOrCreateDebitNote(Set<DebitEntry> debitEntries) {
        for (DebitEntry debitEntry : debitEntries) {
            if (debitEntry.getFinantialDocument() == null || !debitEntry.getFinantialDocument().isPreparing()) continue;
            return (DebitNote)debitEntry.getFinantialDocument();
        }
        DebitNote debitNote = DebitNote.create((DebtAccount)debitEntries.iterator().next().getDebtAccount(), (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debitEntries.iterator().next().getDebtAccount().getFinantialInstitution()).get()), (DateTime)new DateTime());
        return debitNote;
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$processDebtsForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(AggregateDebtsStrategy.class);
        MESSAGES_TO_IGNORE = Lists.newArrayList((Object[])new String[]{"error.AcademicDebtGenerationRule.debit.note.without.debit.entries"});
    }
}

