/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.FirstTimeFirstYearRestriction_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;

public class FirstTimeFirstYearRestriction
extends FirstTimeFirstYearRestriction_Base {
    public FirstTimeFirstYearRestriction() {
    }

    protected FirstTimeFirstYearRestriction(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        this();
        super.init(rule, excludeIfMatches);
    }

    public LocalizedString getName() {
        return FirstTimeFirstYearRestriction.RESTRICTION_NAME();
    }

    public List<LocalizedString> getParametersDescriptions() {
        return Collections.emptyList();
    }

    private boolean evaluateResult(Registration registration) {
        return TuitionPaymentPlan.firstTimeStudent(registration, this.getAcademicDebtGenerationRule().getExecutionYear());
    }

    public boolean test(Registration registration) {
        return this.isToInclude() ? this.evaluateResult(registration) : !this.evaluateResult(registration);
    }

    public FirstTimeFirstYearRestriction makeCopy(AcademicDebtGenerationRule ruleToCreate) {
        return FirstTimeFirstYearRestriction.create(ruleToCreate, this.getExcludeIfMatches());
    }

    public static FirstTimeFirstYearRestriction create(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        return new FirstTimeFirstYearRestriction(rule, excludeIfMatches);
    }

    public static LocalizedString RESTRICTION_NAME() {
        return AcademicTreasuryConstants.academicTreasuryBundleI18N("label.FirstTimeFirstYearRestriction.restrictionName", new String[0]);
    }
}

