/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.EnrolmentRenewalRestriction_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;

public class EnrolmentRenewalRestriction
extends EnrolmentRenewalRestriction_Base {
    public EnrolmentRenewalRestriction() {
    }

    public EnrolmentRenewalRestriction(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        this();
        super.init(rule, excludeIfMatches);
    }

    public LocalizedString getName() {
        return EnrolmentRenewalRestriction.RESTRICTION_NAME();
    }

    public List<LocalizedString> getParametersDescriptions() {
        return Collections.emptyList();
    }

    private boolean evaluateResult(Registration registration) {
        return !TuitionPaymentPlan.firstTimeStudent(registration, this.getAcademicDebtGenerationRule().getExecutionYear());
    }

    public boolean test(Registration registration) {
        return this.isToInclude() ? this.evaluateResult(registration) : !this.evaluateResult(registration);
    }

    public EnrolmentRenewalRestriction makeCopy(AcademicDebtGenerationRule ruleToCreate) {
        return EnrolmentRenewalRestriction.create(ruleToCreate, this.getExcludeIfMatches());
    }

    public static EnrolmentRenewalRestriction create(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        return new EnrolmentRenewalRestriction(rule, excludeIfMatches);
    }

    public static LocalizedString RESTRICTION_NAME() {
        return AcademicTreasuryConstants.academicTreasuryBundleI18N("label.EnrolmentRenewalRestriction.restrictionName", new String[0]);
    }
}

