/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.DebtsWithNoPaymentCodeReferencesRestriction_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;

public class DebtsWithNoPaymentCodeReferencesRestriction
extends DebtsWithNoPaymentCodeReferencesRestriction_Base {
    public DebtsWithNoPaymentCodeReferencesRestriction() {
    }

    protected DebtsWithNoPaymentCodeReferencesRestriction(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        this();
        super.init(rule, excludeIfMatches);
    }

    public LocalizedString getName() {
        return DebtsWithNoPaymentCodeReferencesRestriction.RESTRICTION_NAME();
    }

    public List<LocalizedString> getParametersDescriptions() {
        return Collections.emptyList();
    }

    private boolean evaluateResult(Registration registration) {
        for (DebitEntry debitEntry : CreatePaymentReferencesStrategy.grabDebitEntries(this.getAcademicDebtGenerationRule(), registration)) {
            if (MultipleEntriesPaymentCode.find((DebitEntry)debitEntry).filter(p -> !p.getPaymentReferenceCode().isAnnulled()).count() <= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean test(Registration registration) {
        return this.isToInclude() ? this.evaluateResult(registration) : !this.evaluateResult(registration);
    }

    public DebtsWithNoPaymentCodeReferencesRestriction makeCopy(AcademicDebtGenerationRule ruleToCreate) {
        return DebtsWithNoPaymentCodeReferencesRestriction.create(ruleToCreate, this.getExcludeIfMatches());
    }

    public static DebtsWithNoPaymentCodeReferencesRestriction create(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        return new DebtsWithNoPaymentCodeReferencesRestriction(rule, excludeIfMatches);
    }

    public static LocalizedString RESTRICTION_NAME() {
        return AcademicTreasuryConstants.academicTreasuryBundleI18N("label.DebtsWithNoPaymentCodeReferences.restrictionName", new String[0]);
    }
}

